/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.controller;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

class TouchScreen {
    private Matrix matrix = new Matrix();
    private Matrix savedMatrix = new Matrix();
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private int mode = 0;
    private PointF start = new PointF();
    private PointF mid = new PointF();
    private float oldDist = 1.0f;
    private float d = 0.0f;
    private float newRot = 0.0f;
    private float[] lastEvent = null;

    TouchScreen() {
    }

    public boolean onTouch(View v, MotionEvent event) {
        ImageView view = (ImageView)v;
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.savedMatrix.set(this.matrix);
                this.start.set(event.getX(), event.getY());
                this.mode = 1;
                this.lastEvent = null;
                break;
            }
            case 5: {
                this.oldDist = this.spacing(event);
                if (this.oldDist > 10.0f) {
                    this.savedMatrix.set(this.matrix);
                    this.midPoint(this.mid, event);
                    this.mode = 2;
                }
                this.lastEvent = new float[4];
                this.lastEvent[0] = event.getX(0);
                this.lastEvent[1] = event.getX(1);
                this.lastEvent[2] = event.getY(0);
                this.lastEvent[3] = event.getY(1);
                this.d = TouchScreen.getRotation(event);
                break;
            }
            case 1: 
            case 6: {
                this.mode = 0;
                this.lastEvent = null;
                break;
            }
            case 2: {
                if (this.mode == 1) {
                    this.matrix.set(this.savedMatrix);
                    float dx = event.getX() - this.start.x;
                    float dy = event.getY() - this.start.y;
                    this.matrix.postTranslate(dx, dy);
                    break;
                }
                if (this.mode != 2) break;
                float newDist = this.spacing(event);
                if (newDist > 10.0f) {
                    this.matrix.set(this.savedMatrix);
                    float scale = newDist / this.oldDist;
                    this.matrix.postScale(scale, scale, this.mid.x, this.mid.y);
                }
                if (this.lastEvent == null || event.getPointerCount() != 3) break;
                this.newRot = TouchScreen.getRotation(event);
                float r = this.newRot - this.d;
                float[] values = new float[9];
                this.matrix.getValues(values);
                float tx = values[2];
                float ty = values[5];
                float sx = values[0];
                float xc = (float)(view.getWidth() / 2) * sx;
                float yc = (float)(view.getHeight() / 2) * sx;
                this.matrix.postRotate(r, tx + xc, ty + yc);
            }
        }
        view.setImageMatrix(this.matrix);
        return true;
    }

    private float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private void midPoint(PointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
    }

    public static float getRotation(MotionEvent event) {
        double dx = event.getX(0) - event.getX(1);
        double dy = event.getY(0) - event.getY(1);
        double radians = Math.atan2(Math.abs(dy), Math.abs(dx));
        double degrees = Math.toDegrees(radians);
        return (float)degrees;
    }

    public static float getRotation360(MotionEvent event) {
        double dx = event.getX(0) - event.getX(1);
        double dy = event.getY(0) - event.getY(1);
        double radians = Math.atan2(Math.abs(dy), Math.abs(dx));
        double degrees = Math.toDegrees(radians);
        int square = 1;
        if (dx > 0.0 && dy == 0.0) {
            square = 1;
        } else if (dx > 0.0 && dy < 0.0) {
            square = 1;
        } else if (dx == 0.0 && dy < 0.0) {
            square = 2;
            degrees = 180.0 - degrees;
        } else if (dx < 0.0 && dy < 0.0) {
            square = 2;
            degrees = 180.0 - degrees;
        } else if (dx < 0.0 && dy == 0.0) {
            square = 3;
            degrees = 180.0 + degrees;
        } else if (dx < 0.0 && dy > 0.0) {
            square = 3;
            degrees = 180.0 + degrees;
        } else if (dx == 0.0 && dy > 0.0) {
            square = 4;
            degrees = 360.0 - degrees;
        } else if (dx > 0.0 && dy > 0.0) {
            square = 4;
            degrees = 360.0 - degrees;
        }
        return (float)degrees;
    }

    public static int getSquare(MotionEvent event) {
        double dx = event.getX(0) - event.getX(1);
        double dy = event.getY(0) - event.getY(1);
        int square = 1;
        if (dx > 0.0 && dy == 0.0) {
            square = 1;
        } else if (dx > 0.0 && dy < 0.0) {
            square = 1;
        } else if (dx == 0.0 && dy < 0.0) {
            square = 2;
        } else if (dx < 0.0 && dy < 0.0) {
            square = 2;
        } else if (dx < 0.0 && dy == 0.0) {
            square = 3;
        } else if (dx < 0.0 && dy > 0.0) {
            square = 3;
        } else if (dx == 0.0 && dy > 0.0) {
            square = 4;
        } else if (dx > 0.0 && dy > 0.0) {
            square = 4;
        }
        return square;
    }
}

