/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.entities;

import android.opengl.Matrix;
import java.nio.FloatBuffer;

public final class BoundingBox {
    private final String id;
    private final float xMin;
    private final float xMax;
    private final float yMin;
    private final float yMax;
    private final float zMin;
    private final float zMax;
    private final float[] min;
    private final float[] max;

    public static BoundingBox create(String id, FloatBuffer vertexBuffer, float[] modelMatrix) {
        float xMin = Float.MAX_VALUE;
        float xMax = Float.MIN_VALUE;
        float yMin = Float.MAX_VALUE;
        float yMax = Float.MIN_VALUE;
        float zMin = Float.MAX_VALUE;
        float zMax = Float.MIN_VALUE;
        vertexBuffer = vertexBuffer.asReadOnlyBuffer();
        vertexBuffer.position(0);
        while (vertexBuffer.hasRemaining()) {
            float vertexx = vertexBuffer.get();
            float vertexy = vertexBuffer.get();
            float vertexz = vertexBuffer.get();
            if (vertexx < xMin) {
                xMin = vertexx;
            }
            if (vertexx > xMax) {
                xMax = vertexx;
            }
            if (vertexy < yMin) {
                yMin = vertexy;
            }
            if (vertexy > yMax) {
                yMax = vertexy;
            }
            if (vertexz < zMin) {
                zMin = vertexz;
            }
            if (!(vertexz > zMax)) continue;
            zMax = vertexz;
        }
        float[] min = new float[]{xMin, yMin, zMin, 1.0f};
        float[] max = new float[]{xMax, yMax, zMax, 1.0f};
        Matrix.multiplyMV((float[])min, (int)0, (float[])modelMatrix, (int)0, (float[])min, (int)0);
        Matrix.multiplyMV((float[])max, (int)0, (float[])modelMatrix, (int)0, (float[])max, (int)0);
        return new BoundingBox(id, min[0], max[0], min[1], max[1], min[2], max[2]);
    }

    public BoundingBox(String id, float xMin, float xMax, float yMin, float yMax, float zMin, float zMax) {
        this.id = id;
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.zMin = zMin;
        this.zMax = zMax;
        this.min = new float[]{xMin, yMin, zMin, 1.0f};
        this.max = new float[]{xMax, yMax, zMax, 1.0f};
    }

    public float[] getMin() {
        return this.min;
    }

    public float[] getMax() {
        return this.max;
    }

    public float getxMin() {
        return this.xMin;
    }

    public float getxMax() {
        return this.xMax;
    }

    public float getyMin() {
        return this.yMin;
    }

    public float getyMax() {
        return this.yMax;
    }

    public float getzMin() {
        return this.zMin;
    }

    public float getzMax() {
        return this.zMax;
    }

    public float[] getCenter() {
        return new float[]{(this.xMax + this.xMin) / 2.0f, (this.yMax + this.yMin) / 2.0f, (this.zMax + this.zMin) / 2.0f};
    }

    public boolean insideBounds(float x, float y, float z) {
        return !this.outOfBound(x, y, z);
    }

    public boolean outOfBound(float x, float y, float z) {
        if (x > this.getxMax()) {
            return true;
        }
        if (x < this.getxMin()) {
            return true;
        }
        if (y < this.getyMin()) {
            return true;
        }
        if (y > this.getyMax()) {
            return true;
        }
        if (z < this.getzMin()) {
            return true;
        }
        return z > this.getzMax();
    }

    public String toString() {
        return "BoundingBox{id='" + this.id + '\'' + ", xMin=" + this.xMin + ", xMax=" + this.xMax + ", yMin=" + this.yMin + ", yMax=" + this.yMax + ", zMin=" + this.zMin + ", zMax=" + this.zMax + '}';
    }
}

