/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.entities;

import android.opengl.Matrix;
import android.util.Log;
import org.andresoviedo.app.model3D.entities.BoundingBox;
import org.andresoviedo.app.model3D.services.SceneLoader;

public class Camera {
    public static final float UP = 0.5f;
    public static final float DOWN = -0.5f;
    public static final float LEFT = 0.5f;
    public static final float RIGHT = -0.5f;
    public static final float STRAFE_LEFT = -0.5f;
    public static final float STRAFE_RIGHT = 0.5f;
    public static final int AIM = 10;
    public float xPos;
    public float yPos;
    public float zPos;
    public float xView;
    public float yView;
    public float zView;
    public float xUp;
    public float yUp;
    public float zUp;
    private SceneLoader scene;
    private final BoundingBox boundingBox = new BoundingBox("scene", -20.0f, 20.0f, -20.0f, 20.0f, -20.0f, 20.0f);
    float xStrafe = 0.0f;
    float yStrafe = 0.0f;
    float zStrafe = 0.0f;
    float currentRotationAngle;
    float[] matrix = new float[16];
    float[] buffer = new float[56];
    private long animationCounter;
    private Object[] lastAction;
    private boolean changed = false;

    public Camera() {
        this(0.0f, 0.0f, 6.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f);
    }

    public Camera(float xPos, float yPos, float zPos, float xView, float yView, float zView, float xUp, float yUp, float zUp) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
        this.xView = xView;
        this.yView = yView;
        this.zView = zView;
        this.xUp = xUp;
        this.yUp = yUp;
        this.zUp = zUp;
    }

    public void setScene(SceneLoader scene) {
        this.scene = scene;
    }

    public synchronized void animate() {
        if (this.lastAction == null || this.animationCounter == 0L) {
            this.lastAction = null;
            this.animationCounter = 100L;
            return;
        }
        String method = (String)this.lastAction[0];
        if (method.equals("translate")) {
            float dX = ((Float)this.lastAction[1]).floatValue();
            float dY = ((Float)this.lastAction[2]).floatValue();
            this.translateCameraImpl(dX * (float)this.animationCounter / 100.0f, dY * (float)this.animationCounter / 100.0f);
        } else if (method.equals("rotate")) {
            float rotZ = ((Float)this.lastAction[1]).floatValue();
            this.RotateImpl(rotZ / 100.0f * (float)this.animationCounter);
        }
        --this.animationCounter;
    }

    private void normalize() {
        float xLook = 0.0f;
        float yLook = 0.0f;
        float zLook = 0.0f;
        float xRight = 0.0f;
        float yRight = 0.0f;
        float zRight = 0.0f;
        float xArriba = 0.0f;
        float yArriba = 0.0f;
        float zArriba = 0.0f;
        xLook = this.xView - this.xPos;
        yLook = this.yView - this.yPos;
        zLook = this.zView - this.zPos;
        float vlen = Matrix.length((float)xLook, (float)yLook, (float)zLook);
        xLook /= vlen;
        yLook /= vlen;
        zLook /= vlen;
        xArriba = this.xUp - this.xPos;
        yArriba = this.yUp - this.yPos;
        zArriba = this.zUp - this.zPos;
        vlen = Matrix.length((float)xArriba, (float)yArriba, (float)zArriba);
        xArriba /= vlen;
        yArriba /= vlen;
        zArriba /= vlen;
        this.xView = xLook + this.xPos;
        this.yView = yLook + this.yPos;
        this.zView = zLook + this.zPos;
        this.xUp = xArriba + this.xPos;
        this.yUp = yArriba + this.yPos;
        this.zUp = zArriba + this.zPos;
    }

    public synchronized void MoveCameraZ(float direction) {
        if (direction == 0.0f) {
            return;
        }
        this.MoveCameraZImpl(direction);
        this.lastAction = new Object[]{"zoom", Float.valueOf(direction)};
    }

    public void MoveCameraZImpl(float direction) {
        float xLookDirection = 0.0f;
        float yLookDirection = 0.0f;
        float zLookDirection = 0.0f;
        xLookDirection = this.xView - this.xPos;
        yLookDirection = this.yView - this.yPos;
        zLookDirection = this.zView - this.zPos;
        float dp = Matrix.length((float)xLookDirection, (float)yLookDirection, (float)zLookDirection);
        this.UpdateCamera(xLookDirection /= dp, yLookDirection /= dp, zLookDirection /= dp, direction);
    }

    void UpdateCamera(float xDir, float yDir, float zDir, float dir) {
        Matrix.setIdentityM((float[])this.matrix, (int)0);
        Matrix.translateM((float[])this.matrix, (int)0, (float)(xDir * dir), (float)(yDir * dir), (float)(zDir * dir));
        Matrix.multiplyMV((float[])this.buffer, (int)0, (float[])this.matrix, (int)0, (float[])this.getLocationVector(), (int)0);
        Matrix.multiplyMV((float[])this.buffer, (int)4, (float[])this.matrix, (int)0, (float[])this.getLocationViewVector(), (int)0);
        Matrix.multiplyMV((float[])this.buffer, (int)8, (float[])this.matrix, (int)0, (float[])this.getLocationUpVector(), (int)0);
        if (this.isOutOfBounds(this.buffer)) {
            return;
        }
        this.xPos = this.buffer[0] / this.buffer[3];
        this.yPos = this.buffer[1] / this.buffer[3];
        this.zPos = this.buffer[2] / this.buffer[3];
        this.xView = this.buffer[4] / this.buffer[7];
        this.yView = this.buffer[5] / this.buffer[7];
        this.zView = this.buffer[6] / this.buffer[7];
        this.xUp = this.buffer[8] / this.buffer[11];
        this.yUp = this.buffer[9] / this.buffer[11];
        this.zUp = this.buffer[10] / this.buffer[11];
        this.pointViewToOrigin();
        this.setChanged(true);
    }

    private void pointViewToOrigin() {
        this.xView = -this.xPos;
        this.yView = -this.yPos;
        this.zView = -this.zPos;
        float length = Matrix.length((float)this.xView, (float)this.yView, (float)this.zView);
        this.xView /= length;
        this.yView /= length;
        this.zView /= length;
    }

    private boolean isOutOfBounds(float[] buffer) {
        if (this.boundingBox.outOfBound(buffer[0] / buffer[3], buffer[1] / buffer[3], buffer[2] / buffer[3])) {
            Log.i((String)"Camera", (String)"Out of scene bounds");
            return true;
        }
        return false;
    }

    public void StrafeCam(float dX, float dY) {
        float xLook = 0.0f;
        float yLook = 0.0f;
        float zLook = 0.0f;
        xLook = this.xView - this.xPos;
        yLook = this.yView - this.yPos;
        zLook = this.zView - this.zPos;
        float vlen = Matrix.length((float)xLook, (float)yLook, (float)zLook);
        xLook /= vlen;
        yLook /= vlen;
        zLook /= vlen;
        float xArriba = 0.0f;
        float yArriba = 0.0f;
        float zArriba = 0.0f;
        xArriba = this.xUp - this.xPos;
        yArriba = this.yUp - this.yPos;
        zArriba = this.zUp - this.zPos;
        vlen = Matrix.length((float)xArriba, (float)yArriba, (float)zArriba);
        float xRight = 0.0f;
        float yRight = 0.0f;
        float zRight = 0.0f;
        xRight = yLook * (zArriba /= vlen) - zLook * (yArriba /= vlen);
        yRight = zLook * (xArriba /= vlen) - xLook * zArriba;
        zRight = xLook * yArriba - yLook * xArriba;
        vlen = Matrix.length((float)xRight, (float)yRight, (float)zRight);
        float xSky = 0.0f;
        float ySky = 0.0f;
        float zSky = 0.0f;
        xSky = (yRight /= vlen) * zLook - (zRight /= vlen) * yLook;
        ySky = zRight * xLook - (xRight /= vlen) * zLook;
        zSky = xRight * yLook - yRight * xLook;
        vlen = Matrix.length((float)xSky, (float)ySky, (float)zSky);
        this.UpdateCamera(xSky /= vlen, ySky /= vlen, zSky /= vlen, dX);
    }

    public void RotateCamera(float AngleDir, float xSpeed, float ySpeed, float zSpeed) {
        float xNewLookDirection = 0.0f;
        float yNewLookDirection = 0.0f;
        float zNewLookDirection = 0.0f;
        float xLookDirection = 0.0f;
        float yLookDirection = 0.0f;
        float zLookDirection = 0.0f;
        float CosineAngle = 0.0f;
        float SineAngle = 0.0f;
        CosineAngle = (float)Math.cos(AngleDir);
        SineAngle = (float)Math.sin(AngleDir);
        xLookDirection = this.xView - this.xPos;
        yLookDirection = this.yView - this.yPos;
        zLookDirection = this.zView - this.zPos;
        float dp = 1.0f / (float)Math.sqrt(xLookDirection * xLookDirection + yLookDirection * yLookDirection + zLookDirection * zLookDirection);
        xNewLookDirection = (CosineAngle + (1.0f - CosineAngle) * xSpeed) * (xLookDirection *= dp);
        xNewLookDirection += ((1.0f - CosineAngle) * xSpeed * ySpeed - zSpeed * SineAngle) * (yLookDirection *= dp);
        yNewLookDirection = ((1.0f - CosineAngle) * xSpeed * ySpeed + zSpeed * SineAngle) * xLookDirection;
        yNewLookDirection += (CosineAngle + (1.0f - CosineAngle) * ySpeed) * yLookDirection;
        zNewLookDirection = ((1.0f - CosineAngle) * xSpeed * zSpeed - ySpeed * SineAngle) * xLookDirection;
        zNewLookDirection += ((1.0f - CosineAngle) * ySpeed * zSpeed + xSpeed * SineAngle) * yLookDirection;
        this.xView = this.xPos + (xNewLookDirection += ((1.0f - CosineAngle) * xSpeed * zSpeed + ySpeed * SineAngle) * (zLookDirection *= dp));
        this.yView = this.yPos + (yNewLookDirection += ((1.0f - CosineAngle) * ySpeed * zSpeed - xSpeed * SineAngle) * zLookDirection);
        this.zView = this.zPos + (zNewLookDirection += (CosineAngle + (1.0f - CosineAngle) * zSpeed) * zLookDirection);
    }

    public void Rotate(float incX, float incY) {
        this.RotateByMouse(10.0f + incX, 10.0f + incY, 10.0f, 10.0f);
    }

    void RotateByMouse(float mousePosX, float mousePosY, float midX, float midY) {
        float yDirection = 0.0f;
        float yRotation = 0.0f;
        if (mousePosX == midX && mousePosY == midY) {
            return;
        }
        yDirection = (midX - mousePosX) / 1.0f;
        yRotation = (midY - mousePosY) / 1.0f;
        this.currentRotationAngle -= yRotation;
        if (this.currentRotationAngle > 1.5f) {
            this.currentRotationAngle = 1.5f;
            return;
        }
        if (this.currentRotationAngle < -1.5f) {
            this.currentRotationAngle = -1.5f;
            return;
        }
        float xAxis = 0.0f;
        float yAxis = 0.0f;
        float zAxis = 0.0f;
        float xDir = 0.0f;
        float yDir = 0.0f;
        float zDir = 0.0f;
        xDir = this.xView - this.xPos;
        yDir = this.yView - this.yPos;
        zDir = this.zView - this.zPos;
        xAxis = yDir * this.zUp - zDir * this.yUp;
        yAxis = zDir * this.xUp - xDir * this.zUp;
        zAxis = xDir * this.yUp - yDir * this.xUp;
        float len = 1.0f / (float)Math.sqrt(xAxis * xAxis + yAxis * yAxis + zAxis * zAxis);
        this.RotateCamera(yRotation, xAxis *= len, yAxis *= len, zAxis *= len);
        this.RotateCamera(yDirection, 0.0f, 1.0f, 0.0f);
    }

    public synchronized void translateCamera(float dX, float dY) {
        Log.d((String)"Camera", (String)("translate:" + dX + "," + dY));
        if (dX == 0.0f && dY == 0.0f) {
            return;
        }
        this.translateCameraImpl(dX, dY);
        this.lastAction = new Object[]{"translate", Float.valueOf(dX), Float.valueOf(dY)};
    }

    public void translateCameraImpl(float dX, float dY) {
        float xLook = 0.0f;
        float yLook = 0.0f;
        float zLook = 0.0f;
        xLook = this.xView - this.xPos;
        yLook = this.yView - this.yPos;
        zLook = this.zView - this.zPos;
        float vlen = Matrix.length((float)xLook, (float)yLook, (float)zLook);
        xLook /= vlen;
        yLook /= vlen;
        zLook /= vlen;
        float xArriba = 0.0f;
        float yArriba = 0.0f;
        float zArriba = 0.0f;
        xArriba = this.xUp - this.xPos;
        yArriba = this.yUp - this.yPos;
        zArriba = this.zUp - this.zPos;
        vlen = Matrix.length((float)xArriba, (float)yArriba, (float)zArriba);
        float xRight = 0.0f;
        float yRight = 0.0f;
        float zRight = 0.0f;
        xRight = yLook * (zArriba /= vlen) - zLook * (yArriba /= vlen);
        yRight = zLook * (xArriba /= vlen) - xLook * zArriba;
        zRight = xLook * yArriba - yLook * xArriba;
        vlen = Matrix.length((float)xRight, (float)yRight, (float)zRight);
        xArriba = (yRight /= vlen) * zLook - (zRight /= vlen) * yLook;
        yArriba = zRight * xLook - (xRight /= vlen) * zLook;
        zArriba = xRight * yLook - yRight * xLook;
        vlen = Matrix.length((float)xArriba, (float)yArriba, (float)zArriba);
        xArriba /= vlen;
        yArriba /= vlen;
        zArriba /= vlen;
        float[] coordinates = new float[]{this.xPos, this.yPos, this.zPos, 1.0f, this.xView, this.yView, this.zView, 1.0f, this.xUp, this.yUp, this.zUp, 1.0f};
        if (dX != 0.0f && dY != 0.0f) {
            float rotX = (xRight *= dY) + (xArriba *= dX);
            float rotY = (yRight *= dY) + (yArriba *= dX);
            float rotZ = (zRight *= dY) + (zArriba *= dX);
            vlen = Matrix.length((float)rotX, (float)rotY, (float)rotZ);
            Camera.createRotationMatrixAroundVector(this.buffer, 24, vlen, rotX /= vlen, rotY /= vlen, rotZ /= vlen);
        } else if (dX != 0.0f) {
            Camera.createRotationMatrixAroundVector(this.buffer, 24, dX, xArriba, yArriba, zArriba);
        } else {
            Camera.createRotationMatrixAroundVector(this.buffer, 24, dY, xRight, yRight, zRight);
        }
        Camera.multiplyMMV(this.buffer, 0, this.buffer, 24, coordinates, 0);
        if (this.isOutOfBounds(this.buffer)) {
            return;
        }
        this.xPos = this.buffer[0] / this.buffer[3];
        this.yPos = this.buffer[1] / this.buffer[3];
        this.zPos = this.buffer[2] / this.buffer[3];
        this.xView = this.buffer[4] / this.buffer[7];
        this.yView = this.buffer[5] / this.buffer[7];
        this.zView = this.buffer[6] / this.buffer[7];
        this.xUp = this.buffer[8] / this.buffer[11];
        this.yUp = this.buffer[9] / this.buffer[11];
        this.zUp = this.buffer[10] / this.buffer[11];
        this.setChanged(true);
    }

    public String locationToString() {
        return this.xPos + "," + this.yPos + "," + this.zPos;
    }

    public String ToStringVector() {
        return this.xPos + "," + this.yPos + "," + this.zPos + " ; " + this.xView + "," + this.yView + "," + this.zView + " ; " + this.xUp + "," + this.yUp + "," + this.zUp;
    }

    public float[] getVectors() {
        return new float[]{this.xPos, this.yPos, this.zPos, 1.0f, this.xView, this.yView, this.yView, 1.0f, this.xUp, this.yUp, this.zUp, 1.0f};
    }

    public static void createRotationMatrixAroundVector(float[] matrix, int offset, float angle, float x, float y, float z) {
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        float cos_1 = 1.0f - cos;
        matrix[offset + 0] = cos_1 * x * x + cos;
        matrix[offset + 1] = cos_1 * x * y - z * sin;
        matrix[offset + 2] = cos_1 * z * x + y * sin;
        matrix[offset + 3] = 0.0f;
        matrix[offset + 4] = cos_1 * x * y + z * sin;
        matrix[offset + 5] = cos_1 * y * y + cos;
        matrix[offset + 6] = cos_1 * y * z - x * sin;
        matrix[offset + 7] = 0.0f;
        matrix[offset + 8] = cos_1 * z * x - y * sin;
        matrix[offset + 9] = cos_1 * y * z + x * sin;
        matrix[offset + 10] = cos_1 * z * z + cos;
        matrix[offset + 11] = 0.0f;
        matrix[offset + 12] = 0.0f;
        matrix[offset + 13] = 0.0f;
        matrix[offset + 14] = 0.0f;
        matrix[offset + 15] = 1.0f;
    }

    public static void multiplyMMV(float[] result, int retOffset, float[] matrix, int matOffet, float[] vector4Matrix, int vecOffset) {
        for (int i = 0; i < vector4Matrix.length / 4; ++i) {
            Matrix.multiplyMV((float[])result, (int)(retOffset + i * 4), (float[])matrix, (int)matOffet, (float[])vector4Matrix, (int)(vecOffset + i * 4));
        }
    }

    public float[] getLocationVector() {
        return new float[]{this.xPos, this.yPos, this.zPos, 1.0f};
    }

    public float[] getLocationViewVector() {
        return new float[]{this.xView, this.yView, this.zView, 1.0f};
    }

    public float[] getLocationUpVector() {
        return new float[]{this.xUp, this.yUp, this.zUp, 1.0f};
    }

    public String intLocationToString() {
        return this.xPos + "," + this.yPos + "," + this.zPos;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public String toString() {
        return "Camera [xPos=" + this.xPos + ", yPos=" + this.yPos + ", zPos=" + this.zPos + ", xView=" + this.xView + ", yView=" + this.yView + ", zView=" + this.zView + ", xUp=" + this.xUp + ", yUp=" + this.yUp + ", zUp=" + this.zUp + "]";
    }

    public synchronized void Rotate(float rotViewerZ) {
        if (rotViewerZ == 0.0f) {
            return;
        }
        this.RotateImpl(rotViewerZ);
        this.lastAction = new Object[]{"rotate", Float.valueOf(rotViewerZ)};
    }

    public void RotateImpl(float rotViewerZ) {
        if (Float.isNaN(rotViewerZ)) {
            Log.w((String)"Rot", (String)"NaN");
            return;
        }
        float xLook = this.xView - this.xPos;
        float yLook = this.yView - this.yPos;
        float zLook = this.zView - this.zPos;
        float vlen = Matrix.length((float)xLook, (float)yLook, (float)zLook);
        Camera.createRotationMatrixAroundVector(this.buffer, 24, rotViewerZ, xLook /= vlen, yLook /= vlen, zLook /= vlen);
        float[] coordinates = new float[]{this.xPos, this.yPos, this.zPos, 1.0f, this.xView, this.yView, this.zView, 1.0f, this.xUp, this.yUp, this.zUp, 1.0f};
        Camera.multiplyMMV(this.buffer, 0, this.buffer, 24, coordinates, 0);
        this.xPos = this.buffer[0];
        this.yPos = this.buffer[1];
        this.zPos = this.buffer[2];
        this.xView = this.buffer[4];
        this.yView = this.buffer[5];
        this.zView = this.buffer[6];
        this.xUp = this.buffer[8];
        this.yUp = this.buffer[9];
        this.zUp = this.buffer[10];
        this.setChanged(true);
    }
}

