/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.model;

import android.opengl.Matrix;
import java.nio.FloatBuffer;
import org.andresoviedo.app.model3D.animation.Animation;
import org.andresoviedo.app.model3D.model.Object3DData;
import org.andresoviedo.app.model3D.services.collada.entities.Joint;

public class AnimatedModel
extends Object3DData {
    private Joint rootJoint;
    private int jointCount;
    private FloatBuffer jointIds;
    private FloatBuffer vertexWeigths;
    private Animation animation;

    public AnimatedModel(FloatBuffer vertexArrayBuffer) {
        super(vertexArrayBuffer);
    }

    public AnimatedModel setRootJoint(Joint rootJoint, int jointCount) {
        this.rootJoint = rootJoint;
        this.jointCount = jointCount;
        float[] parentTransform = new float[16];
        Matrix.setIdentityM((float[])parentTransform, (int)0);
        rootJoint.calcInverseBindTransform(parentTransform);
        return this;
    }

    public int getJointCount() {
        return this.jointCount;
    }

    public AnimatedModel setJointCount(int jointCount) {
        this.jointCount = jointCount;
        return this;
    }

    public AnimatedModel setJointIds(FloatBuffer jointIds) {
        this.jointIds = jointIds;
        return this;
    }

    public FloatBuffer getJointIds() {
        return this.jointIds;
    }

    public AnimatedModel setVertexWeights(FloatBuffer vertexWeigths) {
        this.vertexWeigths = vertexWeigths;
        return this;
    }

    public FloatBuffer getVertexWeights() {
        return this.vertexWeigths;
    }

    public AnimatedModel doAnimation(Animation animation) {
        this.animation = animation;
        return this;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public Joint getRootJoint() {
        return this.rootJoint;
    }

    public float[][] getJointTransforms() {
        float[][] jointMatrices = new float[this.jointCount][16];
        for (int i = 0; i < jointMatrices.length; ++i) {
            Matrix.setIdentityM((float[])jointMatrices[i], (int)0);
        }
        this.addJointsToArray(this.rootJoint, jointMatrices);
        return jointMatrices;
    }

    private void addJointsToArray(Joint headJoint, float[][] jointMatrices) {
        jointMatrices[headJoint.index] = headJoint.getAnimatedTransform();
        for (Joint childJoint : headJoint.children) {
            this.addJointsToArray(childJoint, jointMatrices);
        }
    }
}

