/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.model;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

class BoundingBox {
    protected static final int COORDS_PER_VERTEX = 3;
    protected static final int COORDS_PER_COLOR = 4;
    public FloatBuffer vertices;
    public FloatBuffer colors;
    public IntBuffer drawOrder;

    public BoundingBox(org.andresoviedo.app.model3D.entities.BoundingBox box, float[] color) {
        ByteBuffer bb = ByteBuffer.allocateDirect(96);
        bb.order(ByteOrder.nativeOrder());
        this.vertices = bb.asFloatBuffer();
        ByteBuffer bb2 = ByteBuffer.allocateDirect(96);
        bb2.order(ByteOrder.nativeOrder());
        this.drawOrder = bb2.asIntBuffer();
        ByteBuffer bb3 = ByteBuffer.allocateDirect(384);
        bb3.order(ByteOrder.nativeOrder());
        this.colors = bb3.asFloatBuffer();
        for (int i = 0; i < this.colors.capacity() / 4; ++i) {
            if (color != null && color.length == 4) {
                this.colors.put(color);
                continue;
            }
            this.colors.put(1.0f).put(0.0f).put(1.0f).put(1.0f);
        }
        this.drawOrder.put(0);
        this.drawOrder.put(1);
        this.drawOrder.put(2);
        this.drawOrder.put(3);
        this.drawOrder.put(4);
        this.drawOrder.put(5);
        this.drawOrder.put(6);
        this.drawOrder.put(7);
        this.drawOrder.put(4);
        this.drawOrder.put(5);
        this.drawOrder.put(1);
        this.drawOrder.put(0);
        this.drawOrder.put(3);
        this.drawOrder.put(2);
        this.drawOrder.put(6);
        this.drawOrder.put(7);
        this.drawOrder.put(1);
        this.drawOrder.put(2);
        this.drawOrder.put(6);
        this.drawOrder.put(5);
        this.drawOrder.put(0);
        this.drawOrder.put(3);
        this.drawOrder.put(7);
        this.drawOrder.put(4);
        this.calculateVertex(box);
    }

    public IntBuffer getDrawOrder() {
        return this.drawOrder;
    }

    public FloatBuffer getColors() {
        return this.colors;
    }

    public int getDrawMode() {
        return 2;
    }

    public int getDrawSize() {
        return 4;
    }

    public List<int[]> getDrawModeList() {
        ArrayList<int[]> ret = new ArrayList<int[]>();
        int drawOrderPos = 0;
        for (int i = 0; i < this.drawOrder.capacity(); i += 4) {
            ret.add(new int[]{2, drawOrderPos, 4});
            drawOrderPos += 4;
        }
        return ret;
    }

    private void calculateVertex(org.andresoviedo.app.model3D.entities.BoundingBox box) {
        this.vertices.put(box.getxMin()).put(box.getyMin()).put(box.getzMin());
        this.vertices.put(box.getxMin()).put(box.getyMax()).put(box.getzMin());
        this.vertices.put(box.getxMax()).put(box.getyMax()).put(box.getzMin());
        this.vertices.put(box.getxMax()).put(box.getyMin()).put(box.getzMin());
        this.vertices.put(box.getxMin()).put(box.getyMin()).put(box.getzMax());
        this.vertices.put(box.getxMin()).put(box.getyMax()).put(box.getzMax());
        this.vertices.put(box.getxMax()).put(box.getyMax()).put(box.getzMax());
        this.vertices.put(box.getxMax()).put(box.getyMin()).put(box.getzMax());
    }

    public FloatBuffer getVertices() {
        return this.vertices;
    }

    public FloatBuffer getVertexArray() {
        ByteBuffer bb = ByteBuffer.allocateDirect(this.drawOrder.capacity() * 3 * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer ret = bb.asFloatBuffer();
        ret.position(0);
        for (int i = 0; i < this.drawOrder.capacity(); ++i) {
            ret.put(this.vertices.get(this.drawOrder.get(i) * 3));
            ret.put(this.vertices.get(this.drawOrder.get(i) * 3 + 1));
            ret.put(this.vertices.get(this.drawOrder.get(i) * 3 + 2));
        }
        return ret;
    }

    public FloatBuffer getNormals() {
        return BoundingBox.createEmptyNormalsFloatBuffer(this.getVertices().capacity());
    }

    private static FloatBuffer createEmptyNormalsFloatBuffer(int size) {
        FloatBuffer buffer = BoundingBox.createNativeByteBuffer(size * 3 * 4).asFloatBuffer();
        buffer.position(0);
        for (int i = 0; i < size; ++i) {
            buffer.put(0.0f).put(1.0f).put(0.0f);
        }
        return buffer;
    }

    private static ByteBuffer createNativeByteBuffer(int length) {
        ByteBuffer bb = ByteBuffer.allocateDirect(length);
        bb.order(ByteOrder.nativeOrder());
        return bb;
    }
}

