/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.model;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.andresoviedo.app.model3D.model.AnimatedModel;
import org.andresoviedo.app.model3D.model.BoundingBox;
import org.andresoviedo.app.model3D.model.Object3D;
import org.andresoviedo.app.model3D.model.Object3DData;
import org.andresoviedo.app.model3D.model.Object3DV1;
import org.andresoviedo.app.model3D.model.Object3DV10;
import org.andresoviedo.app.model3D.model.Object3DV11;
import org.andresoviedo.app.model3D.model.Object3DV2;
import org.andresoviedo.app.model3D.model.Object3DV3;
import org.andresoviedo.app.model3D.model.Object3DV4;
import org.andresoviedo.app.model3D.model.Object3DV5;
import org.andresoviedo.app.model3D.model.Object3DV6;
import org.andresoviedo.app.model3D.model.Object3DV7;
import org.andresoviedo.app.model3D.model.Object3DV8;
import org.andresoviedo.app.model3D.model.Object3DV9;
import org.andresoviedo.app.model3D.services.WavefrontLoader;
import org.andresoviedo.app.model3D.services.collada.loader.ColladaLoader;
import org.andresoviedo.app.model3D.services.wavefront.WavefrontLoader2;
import org.andresoviedo.app.util.math.Math3DUtils;
import org.apache.commons.io.IOUtils;

public final class Object3DBuilder {
    private static final int COORDS_PER_VERTEX = 3;
    private static float[] DEFAULT_COLOR = new float[]{1.0f, 1.0f, 0.0f, 1.0f};
    static final float[] axisVertexLinesData = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.95f, 0.05f, 0.0f, 1.0f, 0.0f, 0.0f, 0.95f, -0.05f, 0.0f, 1.0f, 0.0f, 0.0f, -0.95f, 0.05f, 0.0f, -1.0f, 0.0f, 0.0f, -0.95f, -0.05f, 0.0f, -1.0f, 0.0f, 0.0f, -0.05f, 0.95f, 0.0f, 0.0f, 1.0f, 0.0f, 0.05f, 0.95f, 0.0f, 0.0f, 1.0f, 0.0f, -0.05f, 0.0f, 0.95f, 0.0f, 0.0f, 1.0f, 0.05f, 0.0f, 0.95f, 0.0f, 0.0f, 1.0f, 1.05f, 0.05f, 0.0f, 1.1f, -0.05f, 0.0f, 1.05f, -0.05f, 0.0f, 1.1f, 0.05f, 0.0f, -0.05f, 1.05f, 0.0f, 0.05f, 1.1f, 0.0f, -0.05f, 1.1f, 0.0f, 0.0f, 1.075f, 0.0f, -0.05f, 0.05f, 1.05f, 0.05f, 0.05f, 1.05f, 0.05f, 0.05f, 1.05f, -0.05f, -0.05f, 1.05f, -0.05f, -0.05f, 1.05f, 0.05f, -0.05f, 1.05f};
    static final float[] squarePositionData = new float[]{-0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f};
    static final int[] squareDrawOrderData = new int[]{0, 1, 2, 0, 2, 3, 7, 6, 5, 4, 7, 5, 4, 0, 3, 7, 4, 3, 1, 5, 6, 2, 1, 6, 4, 5, 1, 0, 4, 1, 3, 2, 6, 7, 3, 6};
    static final float[] cubePositionData = new float[]{-1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f};
    static final float[] cubeColorData = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    static final float[] cubeNormalData = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};
    static final float[] cubeTextureCoordinateData = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    private Object3DV1 object3dv1;
    private Object3DV2 object3dv2;
    private Object3DV3 object3dv3;
    private Object3DV4 object3dv4;
    private Object3DV5 object3dv5;
    private Object3DV6 object3dv6;
    private Object3DV7 object3dv7;
    private Object3DV8 object3dv8;
    private Object3DV9 object3dv9;
    private Object3DV10 object3dv10;
    private Object3DV11 object3dv11;

    public static Object3DData buildPoint(float[] point) {
        return new Object3DData(Object3DBuilder.createNativeByteBuffer(point.length * 4).asFloatBuffer().put(point)).setDrawMode(0).setId("Point");
    }

    public static Object3DData buildLine(float[] line) {
        return new Object3DData(Object3DBuilder.createNativeByteBuffer(line.length * 4).asFloatBuffer().put(line)).setDrawMode(1).setId("Line").setFaces(new WavefrontLoader.Faces(0));
    }

    public static Object3DData buildAxis() {
        return new Object3DData(Object3DBuilder.createNativeByteBuffer(axisVertexLinesData.length * 4).asFloatBuffer().put(axisVertexLinesData)).setDrawMode(1).setFaces(new WavefrontLoader.Faces(0));
    }

    public static Object3DData buildCubeV1() {
        return new Object3DData(Object3DBuilder.createNativeByteBuffer(cubePositionData.length * 4).asFloatBuffer().put(cubePositionData)).setDrawMode(4).setId("cubeV1").centerAndScale(1.0f).setFaces(new WavefrontLoader.Faces(8));
    }

    public static Object3DData buildCubeV1_with_normals() {
        return new Object3DData(Object3DBuilder.createNativeByteBuffer(cubePositionData.length * 4).asFloatBuffer().put(cubePositionData)).setVertexColorsArrayBuffer(Object3DBuilder.createNativeByteBuffer(cubeColorData.length * 4).asFloatBuffer().put(cubeColorData)).setVertexNormalsArrayBuffer(Object3DBuilder.createNativeByteBuffer(cubeNormalData.length * 4).asFloatBuffer().put(cubeNormalData)).setDrawMode(4).setId("cubeV1_light").centerAndScale(1.0f).setFaces(new WavefrontLoader.Faces(8));
    }

    public static Object3DData buildSquareV2() {
        IntBuffer drawBuffer = Object3DBuilder.createNativeByteBuffer(squareDrawOrderData.length * 4).asIntBuffer().put(squareDrawOrderData);
        FloatBuffer vertexBuffer = Object3DBuilder.createNativeByteBuffer(squarePositionData.length * 4).asFloatBuffer().put(squarePositionData);
        return new Object3DData(vertexBuffer, drawBuffer.asReadOnlyBuffer()).setDrawMode(4).setId("cubeV2").centerAndScale(1.0f).setFaces(new WavefrontLoader.Faces(8)).setDrawOrder(drawBuffer).setVertexArrayBuffer(vertexBuffer);
    }

    public static Object3DData buildCubeV3(byte[] textureData) {
        return new Object3DData(Object3DBuilder.createNativeByteBuffer(cubePositionData.length * 4).asFloatBuffer().put(cubePositionData), Object3DBuilder.createNativeByteBuffer(cubeTextureCoordinateData.length * 4).asFloatBuffer().put(cubeTextureCoordinateData).asReadOnlyBuffer(), textureData).setDrawMode(4).setId("cubeV3").centerAndScale(1.0f).setFaces(new WavefrontLoader.Faces(8));
    }

    public static Object3DData buildCubeV4(byte[] textureData) {
        return new Object3DData(Object3DBuilder.createNativeByteBuffer(cubePositionData.length * 4).asFloatBuffer().put(cubePositionData), Object3DBuilder.createNativeByteBuffer(cubeColorData.length * 4).asFloatBuffer().put(cubeColorData).asReadOnlyBuffer(), Object3DBuilder.createNativeByteBuffer(cubeTextureCoordinateData.length * 4).asFloatBuffer().put(cubeTextureCoordinateData).asReadOnlyBuffer(), textureData).setDrawMode(4).setId("cubeV4").centerAndScale(1.0f).setFaces(new WavefrontLoader.Faces(8));
    }

    public static Object3DData loadV5(AssetManager assets, String assetDir, String assetFilename) {
        try {
            String modelId = assetDir + "/" + assetFilename;
            InputStream is = assets.open(modelId);
            WavefrontLoader wfl = new WavefrontLoader(assetFilename);
            wfl.analyzeModel(is);
            is.close();
            wfl.allocateBuffers();
            is = assets.open(modelId);
            wfl.loadModel(is);
            is.close();
            Object3DData data3D = new Object3DData(wfl.getVerts(), wfl.getNormals(), wfl.getTexCoords(), wfl.getFaces(), wfl.getFaceMats(), wfl.getMaterials());
            data3D.setId(assetFilename);
            data3D.setAssetsDir(assetDir);
            data3D.setDimensions(wfl.getDimensions());
            data3D.centerScale();
            data3D.setDrawMode(4);
            Object3DBuilder.generateArrays(assets, data3D);
            return data3D;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object3D getDrawer(Object3DData obj, boolean usingTextures, boolean usingLights) throws IOException {
        if (this.object3dv2 == null) {
            this.object3dv1 = new Object3DV1();
            this.object3dv2 = new Object3DV2();
            this.object3dv3 = new Object3DV3();
            this.object3dv4 = new Object3DV4();
            this.object3dv5 = new Object3DV5();
            this.object3dv6 = new Object3DV6();
            this.object3dv7 = new Object3DV7();
            this.object3dv8 = new Object3DV8();
            this.object3dv9 = new Object3DV9();
            this.object3dv10 = new Object3DV10();
            this.object3dv11 = new Object3DV11();
        }
        if (obj instanceof AnimatedModel && ((AnimatedModel)obj).getAnimation() != null && obj.getTextureData() != null) {
            return this.object3dv9;
        }
        if (obj instanceof AnimatedModel && ((AnimatedModel)obj).getAnimation() != null && obj.getVertexColorsArrayBuffer() != null) {
            return this.object3dv11;
        }
        if (obj instanceof AnimatedModel && ((AnimatedModel)obj).getAnimation() != null) {
            return this.object3dv10;
        }
        if (usingTextures && usingLights && obj.getVertexColorsArrayBuffer() != null && obj.getTextureData() != null && obj.getTextureCoordsArrayBuffer() != null && obj.getVertexNormalsArrayBuffer() != null && obj.getVertexNormalsArrayBuffer() != null) {
            return this.object3dv6;
        }
        if (usingTextures && usingLights && obj.getVertexColorsArrayBuffer() == null && obj.getTextureData() != null && obj.getTextureCoordsArrayBuffer() != null && obj.getVertexNormalsArrayBuffer() != null && obj.getVertexNormalsArrayBuffer() != null) {
            return this.object3dv8;
        }
        if (usingLights && obj.getVertexColorsArrayBuffer() != null && obj.getVertexNormalsArrayBuffer() != null) {
            return this.object3dv5;
        }
        if (usingLights && (obj.getNormals() != null || obj.getVertexNormalsArrayBuffer() != null)) {
            return this.object3dv7;
        }
        if (usingTextures && obj.getVertexColorsArrayBuffer() != null && obj.getTextureData() != null && obj.getTextureCoordsArrayBuffer() != null) {
            return this.object3dv4;
        }
        if (usingTextures && obj.getVertexColorsArrayBuffer() == null && obj.getTextureData() != null && obj.getTextureCoordsArrayBuffer() != null) {
            return this.object3dv3;
        }
        if (obj.getVertexColorsArrayBuffer() != null) {
            return this.object3dv2;
        }
        return this.object3dv1;
    }

    public static Object3DData generateArrays(AssetManager assets, Object3DData obj) throws IOException {
        int i;
        WavefrontLoader.Faces faces = obj.getFaces();
        WavefrontLoader.FaceMaterials faceMats = obj.getFaceMats();
        WavefrontLoader.Materials materials = obj.getMaterials();
        if (faces == null) {
            Log.i((String)"Object3DBuilder", (String)"No faces. Not generating arrays");
            return obj;
        }
        Log.i((String)"Object3DBuilder", (String)("Allocating vertex array buffer... Vertices (" + faces.getVerticesReferencesCount() + ")"));
        FloatBuffer vertexArrayBuffer = Object3DBuilder.createNativeByteBuffer(faces.getVerticesReferencesCount() * 3 * 4).asFloatBuffer();
        obj.setVertexArrayBuffer(vertexArrayBuffer);
        obj.setDrawUsingArrays(true);
        Log.i((String)"Object3DBuilder", (String)"Populating vertex array...");
        FloatBuffer vertexBuffer = obj.getVerts();
        IntBuffer indexBuffer = faces.getIndexBuffer();
        for (int i2 = 0; i2 < faces.getVerticesReferencesCount(); ++i2) {
            vertexArrayBuffer.put(i2 * 3, vertexBuffer.get(indexBuffer.get(i2) * 3));
            vertexArrayBuffer.put(i2 * 3 + 1, vertexBuffer.get(indexBuffer.get(i2) * 3 + 1));
            vertexArrayBuffer.put(i2 * 3 + 2, vertexBuffer.get(indexBuffer.get(i2) * 3 + 2));
        }
        Log.i((String)"Object3DBuilder", (String)("Allocating vertex normals buffer... Total normals (" + faces.facesNormIdxs.size() + ")"));
        FloatBuffer vertexNormalsArrayBuffer = Object3DBuilder.createNativeByteBuffer(faces.getSize() * 3 * 3 * 4).asFloatBuffer();
        obj.setVertexNormalsArrayBuffer(vertexNormalsArrayBuffer);
        FloatBuffer vertexNormalsBuffer = obj.getNormals();
        if (vertexNormalsBuffer != null && vertexNormalsBuffer.capacity() > 0) {
            Log.i((String)"Object3DBuilder", (String)"Populating normals buffer...");
            for (int n = 0; n < faces.facesNormIdxs.size(); ++n) {
                int[] normal = faces.facesNormIdxs.get(n);
                for (int i3 = 0; i3 < normal.length; ++i3) {
                    vertexNormalsArrayBuffer.put(n * 9 + i3 * 3, vertexNormalsBuffer.get(normal[i3] * 3));
                    vertexNormalsArrayBuffer.put(n * 9 + i3 * 3 + 1, vertexNormalsBuffer.get(normal[i3] * 3 + 1));
                    vertexNormalsArrayBuffer.put(n * 9 + i3 * 3 + 2, vertexNormalsBuffer.get(normal[i3] * 3 + 2));
                }
            }
        } else {
            Log.i((String)"Object3DBuilder", (String)("Model without normals. Calculating [" + faces.getIndexBuffer().capacity() / 3 + "] normals..."));
            float[] v0 = new float[3];
            float[] v1 = new float[3];
            float[] v2 = new float[3];
            for (i = 0; i < faces.getIndexBuffer().capacity(); i += 3) {
                try {
                    v0[0] = vertexBuffer.get(faces.getIndexBuffer().get(i) * 3);
                    v0[1] = vertexBuffer.get(faces.getIndexBuffer().get(i) * 3 + 1);
                    v0[2] = vertexBuffer.get(faces.getIndexBuffer().get(i) * 3 + 2);
                    v1[0] = vertexBuffer.get(faces.getIndexBuffer().get(i + 1) * 3);
                    v1[1] = vertexBuffer.get(faces.getIndexBuffer().get(i + 1) * 3 + 1);
                    v1[2] = vertexBuffer.get(faces.getIndexBuffer().get(i + 1) * 3 + 2);
                    v2[0] = vertexBuffer.get(faces.getIndexBuffer().get(i + 2) * 3);
                    v2[1] = vertexBuffer.get(faces.getIndexBuffer().get(i + 2) * 3 + 1);
                    v2[2] = vertexBuffer.get(faces.getIndexBuffer().get(i + 2) * 3 + 2);
                    float[] normal = Math3DUtils.calculateFaceNormal2(v0, v1, v2);
                    vertexNormalsArrayBuffer.put(i * 3, normal[0]);
                    vertexNormalsArrayBuffer.put(i * 3 + 1, normal[1]);
                    vertexNormalsArrayBuffer.put(i * 3 + 2, normal[2]);
                    vertexNormalsArrayBuffer.put(i * 3 + 3, normal[0]);
                    vertexNormalsArrayBuffer.put(i * 3 + 4, normal[1]);
                    vertexNormalsArrayBuffer.put(i * 3 + 5, normal[2]);
                    vertexNormalsArrayBuffer.put(i * 3 + 6, normal[0]);
                    vertexNormalsArrayBuffer.put(i * 3 + 7, normal[1]);
                    vertexNormalsArrayBuffer.put(i * 3 + 8, normal[2]);
                    continue;
                }
                catch (BufferOverflowException ex) {
                    throw new RuntimeException("Error calculating mormal for face [" + i / 3 + "]");
                }
            }
        }
        FloatBuffer colorArrayBuffer = null;
        if (materials != null) {
            Log.i((String)"Object3DBuilder", (String)"Reading materials...");
            materials.readMaterials(obj.getCurrentDir(), obj.getAssetsDir(), assets);
        }
        if (materials != null && !faceMats.isEmpty()) {
            Log.i((String)"Object3DBuilder", (String)"Processing face materials...");
            colorArrayBuffer = Object3DBuilder.createNativeByteBuffer(4 * faces.getVerticesReferencesCount() * 4).asFloatBuffer();
            boolean anyOk = false;
            float[] currentColor = DEFAULT_COLOR;
            for (i = 0; i < faces.getSize(); ++i) {
                WavefrontLoader.Material mat;
                if (faceMats.findMaterial(i) != null && (mat = materials.getMaterial(faceMats.findMaterial(i))) != null) {
                    currentColor = mat.getKdColor() != null ? mat.getKdColor() : currentColor;
                    anyOk = anyOk || mat.getKdColor() != null;
                }
                colorArrayBuffer.put(currentColor);
                colorArrayBuffer.put(currentColor);
                colorArrayBuffer.put(currentColor);
            }
            if (!anyOk) {
                Log.i((String)"Object3DBuilder", (String)"Using single color.");
                colorArrayBuffer = null;
            }
        }
        obj.setVertexColorsArrayBuffer(colorArrayBuffer);
        String texture = null;
        byte[] textureData = null;
        if (materials != null && !materials.materials.isEmpty()) {
            for (WavefrontLoader.Material mat : materials.materials.values()) {
                if (mat.getTexture() == null) continue;
                texture = mat.getTexture();
                break;
            }
            if (texture != null) {
                Object fis;
                ByteArrayOutputStream bos;
                if (obj.getCurrentDir() != null) {
                    File file = new File(obj.getCurrentDir(), texture);
                    Log.i((String)"Object3DBuilder", (String)("Loading texture '" + file + "'..."));
                    bos = new ByteArrayOutputStream();
                    fis = new FileInputStream(file);
                    IOUtils.copy((InputStream)fis, (OutputStream)bos);
                    ((FileInputStream)fis).close();
                    textureData = bos.toByteArray();
                    bos.close();
                } else {
                    String assetResourceName = obj.getAssetsDir() + "/" + texture;
                    Log.i((String)"Object3DBuilder", (String)("Loading texture '" + assetResourceName + "'..."));
                    bos = new ByteArrayOutputStream();
                    fis = assets.open(assetResourceName);
                    IOUtils.copy((InputStream)fis, (OutputStream)bos);
                    ((InputStream)fis).close();
                    textureData = bos.toByteArray();
                    bos.close();
                }
            } else {
                Log.i((String)"Object3DBuilder", (String)"Found material(s) but no texture");
            }
        } else {
            Log.i((String)"Object3DBuilder", (String)"No materials -> No texture");
        }
        ArrayList<WavefrontLoader.Tuple3> texCoords = obj.getTexCoords();
        if (texCoords != null && texCoords.size() > 0) {
            Log.i((String)"Object3DBuilder", (String)"Allocating/populating texture buffer...");
            FloatBuffer textureCoordsBuffer = Object3DBuilder.createNativeByteBuffer(texCoords.size() * 2 * 4).asFloatBuffer();
            for (WavefrontLoader.Tuple3 texCor : texCoords) {
                textureCoordsBuffer.put(texCor.getX());
                textureCoordsBuffer.put(obj.isFlipTextCoords() ? 1.0f - texCor.getY() : texCor.getY());
            }
            Log.i((String)"Object3DBuilder", (String)"Populating texture array buffer...");
            FloatBuffer textureCoordsArraysBuffer = Object3DBuilder.createNativeByteBuffer(2 * faces.getVerticesReferencesCount() * 4).asFloatBuffer();
            obj.setTextureCoordsArrayBuffer(textureCoordsArraysBuffer);
            try {
                boolean anyTextureOk = false;
                String currentTexture = null;
                Log.i((String)"Object3DBuilder", (String)"Populating texture array buffer...");
                int counter = 0;
                for (int i4 = 0; i4 < faces.facesTexIdxs.size(); ++i4) {
                    WavefrontLoader.Material mat;
                    if (!faceMats.isEmpty() && faceMats.findMaterial(i4) != null && (mat = materials.getMaterial(faceMats.findMaterial(i4))) != null && mat.getTexture() != null) {
                        currentTexture = mat.getTexture();
                    }
                    boolean textureOk = false;
                    if (currentTexture != null && currentTexture.equals(texture)) {
                        textureOk = true;
                    }
                    int[] text = faces.facesTexIdxs.get(i4);
                    for (int j = 0; j < text.length; ++j) {
                        if (textureData == null || textureOk) {
                            anyTextureOk = true;
                            textureCoordsArraysBuffer.put(counter++, textureCoordsBuffer.get(text[j] * 2));
                            textureCoordsArraysBuffer.put(counter++, textureCoordsBuffer.get(text[j] * 2 + 1));
                            continue;
                        }
                        textureCoordsArraysBuffer.put(counter++, 0.0f);
                        textureCoordsArraysBuffer.put(counter++, 0.0f);
                    }
                }
                if (!anyTextureOk) {
                    Log.i((String)"Object3DBuilder", (String)"Texture is wrong. Applying global texture");
                    counter = 0;
                    for (int j = 0; j < faces.facesTexIdxs.size(); ++j) {
                        int[] text = faces.facesTexIdxs.get(j);
                        for (int i5 = 0; i5 < text.length; ++i5) {
                            textureCoordsArraysBuffer.put(counter++, textureCoordsBuffer.get(text[i5] * 2));
                            textureCoordsArraysBuffer.put(counter++, textureCoordsBuffer.get(text[i5] * 2 + 1));
                        }
                    }
                }
            }
            catch (Exception ex) {
                Log.e((String)"Object3DBuilder", (String)"Failure to load texture coordinates", (Throwable)ex);
            }
        }
        obj.setTextureData(textureData);
        return obj;
    }

    public Object3D getBoundingBoxDrawer() {
        return this.object3dv2;
    }

    public Object3D getFaceNormalsDrawer() {
        return this.object3dv1;
    }

    public Object3D getPointDrawer() {
        if (this.object3dv1 == null) {
            this.object3dv1 = new Object3DV1();
        }
        return this.object3dv1;
    }

    public static Object3DData buildBoundingBox(Object3DData obj) {
        BoundingBox boundingBox = new BoundingBox(obj.getBoundingBox(), obj.getColor());
        return new Object3DData(boundingBox.getVertices()).setDrawModeList(boundingBox.getDrawModeList()).setVertexColorsArrayBuffer(boundingBox.getColors()).setDrawOrder(boundingBox.getDrawOrder()).setDrawMode(boundingBox.getDrawMode()).setColor(obj.getColor()).setId(obj.getId() + "_boundingBox");
    }

    public static Object3DData buildWireframe(Object3DData objData) {
        if (objData.getDrawOrder() != null) {
            try {
                Log.i((String)"Object3DBuilder", (String)"Building wireframe...");
                IntBuffer drawBuffer = objData.getDrawOrder();
                IntBuffer wireframeDrawOrder = Object3DBuilder.createNativeByteBuffer(drawBuffer.capacity() * 2 * 4).asIntBuffer();
                for (int i = 0; i < drawBuffer.capacity(); i += 3) {
                    int v0 = drawBuffer.get(i);
                    int v1 = drawBuffer.get(i + 1);
                    int v2 = drawBuffer.get(i + 2);
                    if (objData.isDrawUsingArrays()) {
                        v0 = i;
                        v1 = i + 1;
                        v2 = i + 2;
                    }
                    wireframeDrawOrder.put(v0);
                    wireframeDrawOrder.put(v1);
                    wireframeDrawOrder.put(v1);
                    wireframeDrawOrder.put(v2);
                    wireframeDrawOrder.put(v2);
                    wireframeDrawOrder.put(v0);
                }
                if (objData instanceof AnimatedModel) {
                    AnimatedModel object3DData = new AnimatedModel(objData.getVertexArrayBuffer());
                    object3DData.setVertexBuffer(objData.getVertexBuffer()).setDrawOrder(wireframeDrawOrder).setVertexNormalsArrayBuffer(objData.getVertexNormalsArrayBuffer()).setColor(objData.getColor()).setVertexColorsArrayBuffer(objData.getVertexColorsArrayBuffer()).setTextureCoordsArrayBuffer(objData.getTextureCoordsArrayBuffer()).setPosition(objData.getPosition()).setRotation(objData.getRotation()).setScale(objData.getScale()).setDrawMode(1).setDrawUsingArrays(false);
                    object3DData.setVertexWeights(((AnimatedModel)objData).getVertexWeights());
                    object3DData.setJointIds(((AnimatedModel)objData).getJointIds());
                    object3DData.setRootJoint(((AnimatedModel)objData).getRootJoint(), ((AnimatedModel)objData).getJointCount());
                    object3DData.doAnimation(((AnimatedModel)objData).getAnimation());
                    return object3DData;
                }
                return new Object3DData(objData.getVertexArrayBuffer()).setVertexBuffer(objData.getVertexBuffer()).setDrawOrder(wireframeDrawOrder).setVertexNormalsArrayBuffer(objData.getVertexNormalsArrayBuffer()).setColor(objData.getColor()).setVertexColorsArrayBuffer(objData.getVertexColorsArrayBuffer()).setTextureCoordsArrayBuffer(objData.getTextureCoordsArrayBuffer()).setPosition(objData.getPosition()).setRotation(objData.getRotation()).setScale(objData.getScale()).setDrawMode(1).setDrawUsingArrays(false);
            }
            catch (Exception ex) {
                Log.e((String)"Object3DBuilder", (String)ex.getMessage(), (Throwable)ex);
            }
        } else if (objData.getVertexArrayBuffer() != null) {
            Log.i((String)"Object3DBuilder", (String)"Building wireframe...");
            FloatBuffer vertexBuffer = objData.getVertexArrayBuffer();
            IntBuffer wireframeDrawOrder = Object3DBuilder.createNativeByteBuffer(vertexBuffer.capacity() / 3 * 2 * 4).asIntBuffer();
            for (int i = 0; i < vertexBuffer.capacity() / 3; i += 3) {
                wireframeDrawOrder.put(i);
                wireframeDrawOrder.put(i + 1);
                wireframeDrawOrder.put(i + 1);
                wireframeDrawOrder.put(i + 2);
                wireframeDrawOrder.put(i + 2);
                wireframeDrawOrder.put(i);
            }
            return new Object3DData(objData.getVertexArrayBuffer()).setVertexBuffer(objData.getVertexBuffer()).setDrawOrder(wireframeDrawOrder).setVertexNormalsArrayBuffer(objData.getVertexNormalsArrayBuffer()).setColor(objData.getColor()).setVertexColorsArrayBuffer(objData.getVertexColorsArrayBuffer()).setTextureCoordsArrayBuffer(objData.getTextureCoordsArrayBuffer()).setPosition(objData.getPosition()).setRotation(objData.getRotation()).setScale(objData.getScale()).setDrawMode(1).setDrawUsingArrays(false);
        }
        return objData;
    }

    public static Object3DData buildWireframe_from_original(Object3DData objData) {
        try {
            IntBuffer drawOrder = Object3DBuilder.createNativeByteBuffer(objData.getFaces().getIndexBuffer().capacity() * 2 * 4).asIntBuffer();
            for (int i = 0; i < objData.getFaces().getIndexBuffer().capacity(); i += 3) {
                drawOrder.put(objData.getFaces().getIndexBuffer().get(i));
                drawOrder.put(objData.getFaces().getIndexBuffer().get(i + 1));
                drawOrder.put(objData.getFaces().getIndexBuffer().get(i + 1));
                drawOrder.put(objData.getFaces().getIndexBuffer().get(i + 2));
                drawOrder.put(objData.getFaces().getIndexBuffer().get(i + 2));
                drawOrder.put(objData.getFaces().getIndexBuffer().get(i));
            }
            return new Object3DData(objData.getVertexBuffer()).setDrawOrder(drawOrder).setVertexNormalsArrayBuffer(objData.getVertexNormalsBuffer()).setColor(objData.getColor()).setDrawMode(1);
        }
        catch (Exception ex) {
            Log.e((String)"Object3DBuilder", (String)ex.getMessage(), (Throwable)ex);
            return objData;
        }
    }

    public static Object3DData buildFaceNormals(Object3DData obj) {
        FloatBuffer normalsLines;
        FloatBuffer vertexBuffer;
        if (obj.getDrawMode() != 4) {
            return null;
        }
        FloatBuffer floatBuffer = vertexBuffer = obj.getVertexArrayBuffer() != null ? obj.getVertexArrayBuffer() : obj.getVertexBuffer();
        if (vertexBuffer == null) {
            Log.v((String)"Builder", (String)("Generating face normals for '" + obj.getId() + "' I found that there is no vertex data"));
            return null;
        }
        IntBuffer drawBuffer = obj.getDrawOrder();
        if (drawBuffer != null) {
            Log.v((String)"Builder", (String)("Generating face normals for '" + obj.getId() + "' using indices..."));
            int size = 6 * (drawBuffer.capacity() / 3) * 4;
            normalsLines = Object3DBuilder.createNativeByteBuffer(size).asFloatBuffer();
            drawBuffer.position(0);
            for (int i = 0; i < drawBuffer.capacity(); i += 3) {
                int v1 = drawBuffer.get() * 3;
                int v2 = drawBuffer.get() * 3;
                int v3 = drawBuffer.get() * 3;
                float[][] normalLine = Math3DUtils.calculateFaceNormal(new float[]{vertexBuffer.get(v1), vertexBuffer.get(v1 + 1), vertexBuffer.get(v1 + 2)}, new float[]{vertexBuffer.get(v2), vertexBuffer.get(v2 + 1), vertexBuffer.get(v2 + 2)}, new float[]{vertexBuffer.get(v3), vertexBuffer.get(v3 + 1), vertexBuffer.get(v3 + 2)});
                normalsLines.put(normalLine[0]).put(normalLine[1]);
            }
        } else {
            if (vertexBuffer.capacity() % 9 != 0) {
                Log.v((String)"Builder", (String)("Generating face normals for '" + obj.getId() + "' I found that vertices are not multiple of 9 (3*3): " + vertexBuffer.capacity()));
                return null;
            }
            Log.v((String)"Builder", (String)("Generating face normals for '" + obj.getId() + "'..."));
            normalsLines = Object3DBuilder.createNativeByteBuffer(6 * vertexBuffer.capacity() / 9 * 4).asFloatBuffer();
            vertexBuffer.position(0);
            for (int i = 0; i < vertexBuffer.capacity() / 3 / 3; ++i) {
                float[][] normalLine = Math3DUtils.calculateFaceNormal(new float[]{vertexBuffer.get(), vertexBuffer.get(), vertexBuffer.get()}, new float[]{vertexBuffer.get(), vertexBuffer.get(), vertexBuffer.get()}, new float[]{vertexBuffer.get(), vertexBuffer.get(), vertexBuffer.get()});
                normalsLines.put(normalLine[0]).put(normalLine[1]);
                String string = normalLine[0][0] + "," + normalLine[0][1] + "," + normalLine[0][2] + "-" + normalLine[1][0] + "," + normalLine[1][1] + "," + normalLine[1][2];
            }
        }
        return new Object3DData(normalsLines).setDrawMode(1).setColor(obj.getColor()).setPosition(obj.getPosition()).setVersion(1);
    }

    private static ByteBuffer createNativeByteBuffer(int length) {
        ByteBuffer bb = ByteBuffer.allocateDirect(length);
        bb.order(ByteOrder.nativeOrder());
        return bb;
    }

    public static void loadV6AsyncParallel(Context context, URL url, Callback callback) {
        String modelId = url.toString().toLowerCase();
        String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)modelId);
        if (fileExtension.equals("obj")) {
            WavefrontLoader2.loadAsync(context, url, callback);
        } else if (fileExtension.equals("dae")) {
            ColladaLoader.loadAsync(url, callback);
        }
    }

    static {
        System.setProperty("java.protocol.handler.pkgs", "org.andresoviedo.app.util.url|" + System.getProperty("java.protocol.handler.pkgs"));
        Log.i((String)"Object3DBuilder", (String)("java.protocol.handler.pkgs=" + System.getProperty("java.protocol.handler.pkgs")));
    }

    public static interface Callback {
        public void onLoadError(Exception var1);

        public void onLoadComplete(List<Object3DData> var1);

        public void onBuildComplete(List<Object3DData> var1);
    }
}

