/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.model;

import android.opengl.Matrix;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.andresoviedo.app.model3D.entities.BoundingBox;
import org.andresoviedo.app.model3D.services.WavefrontLoader;
import org.andresoviedo.app.util.math.Math3DUtils;

public class Object3DData {
    private int version = 5;
    private File currentDir;
    private String assetsDir;
    private String id;
    private boolean drawUsingArrays = false;
    private boolean flipTextCoords = true;
    private boolean isVisible = true;
    private float[] color;
    private int drawMode = 0;
    private int drawSize;
    private FloatBuffer vertexBuffer = null;
    private FloatBuffer vertexNormalsBuffer = null;
    private IntBuffer drawOrderBuffer = null;
    private ArrayList<WavefrontLoader.Tuple3> texCoords;
    private WavefrontLoader.Faces faces;
    private WavefrontLoader.FaceMaterials faceMats;
    private WavefrontLoader.Materials materials;
    private String textureFile;
    private FloatBuffer vertexArrayBuffer = null;
    private FloatBuffer vertexColorsArrayBuffer = null;
    private FloatBuffer vertexNormalsArrayBuffer = null;
    private FloatBuffer textureCoordsArrayBuffer = null;
    private List<int[]> drawModeList = null;
    private byte[] textureData = null;
    private List<InputStream> textureStreams = null;
    private BoundingBox boundingBox;
    protected float[] position = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] rotation = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    protected float[] modelMatrix = new float[16];
    private boolean changed;
    private WavefrontLoader.ModelDimensions modelDimensions;
    private WavefrontLoader loader;

    public Object3DData(FloatBuffer vertexArrayBuffer) {
        Matrix.setIdentityM((float[])this.modelMatrix, (int)0);
        this.vertexArrayBuffer = vertexArrayBuffer;
        this.version = 1;
    }

    public Object3DData(FloatBuffer vertexBuffer, IntBuffer drawOrder) {
        Matrix.setIdentityM((float[])this.modelMatrix, (int)0);
        this.vertexBuffer = vertexBuffer;
        this.drawOrderBuffer = drawOrder;
        this.version = 2;
    }

    public Object3DData(FloatBuffer vertexArrayBuffer, FloatBuffer textureCoordsArrayBuffer, byte[] texData) {
        Matrix.setIdentityM((float[])this.modelMatrix, (int)0);
        this.vertexArrayBuffer = vertexArrayBuffer;
        this.textureCoordsArrayBuffer = textureCoordsArrayBuffer;
        this.textureData = texData;
        this.version = 3;
    }

    public Object3DData(FloatBuffer vertexArrayBuffer, FloatBuffer vertexColorsArrayBuffer, FloatBuffer textureCoordsArrayBuffer, byte[] texData) {
        Matrix.setIdentityM((float[])this.modelMatrix, (int)0);
        this.vertexArrayBuffer = vertexArrayBuffer;
        this.vertexColorsArrayBuffer = vertexColorsArrayBuffer;
        this.textureCoordsArrayBuffer = textureCoordsArrayBuffer;
        this.textureData = texData;
        this.version = 4;
    }

    public Object3DData(FloatBuffer verts, FloatBuffer normals, ArrayList<WavefrontLoader.Tuple3> texCoords, WavefrontLoader.Faces faces, WavefrontLoader.FaceMaterials faceMats, WavefrontLoader.Materials materials) {
        Matrix.setIdentityM((float[])this.modelMatrix, (int)0);
        this.vertexBuffer = verts;
        this.vertexNormalsBuffer = normals;
        this.texCoords = texCoords;
        this.faces = faces;
        this.faceMats = faceMats;
        this.materials = materials;
    }

    public void setLoader(WavefrontLoader loader) {
        this.loader = loader;
    }

    public WavefrontLoader getLoader() {
        return this.loader;
    }

    public void setDimensions(WavefrontLoader.ModelDimensions modelDimensions) {
        this.modelDimensions = modelDimensions;
    }

    public WavefrontLoader.ModelDimensions getDimensions() {
        return this.modelDimensions;
    }

    public Object3DData setFaces(WavefrontLoader.Faces faces) {
        this.faces = faces;
        this.drawOrderBuffer = faces.getIndexBuffer();
        return this;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public int getVersion() {
        return this.version;
    }

    public Object3DData setVersion(int version) {
        this.version = version;
        return this;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public Object3DData setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public float[] getColor() {
        return this.color;
    }

    public float[] getColorInverted() {
        if (this.getColor() == null || this.getColor().length != 4) {
            return null;
        }
        return new float[]{1.0f - this.getColor()[0], 1.0f - this.getColor()[1], 1.0f - this.getColor()[2], 1.0f};
    }

    public Object3DData setColor(float[] color) {
        this.color = color;
        return this;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public Object3DData setDrawMode(int drawMode) {
        this.drawMode = drawMode;
        return this;
    }

    public int getDrawSize() {
        return this.drawSize;
    }

    public byte[] getTextureData() {
        return this.textureData;
    }

    public void setTextureData(byte[] textureData) {
        this.textureData = textureData;
    }

    public Object3DData setPosition(float[] position) {
        this.position = position;
        this.updateModelMatrix();
        return this;
    }

    public float[] getPosition() {
        return this.position;
    }

    public float getPositionX() {
        return this.position != null ? this.position[0] : 0.0f;
    }

    public float getPositionY() {
        return this.position != null ? this.position[1] : 0.0f;
    }

    public float getPositionZ() {
        return this.position != null ? this.position[2] : 0.0f;
    }

    public float[] getRotation() {
        return this.rotation;
    }

    public float getRotationX() {
        return this.rotation[0];
    }

    public float getRotationY() {
        return this.rotation[1];
    }

    public float getRotationZ() {
        return this.rotation[2];
    }

    public Object3DData setScale(float[] scale) {
        this.scale = scale;
        this.updateModelMatrix();
        return this;
    }

    public float[] getScale() {
        return this.scale;
    }

    public float getScaleX() {
        return this.getScale()[0];
    }

    public float getScaleY() {
        return this.getScale()[1];
    }

    public float getScaleZ() {
        return this.getScale()[2];
    }

    public Object3DData setRotation(float[] rotation) {
        this.rotation = rotation;
        this.updateModelMatrix();
        return this;
    }

    public Object3DData setRotationY(float rotY) {
        this.rotation[1] = rotY;
        this.updateModelMatrix();
        return this;
    }

    private void updateModelMatrix() {
        Matrix.setIdentityM((float[])this.modelMatrix, (int)0);
        Matrix.setRotateM((float[])this.modelMatrix, (int)0, (float)this.getRotationX(), (float)1.0f, (float)0.0f, (float)0.0f);
        Matrix.setRotateM((float[])this.modelMatrix, (int)0, (float)this.getRotationY(), (float)0.0f, (float)1.0f, (float)0.0f);
        Matrix.setRotateM((float[])this.modelMatrix, (int)0, (float)this.getRotationY(), (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])this.modelMatrix, (int)0, (float)this.getScaleX(), (float)this.getScaleY(), (float)this.getScaleZ());
        Matrix.translateM((float[])this.modelMatrix, (int)0, (float)this.getPositionX(), (float)this.getPositionY(), (float)this.getPositionZ());
    }

    public float[] getModelMatrix() {
        return this.modelMatrix;
    }

    public IntBuffer getDrawOrder() {
        return this.drawOrderBuffer;
    }

    public Object3DData setDrawOrder(IntBuffer drawBuffer) {
        this.drawOrderBuffer = drawBuffer;
        return this;
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(File currentDir) {
        this.currentDir = currentDir;
    }

    public void setAssetsDir(String assetsDir) {
        this.assetsDir = assetsDir;
    }

    public String getAssetsDir() {
        return this.assetsDir;
    }

    public boolean isDrawUsingArrays() {
        return this.drawUsingArrays;
    }

    public boolean isFlipTextCoords() {
        return this.flipTextCoords;
    }

    public void setFlipTextCoords(boolean flipTextCoords) {
        this.flipTextCoords = flipTextCoords;
    }

    public Object3DData setDrawUsingArrays(boolean drawUsingArrays) {
        this.drawUsingArrays = drawUsingArrays;
        return this;
    }

    public FloatBuffer getVerts() {
        return this.vertexBuffer;
    }

    public FloatBuffer getNormals() {
        return this.vertexNormalsBuffer;
    }

    public ArrayList<WavefrontLoader.Tuple3> getTexCoords() {
        return this.texCoords;
    }

    public WavefrontLoader.Faces getFaces() {
        return this.faces;
    }

    public WavefrontLoader.FaceMaterials getFaceMats() {
        return this.faceMats;
    }

    public WavefrontLoader.Materials getMaterials() {
        return this.materials;
    }

    public FloatBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public Object3DData setVertexBuffer(FloatBuffer vertexBuffer) {
        this.vertexBuffer = vertexBuffer;
        return this;
    }

    public FloatBuffer getVertexNormalsBuffer() {
        return this.vertexNormalsBuffer;
    }

    public Object3DData setVertexNormalsBuffer(FloatBuffer vertexNormalsBuffer) {
        this.vertexNormalsBuffer = vertexNormalsBuffer;
        return this;
    }

    public FloatBuffer getVertexArrayBuffer() {
        return this.vertexArrayBuffer;
    }

    public Object3DData setVertexArrayBuffer(FloatBuffer vertexArrayBuffer) {
        this.vertexArrayBuffer = vertexArrayBuffer;
        return this;
    }

    public FloatBuffer getVertexNormalsArrayBuffer() {
        return this.vertexNormalsArrayBuffer;
    }

    public Object3DData setVertexNormalsArrayBuffer(FloatBuffer vertexNormalsArrayBuffer) {
        this.vertexNormalsArrayBuffer = vertexNormalsArrayBuffer;
        return this;
    }

    public FloatBuffer getTextureCoordsArrayBuffer() {
        return this.textureCoordsArrayBuffer;
    }

    public Object3DData setTextureCoordsArrayBuffer(FloatBuffer textureCoordsArrayBuffer) {
        this.textureCoordsArrayBuffer = textureCoordsArrayBuffer;
        return this;
    }

    public List<int[]> getDrawModeList() {
        return this.drawModeList;
    }

    public Object3DData setDrawModeList(List<int[]> drawModeList) {
        this.drawModeList = drawModeList;
        return this;
    }

    public FloatBuffer getVertexColorsArrayBuffer() {
        return this.vertexColorsArrayBuffer;
    }

    public Object3DData setVertexColorsArrayBuffer(FloatBuffer vertexColorsArrayBuffer) {
        this.vertexColorsArrayBuffer = vertexColorsArrayBuffer;
        return this;
    }

    public void setTextureFile(String textureFile) {
        this.textureFile = textureFile;
    }

    public String getTextureFile() {
        return this.textureFile;
    }

    public InputStream getTextureStream0() {
        if (this.textureData != null) {
            return new ByteArrayInputStream(this.textureData);
        }
        if (this.textureStreams == null) {
            return null;
        }
        return this.textureStreams.get(0);
    }

    public List<InputStream> getTextureStreams() {
        return this.textureStreams;
    }

    public void setTextureStreams(List<InputStream> textureStreams) {
        this.textureStreams = textureStreams;
    }

    public Object3DData centerAndScale(float maxSize) {
        FloatBuffer vertexBuffer;
        float leftPt = Float.MAX_VALUE;
        float rightPt = Float.MIN_VALUE;
        float topPt = Float.MIN_VALUE;
        float bottomPt = Float.MAX_VALUE;
        float farPt = Float.MAX_VALUE;
        float nearPt = Float.MIN_VALUE;
        FloatBuffer floatBuffer = vertexBuffer = this.getVertexArrayBuffer() != null ? this.getVertexArrayBuffer() : this.getVertexBuffer();
        if (vertexBuffer == null) {
            Log.v((String)"Object3DData", (String)("Scaling for '" + this.getId() + "' I found that there is no vertex data"));
            return this;
        }
        Log.i((String)"Object3DData", (String)("Calculating dimensions for '" + this.getId() + "..."));
        for (int i = 0; i < vertexBuffer.capacity(); i += 3) {
            if (vertexBuffer.get(i) > rightPt) {
                rightPt = vertexBuffer.get(i);
            } else if (vertexBuffer.get(i) < leftPt) {
                leftPt = vertexBuffer.get(i);
            }
            if (vertexBuffer.get(i + 1) > topPt) {
                topPt = vertexBuffer.get(i + 1);
            } else if (vertexBuffer.get(i + 1) < bottomPt) {
                bottomPt = vertexBuffer.get(i + 1);
            }
            if (vertexBuffer.get(i + 2) > nearPt) {
                nearPt = vertexBuffer.get(i + 2);
                continue;
            }
            if (!(vertexBuffer.get(i + 2) < farPt)) continue;
            farPt = vertexBuffer.get(i + 2);
        }
        Log.i((String)"Object3DData", (String)("Dimensions for '" + this.getId() + " (X left, X right): (" + leftPt + "," + rightPt + ")"));
        Log.i((String)"Object3DData", (String)("Dimensions for '" + this.getId() + " (Y top, Y bottom): (" + topPt + "," + bottomPt + ")"));
        Log.i((String)"Object3DData", (String)("Dimensions for '" + this.getId() + " (Z near, Z far): (" + nearPt + "," + farPt + ")"));
        float xc = (rightPt + leftPt) / 2.0f;
        float yc = (topPt + bottomPt) / 2.0f;
        float zc = (nearPt + farPt) / 2.0f;
        float height = topPt - bottomPt;
        float depth = nearPt - farPt;
        float largest = rightPt - leftPt;
        if (height > largest) {
            largest = height;
        }
        if (depth > largest) {
            largest = depth;
        }
        Log.i((String)"Object3DData", (String)("Largest dimension [" + largest + "]"));
        float scaleFactor = 1.0f;
        if (largest != 0.0f) {
            scaleFactor = maxSize / largest;
        }
        Log.i((String)"Object3DData", (String)("Centering & scaling '" + this.getId() + "' to (" + xc + "," + yc + "," + zc + ") scale: '" + scaleFactor + "'"));
        for (int i = 0; i < vertexBuffer.capacity(); i += 3) {
            float x = vertexBuffer.get(i);
            float y = vertexBuffer.get(i + 1);
            float z = vertexBuffer.get(i + 2);
            x = (x - xc) * scaleFactor;
            y = (y - yc) * scaleFactor;
            z = (z - zc) * scaleFactor;
            vertexBuffer.put(i, x);
            vertexBuffer.put(i + 1, y);
            vertexBuffer.put(i + 2, z);
        }
        return this;
    }

    public Object3DData centerAndScaleAndExplode(float maxSize, float explodeFactor) {
        int i;
        FloatBuffer vertexBuffer;
        if (this.drawMode != 4) {
            Log.i((String)"Object3DData", (String)("Cant explode '" + this.getId() + " because its not made of triangles..."));
            return this;
        }
        float leftPt = Float.MAX_VALUE;
        float rightPt = Float.MIN_VALUE;
        float topPt = Float.MIN_VALUE;
        float bottomPt = Float.MAX_VALUE;
        float farPt = Float.MAX_VALUE;
        float nearPt = Float.MIN_VALUE;
        FloatBuffer floatBuffer = vertexBuffer = this.getVertexArrayBuffer() != null ? this.getVertexArrayBuffer() : this.getVertexBuffer();
        if (vertexBuffer == null) {
            Log.v((String)"Object3DData", (String)("Scaling for '" + this.getId() + "' I found that there is no vertex data"));
            return this;
        }
        Log.i((String)"Object3DData", (String)("Calculating dimensions for '" + this.getId() + "..."));
        for (int i2 = 0; i2 < vertexBuffer.capacity(); i2 += 3) {
            if (vertexBuffer.get(i2) > rightPt) {
                rightPt = vertexBuffer.get(i2);
            } else if (vertexBuffer.get(i2) < leftPt) {
                leftPt = vertexBuffer.get(i2);
            }
            if (vertexBuffer.get(i2 + 1) > topPt) {
                topPt = vertexBuffer.get(i2 + 1);
            } else if (vertexBuffer.get(i2 + 1) < bottomPt) {
                bottomPt = vertexBuffer.get(i2 + 1);
            }
            if (vertexBuffer.get(i2 + 2) > nearPt) {
                nearPt = vertexBuffer.get(i2 + 2);
                continue;
            }
            if (!(vertexBuffer.get(i2 + 2) < farPt)) continue;
            farPt = vertexBuffer.get(i2 + 2);
        }
        float xc = (rightPt + leftPt) / 2.0f;
        float yc = (topPt + bottomPt) / 2.0f;
        float zc = (nearPt + farPt) / 2.0f;
        float height = topPt - bottomPt;
        float depth = nearPt - farPt;
        float largest = rightPt - leftPt;
        if (height > largest) {
            largest = height;
        }
        if (depth > largest) {
            largest = depth;
        }
        float scaleFactor = 1.0f;
        if (largest != 0.0f) {
            scaleFactor = maxSize / largest;
        }
        Log.i((String)"Object3DData", (String)("Exploding '" + this.getId() + "' to '" + xc + "," + yc + "," + zc + "' '" + scaleFactor + "'"));
        FloatBuffer vertexBufferNew = Object3DData.createNativeByteBuffer(vertexBuffer.capacity() * 4).asFloatBuffer();
        for (i = 0; i < vertexBuffer.capacity(); i += 3) {
            float x = vertexBuffer.get(i);
            float y = vertexBuffer.get(i + 1);
            float z = vertexBuffer.get(i + 2);
            x = (x - xc) * scaleFactor;
            y = (y - yc) * scaleFactor;
            z = (z - zc) * scaleFactor;
            vertexBuffer.put(i, x);
            vertexBuffer.put(i + 1, y);
            vertexBuffer.put(i + 2, z);
            vertexBufferNew.put(i, x * explodeFactor);
            vertexBufferNew.put(i + 1, y * explodeFactor);
            vertexBufferNew.put(i + 2, z * explodeFactor);
        }
        if (this.drawOrderBuffer != null) {
            Log.e((String)"Object3DData", (String)("Cant explode object composed of indexes '" + this.getId() + "'"));
            return this;
        }
        for (i = 0; i < vertexBuffer.capacity(); i += 9) {
            float x1 = vertexBuffer.get(i);
            float y1 = vertexBuffer.get(i + 1);
            float z1 = vertexBuffer.get(i + 2);
            float x2 = vertexBuffer.get(i + 3);
            float y2 = vertexBuffer.get(i + 4);
            float z2 = vertexBuffer.get(i + 5);
            float x3 = vertexBuffer.get(i + 6);
            float y3 = vertexBuffer.get(i + 7);
            float z3 = vertexBuffer.get(i + 8);
            float[] center1 = Math3DUtils.calculateFaceCenter(new float[]{x1, y1, z1}, new float[]{x2, y2, z2}, new float[]{x3, y3, z3});
            float xe1 = vertexBufferNew.get(i);
            float ye1 = vertexBufferNew.get(i + 1);
            float ze1 = vertexBufferNew.get(i + 2);
            float xe2 = vertexBufferNew.get(i + 3);
            float ye2 = vertexBufferNew.get(i + 4);
            float ze2 = vertexBufferNew.get(i + 5);
            float xe3 = vertexBufferNew.get(i + 6);
            float ye3 = vertexBufferNew.get(i + 7);
            float ze3 = vertexBufferNew.get(i + 8);
            float[] center2 = Math3DUtils.calculateFaceCenter(new float[]{xe1, ye1, ze1}, new float[]{xe2, ye2, ze2}, new float[]{xe3, ye3, ze3});
            vertexBuffer.put(i + 0, x1 + (center2[0] - center1[0]));
            vertexBuffer.put(i + 1, y1 + (center2[1] - center1[1]));
            vertexBuffer.put(i + 2, z1 + (center2[2] - center1[2]));
            vertexBuffer.put(i + 3, x2 + (center2[0] - center1[0]));
            vertexBuffer.put(i + 4, y2 + (center2[1] - center1[1]));
            vertexBuffer.put(i + 5, z2 + (center2[2] - center1[2]));
            vertexBuffer.put(i + 6, x3 + (center2[0] - center1[0]));
            vertexBuffer.put(i + 7, y3 + (center2[1] - center1[1]));
            vertexBuffer.put(i + 8, z3 + (center2[2] - center1[2]));
        }
        return this;
    }

    private static ByteBuffer createNativeByteBuffer(int length) {
        ByteBuffer bb = ByteBuffer.allocateDirect(length);
        bb.order(ByteOrder.nativeOrder());
        return bb;
    }

    public BoundingBox getBoundingBox() {
        FloatBuffer vertexBuffer = this.getVertexBuffer();
        if (vertexBuffer == null) {
            vertexBuffer = this.getVertexArrayBuffer();
        }
        if (this.boundingBox == null) {
            this.boundingBox = BoundingBox.create(this.getId() + "_BoundingBox", vertexBuffer, this.getModelMatrix());
        }
        return this.boundingBox;
    }

    public void centerAndScale(float newScale, float[] newPosition) {
        WavefrontLoader.Tuple3 center = this.modelDimensions.getCenter();
        this.setPosition(new float[]{-center.getX() + newPosition[0], -center.getY() + newPosition[1], -center.getZ() + newPosition[2]});
    }

    public static void centerAndScale(List<Object3DData> datas, float newScale, float[] newPosition) {
        float maxRight = datas.get((int)0).getDimensions().rightPt;
        float maxLeft = datas.get((int)0).getDimensions().leftPt;
        float maxTop = datas.get((int)0).getDimensions().topPt;
        float maxBottom = datas.get((int)0).getDimensions().bottomPt;
        float maxNear = datas.get((int)0).getDimensions().nearPt;
        float maxFar = datas.get((int)0).getDimensions().farPt;
        for (int i = 1; i < datas.size(); ++i) {
            float maxRight2 = datas.get((int)i).getDimensions().rightPt;
            float maxLeft2 = datas.get((int)i).getDimensions().leftPt;
            float maxTop2 = datas.get((int)i).getDimensions().topPt;
            float maxBottom2 = datas.get((int)i).getDimensions().bottomPt;
            float maxNear2 = datas.get((int)i).getDimensions().nearPt;
            float maxFar2 = datas.get((int)i).getDimensions().farPt;
            if (maxRight2 > maxRight) {
                maxRight = maxRight2;
            }
            if (maxLeft2 < maxLeft) {
                maxLeft = maxLeft2;
            }
            if (maxTop2 > maxTop) {
                maxTop = maxTop2;
            }
            if (maxBottom2 < maxBottom) {
                maxBottom = maxBottom2;
            }
            if (maxNear2 > maxNear) {
                maxNear = maxNear2;
            }
            if (!(maxFar2 < maxFar)) continue;
            maxFar = maxFar2;
        }
        float lengthX = maxRight - maxLeft;
        float lengthY = maxTop - maxBottom;
        float lengthZ = maxNear - maxFar;
        float maxLength = lengthX;
        if (lengthY > maxLength) {
            maxLength = lengthY;
        }
        if (lengthZ > maxLength) {
            maxLength = lengthZ;
        }
        float centerX = (maxRight + maxLeft) / 2.0f;
        float centerY = (maxTop + maxBottom) / 2.0f;
        float centerZ = (maxNear + maxFar) / 2.0f;
        float translationX = -centerX + newPosition[0];
        float translationY = -centerY + newPosition[1];
        float translationZ = -centerZ + newPosition[2];
        for (Object3DData data : datas) {
            data.setPosition(new float[]{translationX, translationY, translationZ});
        }
    }

    @Deprecated
    public void centerScale() {
        float scaleFactor = 1.0f;
        float largest = this.modelDimensions.getLargest();
        if (largest != 0.0f) {
            scaleFactor = 1.0f / largest;
        }
        Log.i((String)"Object3DData", (String)("Scaling model with factor: " + scaleFactor + ". Largest: " + largest));
        WavefrontLoader.Tuple3 center = this.modelDimensions.getCenter();
        Log.i((String)"Object3DData", (String)("Objects actual position: " + center.toString()));
        FloatBuffer vertexBuffer = this.getVertexBuffer() != null ? this.getVertexBuffer() : this.getVertexArrayBuffer();
        for (int i = 0; i < vertexBuffer.capacity() / 3; ++i) {
            float x0 = vertexBuffer.get(i * 3);
            float y0 = vertexBuffer.get(i * 3 + 1);
            float z0 = vertexBuffer.get(i * 3 + 2);
            float x = (x0 - center.getX()) * scaleFactor;
            vertexBuffer.put(i * 3, x);
            float y = (y0 - center.getY()) * scaleFactor;
            vertexBuffer.put(i * 3 + 1, y);
            float z = (z0 - center.getZ()) * scaleFactor;
            vertexBuffer.put(i * 3 + 2, z);
        }
    }
}

