/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.model;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.SystemClock;
import android.util.Log;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.andresoviedo.app.model3D.model.Object3D;
import org.andresoviedo.app.model3D.model.Object3DData;
import org.andresoviedo.app.model3D.util.GLUtil;

public abstract class Object3DImpl
implements Object3D {
    private final String id;
    private final float[] mMatrix = new float[16];
    private final float[] mvMatrix = new float[16];
    private final float[] mvpMatrix = new float[16];
    protected final int mProgram;
    private long counter = -1L;
    private double shift = -1.0;

    public Object3DImpl(String id, String vertexShaderCode, String fragmentShaderCode, String ... variables) {
        this.id = id;
        int vertexShader = GLUtil.loadShader(35633, vertexShaderCode);
        int fragmentShader = GLUtil.loadShader(35632, fragmentShaderCode);
        this.mProgram = GLUtil.createAndLinkProgram(vertexShader, fragmentShader, variables);
    }

    @Override
    public void draw(Object3DData obj, float[] pMatrix, float[] vMatrix, int textureId, float[] lightPos) {
        this.draw(obj, pMatrix, vMatrix, obj.getDrawMode(), obj.getDrawSize(), textureId, lightPos);
    }

    @Override
    public void draw(Object3DData obj, float[] pMatrix, float[] vMatrix, int drawMode, int drawSize, int textureId, float[] lightPos) {
        GLES20.glUseProgram((int)this.mProgram);
        float[] mMatrix = this.getMMatrix(obj);
        float[] mvMatrix = this.getMvMatrix(mMatrix, vMatrix);
        float[] mvpMatrix = this.getMvpMatrix(mvMatrix, pMatrix);
        this.setMvpMatrix(mvpMatrix);
        int mPositionHandle = this.setPosition(obj);
        int mColorHandle = -1;
        if (this.supportsColors()) {
            mColorHandle = this.setColors(obj);
        } else {
            this.setColor(obj);
        }
        int mTextureHandle = -1;
        if (textureId != -1 && this.supportsTextures()) {
            this.setTexture(obj, textureId);
        }
        int mNormalHandle = -1;
        if (this.supportsNormals()) {
            mNormalHandle = this.setNormals(obj);
        }
        if (this.supportsMvMatrix()) {
            this.setMvMatrix(mvMatrix);
        }
        if (lightPos != null && this.supportsLighting()) {
            this.setLightPos(lightPos);
        }
        this.drawShape(obj, drawMode, drawSize);
        GLES20.glDisableVertexAttribArray((int)mPositionHandle);
        if (mColorHandle != -1) {
            GLES20.glDisableVertexAttribArray((int)mColorHandle);
        }
        if (mTextureHandle != -1) {
            GLES20.glDisableVertexAttribArray((int)mTextureHandle);
        }
        if (mNormalHandle != -1) {
            GLES20.glDisableVertexAttribArray((int)mNormalHandle);
        }
    }

    public float[] getMMatrix(Object3DData obj) {
        Matrix.setIdentityM((float[])this.mMatrix, (int)0);
        if (obj.getRotation() != null) {
            Matrix.rotateM((float[])this.mMatrix, (int)0, (float)obj.getRotation()[0], (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mMatrix, (int)0, (float)obj.getRotation()[1], (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mMatrix, (int)0, (float)obj.getRotationZ(), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (obj.getScale() != null) {
            Matrix.scaleM((float[])this.mMatrix, (int)0, (float)obj.getScaleX(), (float)obj.getScaleY(), (float)obj.getScaleZ());
        }
        if (obj.getPosition() != null) {
            Matrix.translateM((float[])this.mMatrix, (int)0, (float)obj.getPositionX(), (float)obj.getPositionY(), (float)obj.getPositionZ());
        }
        return this.mMatrix;
    }

    public float[] getMvMatrix(float[] mMatrix, float[] vMatrix) {
        Matrix.multiplyMM((float[])this.mvMatrix, (int)0, (float[])vMatrix, (int)0, (float[])mMatrix, (int)0);
        return this.mvMatrix;
    }

    protected float[] getMvpMatrix(float[] mvMatrix, float[] pMatrix) {
        Matrix.multiplyMM((float[])this.mvpMatrix, (int)0, (float[])pMatrix, (int)0, (float[])mvMatrix, (int)0);
        return this.mvpMatrix;
    }

    protected void setMvpMatrix(float[] mvpMatrix) {
        int mMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"u_MVPMatrix");
        GLUtil.checkGlError("glGetUniformLocation");
        GLES20.glUniformMatrix4fv((int)mMVPMatrixHandle, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        GLUtil.checkGlError("glUniformMatrix4fv");
    }

    protected boolean supportsColors() {
        return false;
    }

    protected void setColor(Object3DData obj) {
        int mColorHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"vColor");
        GLUtil.checkGlError("glGetUniformLocation");
        float[] color = obj.getColor() != null ? obj.getColor() : DEFAULT_COLOR;
        GLES20.glUniform4fv((int)mColorHandle, (int)1, (float[])color, (int)0);
        GLUtil.checkGlError("glUniform4fv");
    }

    protected int setColors(Object3DData obj) {
        int mColorHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"a_Color");
        GLUtil.checkGlError("glGetAttribLocation");
        GLES20.glEnableVertexAttribArray((int)mColorHandle);
        GLUtil.checkGlError("glEnableVertexAttribArray");
        obj.getVertexColorsArrayBuffer().position(0);
        GLES20.glVertexAttribPointer((int)mColorHandle, (int)4, (int)5126, (boolean)false, (int)0, (Buffer)obj.getVertexColorsArrayBuffer());
        GLUtil.checkGlError("glVertexAttribPointer");
        return mColorHandle;
    }

    protected int setPosition(Object3DData obj) {
        int mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"a_Position");
        GLUtil.checkGlError("glGetAttribLocation");
        GLES20.glEnableVertexAttribArray((int)mPositionHandle);
        GLUtil.checkGlError("glEnableVertexAttribArray");
        FloatBuffer vertexBuffer = obj.getVertexArrayBuffer() != null ? obj.getVertexArrayBuffer() : obj.getVertexBuffer();
        vertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)mPositionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)vertexBuffer);
        GLUtil.checkGlError("glVertexAttribPointer");
        return mPositionHandle;
    }

    protected boolean supportsNormals() {
        return false;
    }

    protected int setNormals(Object3DData obj) {
        int mNormalHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"a_Normal");
        GLUtil.checkGlError("glGetAttribLocation");
        GLES20.glEnableVertexAttribArray((int)mNormalHandle);
        GLUtil.checkGlError("glEnableVertexAttribArray");
        FloatBuffer buffer = obj.getVertexNormalsArrayBuffer() != null ? obj.getVertexNormalsArrayBuffer() : obj.getNormals();
        buffer.position(0);
        GLES20.glVertexAttribPointer((int)mNormalHandle, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)buffer);
        return mNormalHandle;
    }

    protected boolean supportsLighting() {
        return false;
    }

    protected void setLightPos(float[] lightPosInEyeSpace) {
        int mLightPosHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"u_LightPos");
        GLES20.glUniform3f((int)mLightPosHandle, (float)lightPosInEyeSpace[0], (float)lightPosInEyeSpace[1], (float)lightPosInEyeSpace[2]);
    }

    protected boolean supportsMvMatrix() {
        return false;
    }

    protected void setMvMatrix(float[] mvMatrix) {
        int mMVMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"u_MVMatrix");
        GLUtil.checkGlError("glGetUniformLocation");
        GLES20.glUniformMatrix4fv((int)mMVMatrixHandle, (int)1, (boolean)false, (float[])mvMatrix, (int)0);
        GLUtil.checkGlError("glUniformMatrix4fv");
    }

    protected boolean supportsTextures() {
        return false;
    }

    protected int setTexture(Object3DData obj, int textureId) {
        int mTextureUniformHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"u_Texture");
        GLUtil.checkGlError("glGetUniformLocation");
        GLES20.glActiveTexture((int)33984);
        GLUtil.checkGlError("glActiveTexture");
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLUtil.checkGlError("glBindTexture");
        GLES20.glUniform1i((int)mTextureUniformHandle, (int)0);
        GLUtil.checkGlError("glUniform1i");
        int mTextureCoordinateHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"a_TexCoordinate");
        GLUtil.checkGlError("glGetAttribLocation");
        GLES20.glEnableVertexAttribArray((int)mTextureCoordinateHandle);
        GLUtil.checkGlError("glEnableVertexAttribArray");
        obj.getTextureCoordsArrayBuffer().position(0);
        GLES20.glVertexAttribPointer((int)mTextureCoordinateHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)obj.getTextureCoordsArrayBuffer());
        GLUtil.checkGlError("glVertexAttribPointer");
        return mTextureCoordinateHandle;
    }

    protected void drawShape(Object3DData obj, int drawMode, int drawSize) {
        FloatBuffer vertexBuffer = obj.getVertexArrayBuffer() != null ? obj.getVertexArrayBuffer() : obj.getVertexBuffer();
        vertexBuffer.position(0);
        List<int[]> drawModeList = obj.getDrawModeList();
        IntBuffer drawOrderBuffer = obj.getDrawOrder();
        if (obj.isDrawUsingArrays()) {
            drawOrderBuffer = null;
        }
        if (drawModeList != null) {
            if (drawOrderBuffer == null) {
                Log.d((String)obj.getId(), (String)"Drawing single polygons using arrays...");
                for (int j = 0; j < drawModeList.size(); ++j) {
                    int[] polygon = drawModeList.get(j);
                    int drawModePolygon = polygon[0];
                    int vertexPos = polygon[1];
                    int drawSizePolygon = polygon[2];
                    if (drawMode == 2 && polygon[2] > 3) {
                        for (int i = 0; i < polygon[2] - 2; ++i) {
                            GLES20.glDrawArrays((int)drawMode, (int)(polygon[1] + i), (int)3);
                        }
                        continue;
                    }
                    GLES20.glDrawArrays((int)drawMode, (int)polygon[1], (int)polygon[2]);
                }
            } else {
                for (int i = 0; i < drawModeList.size(); ++i) {
                    int[] drawPart = drawModeList.get(i);
                    int drawModePolygon = drawPart[0];
                    int vertexPos = drawPart[1];
                    int drawSizePolygon = drawPart[2];
                    drawOrderBuffer.position(vertexPos);
                    GLES20.glDrawElements((int)drawModePolygon, (int)drawSizePolygon, (int)5125, (Buffer)drawOrderBuffer);
                }
            }
        } else if (drawOrderBuffer != null) {
            if (drawSize <= 0) {
                drawOrderBuffer.position(0);
                GLES20.glDrawElements((int)drawMode, (int)drawOrderBuffer.capacity(), (int)5125, (Buffer)drawOrderBuffer);
            } else {
                for (int i = 0; i < drawOrderBuffer.capacity(); i += drawSize) {
                    drawOrderBuffer.position(i);
                    GLES20.glDrawElements((int)drawMode, (int)drawSize, (int)5125, (Buffer)drawOrderBuffer);
                }
            }
        } else if (drawSize <= 0) {
            int drawCount = vertexBuffer.capacity() / 3;
            if (this.shift >= 0.0) {
                double rotation = (double)((float)(SystemClock.uptimeMillis() % 10000L) / 10000.0f) * (Math.PI * 2);
                if (this.shift == 0.0) {
                    this.shift = rotation;
                }
                drawCount = (int)((Math.sin(rotation - this.shift + 4.71238898038469) + 1.0) / 2.0 * (double)drawCount);
            }
            GLES20.glDrawArrays((int)drawMode, (int)0, (int)drawCount);
        } else {
            for (int i = 0; i < vertexBuffer.capacity() / 3; i += drawSize) {
                GLES20.glDrawArrays((int)drawMode, (int)i, (int)drawSize);
            }
        }
    }
}

