/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.model;

import org.andresoviedo.app.model3D.model.Object3DImpl;

class Object3DV8
extends Object3DImpl {
    private static final String vertexShaderCode = "uniform mat4 u_MVPMatrix;\nattribute vec4 a_Position;\nuniform vec4 vColor;\nattribute vec2 a_TexCoordinate;varying vec2 v_TexCoordinate;uniform mat4 u_MVMatrix;\nuniform vec3 u_LightPos;\nattribute vec3 a_Normal;\nvarying vec4 v_Color;\nvoid main() {\n  v_TexCoordinate = a_TexCoordinate;   vec3 modelViewVertex = vec3(u_MVMatrix * a_Position);\n             vec3 lightVector = normalize(u_LightPos - modelViewVertex);\n       vec3 modelViewNormal = vec3(u_MVMatrix * vec4(a_Normal, 0.0));\n    float diffuse = max(dot(modelViewNormal, lightVector), 0.1);\n      float distance = length(u_LightPos - modelViewVertex);\n            diffuse = diffuse * (1.0 / (1.0 + (0.05 * distance * distance)));\n  diffuse = diffuse + 0.5;   v_Color = vColor * diffuse;\n   v_Color[3] = vColor[3];  gl_Position = u_MVPMatrix * a_Position;\n  gl_PointSize = 2.5;  \n}";
    private static final String fragmentShaderCode = "precision mediump float;\nvarying vec4 v_Color;\nuniform sampler2D u_Texture;varying vec2 v_TexCoordinate;void main() {\n  gl_FragColor = v_Color * texture2D(u_Texture, v_TexCoordinate);}";

    public Object3DV8() {
        super("V8", vertexShaderCode, fragmentShaderCode, "vColor", "a_Position", "a_TexCoordinate", "a_Normal");
    }

    @Override
    protected boolean supportsColors() {
        return false;
    }

    @Override
    protected boolean supportsTextures() {
        return true;
    }

    @Override
    protected boolean supportsNormals() {
        return true;
    }

    @Override
    protected boolean supportsLighting() {
        return true;
    }

    @Override
    protected boolean supportsMvMatrix() {
        return true;
    }
}

