/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.model;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.andresoviedo.app.model3D.model.AnimatedModel;
import org.andresoviedo.app.model3D.model.Object3DData;
import org.andresoviedo.app.model3D.model.Object3DImpl;
import org.andresoviedo.app.model3D.util.GLUtil;

class Object3DV9
extends Object3DImpl {
    private static final String vertexShaderCode = "const int MAX_JOINTS = 200;\nconst int MAX_WEIGHTS = 3;\nuniform mat4 u_MVPMatrix;      \nattribute vec4 a_Position;     \nattribute vec3 in_jointIndices;\nattribute vec3 in_weights;\nuniform mat4 jointTransforms[MAX_JOINTS];\nuniform mat4 u_MVMatrix;\nuniform vec3 u_LightPos;\nattribute vec3 a_Normal;\nuniform vec4 vColor;\nvarying vec4 v_Color;\nattribute vec2 a_TexCoordinate;varying vec2 v_TexCoordinate;void main()                    \n{                              \n  vec4 totalLocalPos = vec4(0.0);\n  vec4 totalNormal = vec4(0.0);\n    mat4 jointTransform = jointTransforms[int(in_jointIndices[0])];\n    vec4 posePosition = jointTransform * a_Position;\n    totalLocalPos += posePosition * in_weights[0];\n    jointTransform = jointTransforms[int(in_jointIndices[1])];\n    posePosition = jointTransform * a_Position;\n    totalLocalPos += posePosition * in_weights[1];\n    jointTransform = jointTransforms[int(in_jointIndices[2])];\n    posePosition = jointTransform * a_Position;\n    totalLocalPos += posePosition * in_weights[2];\n  gl_Position = u_MVPMatrix * totalLocalPos;\n  gl_PointSize = 2.5;         \n   vec3 modelViewVertex = vec3(u_MVMatrix * a_Position);\n             vec3 lightVector = normalize(u_LightPos - modelViewVertex);\n       vec3 modelViewNormal = vec3(u_MVMatrix * vec4(a_Normal, 0.0));\n    float diffuse = max(dot(modelViewNormal, lightVector), 0.1);\n      float distance = length(u_LightPos - modelViewVertex);\n            diffuse = diffuse * (1.0 / (1.0 + (0.05 * distance * distance)));\n  diffuse = diffuse + 0.5;   v_Color = vColor * diffuse;\n   v_Color[3] = vColor[3];  v_TexCoordinate = a_TexCoordinate;}                              \n";
    private static final String fragmentShaderCode = "precision mediump float;\nvarying vec4 v_Color;\nuniform sampler2D u_Texture;varying vec2 v_TexCoordinate;void main() {\n  gl_FragColor = v_Color * texture2D(u_Texture, v_TexCoordinate);\n}";

    public Object3DV9() {
        super("V9", vertexShaderCode, fragmentShaderCode, "a_Position", "in_jointIndices", "in_weights", "jointTransforms", "a_Normal", "vColor", "a_TexCoordinate");
    }

    @Override
    public void draw(Object3DData obj, float[] pMatrix, float[] vMatrix, int drawMode, int drawSize, int textureId, float[] lightPos) {
        AnimatedModel animatedModel = (AnimatedModel)obj;
        GLES20.glUseProgram((int)this.mProgram);
        int in_weightsHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"in_weights");
        GLUtil.checkGlError("glGetAttribLocation");
        if (in_weightsHandle < 0) {
            throw new RuntimeException("handle 'in_weights' not found");
        }
        GLES20.glEnableVertexAttribArray((int)in_weightsHandle);
        GLUtil.checkGlError("glEnableVertexAttribArray");
        animatedModel.getVertexWeights().position(0);
        GLES20.glVertexAttribPointer((int)in_weightsHandle, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)animatedModel.getVertexWeights());
        GLUtil.checkGlError("glVertexAttribPointer");
        int in_jointIndicesHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"in_jointIndices");
        GLUtil.checkGlError("glGetAttribLocation");
        if (in_jointIndicesHandle < 0) {
            throw new RuntimeException("handle 'in_jointIndicesHandle' not found");
        }
        GLES20.glEnableVertexAttribArray((int)in_jointIndicesHandle);
        GLUtil.checkGlError("glEnableVertexAttribArray");
        animatedModel.getJointIds().position(0);
        GLES20.glVertexAttribPointer((int)in_jointIndicesHandle, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)animatedModel.getJointIds());
        GLUtil.checkGlError("glVertexAttribPointer");
        float[][] jointTransformsArray = animatedModel.getJointTransforms();
        ArrayList<Integer> handles = new ArrayList<Integer>();
        for (int i = 0; i < jointTransformsArray.length; ++i) {
            float[] jointTransforms = jointTransformsArray[i];
            int jointTransformsHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)("jointTransforms[" + i + "]"));
            if (jointTransformsHandle < 0) {
                throw new RuntimeException("handle 'jointTransformsHandle[" + i + "]' not found");
            }
            GLUtil.checkGlError("glGetUniformLocation");
            GLES20.glUniformMatrix4fv((int)jointTransformsHandle, (int)1, (boolean)false, (float[])jointTransforms, (int)0);
            handles.add(jointTransformsHandle);
        }
        super.draw(obj, pMatrix, vMatrix, drawMode, drawSize, textureId, lightPos);
        GLES20.glDisableVertexAttribArray((int)in_weightsHandle);
        GLES20.glDisableVertexAttribArray((int)in_jointIndicesHandle);
        Iterator iterator = handles.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            GLES20.glDisableVertexAttribArray((int)i);
        }
    }

    @Override
    protected boolean supportsNormals() {
        return true;
    }

    @Override
    protected boolean supportsLighting() {
        return true;
    }

    @Override
    protected boolean supportsMvMatrix() {
        return true;
    }

    @Override
    protected boolean supportsTextures() {
        return true;
    }
}

