/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.services;

import android.content.Context;
import android.os.SystemClock;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.andresoviedo.app.model3D.animation.Animator;
import org.andresoviedo.app.model3D.model.Object3DBuilder;
import org.andresoviedo.app.model3D.model.Object3DData;
import org.andresoviedo.app.model3D.view.ModelSurfaceView;
import org.apache.commons.io.IOUtils;

public class SceneLoader {
    private static float[] DEFAULT_COLOR = new float[]{1.0f, 1.0f, 0.0f, 1.0f};
    protected final ModelSurfaceView parent;
    protected final Context context;
    private List<Object3DData> objects = new ArrayList<Object3DData>();
    private boolean drawWireframe = false;
    private boolean drawingPoints = false;
    private boolean drawBoundingBox = false;
    private boolean drawNormals = false;
    private boolean drawTextures = true;
    private boolean rotatingLight = false;
    private boolean drawLighting = false;
    private Object3DData selectedObject = null;
    private final float[] lightPosition = new float[]{0.0f, 0.0f, 6.0f, 1.0f};
    private final Object3DData lightPoint = Object3DBuilder.buildPoint(this.lightPosition).setId("light");
    private Animator animator;

    public SceneLoader(ModelSurfaceView parent, Context context) {
        this.parent = parent;
        this.context = context;
        this.animator = new Animator(parent);
    }

    public void init(String modelPath, String texturePath) {
        URL textureUrl;
        URL modelUrl;
        try {
            modelUrl = modelPath.startsWith("http") ? new URL(modelPath) : new File(modelPath).toURI().toURL();
            textureUrl = texturePath.startsWith("http") ? new URL(texturePath) : new File(texturePath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            Log.e((String)"SceneLoader", (String)e.getMessage(), (Throwable)e);
            this.parent.onLoadModelError();
            throw new RuntimeException(e);
        }
        if (modelUrl != null && textureUrl != null) {
            Object3DBuilder.loadV6AsyncParallel(this.context, modelUrl, new Object3DBuilder.Callback(){
                long startTime = SystemClock.uptimeMillis();

                @Override
                public void onBuildComplete(List<Object3DData> datas) {
                    for (Object3DData data : datas) {
                        SceneLoader.this.loadTexture(data, textureUrl);
                    }
                    String elapsed = (SystemClock.uptimeMillis() - this.startTime) / 1000L + " secs";
                    SceneLoader.this.parent.onLoadModelSuccess();
                }

                @Override
                public void onLoadComplete(List<Object3DData> datas) {
                    for (Object3DData data : datas) {
                        SceneLoader.this.addObject(data);
                    }
                }

                @Override
                public void onLoadError(Exception ex) {
                    SceneLoader.this.parent.onLoadModelError();
                    Log.e((String)"SceneLoader", (String)ex.getMessage(), (Throwable)ex);
                }
            });
        }
    }

    public Object3DData getLightBulb() {
        return this.lightPoint;
    }

    public float[] getLightPosition() {
        return this.lightPosition;
    }

    public void onDrawFrame() {
        this.animateLight();
        if (this.objects.isEmpty()) {
            return;
        }
        for (Object3DData obj : this.objects) {
            this.animator.update(obj);
        }
    }

    private void animateLight() {
        if (!this.rotatingLight) {
            return;
        }
        long time = SystemClock.uptimeMillis() % 5000L;
        float angleInDegrees = 0.072f * (float)((int)time);
        this.lightPoint.setRotationY(angleInDegrees);
    }

    protected synchronized void addObject(Object3DData obj) {
        ArrayList<Object3DData> newList = new ArrayList<Object3DData>(this.objects);
        float scale = this.parent.getScale();
        obj.setScale(new float[]{scale, scale, scale});
        newList.add(obj);
        this.objects = newList;
        this.selectedObject = obj;
        this.requestRender();
    }

    private void requestRender() {
        this.parent.getgLView().requestRender();
    }

    public synchronized List<Object3DData> getObjects() {
        return this.objects;
    }

    public void toggleWireframe() {
        if (this.drawWireframe && !this.drawingPoints) {
            this.drawWireframe = false;
            this.drawingPoints = true;
        } else if (this.drawingPoints) {
            this.drawingPoints = false;
        } else {
            this.drawWireframe = true;
        }
        this.requestRender();
    }

    public boolean isDrawWireframe() {
        return this.drawWireframe;
    }

    public boolean isDrawPoints() {
        return this.drawingPoints;
    }

    public void toggleBoundingBox() {
        this.drawBoundingBox = !this.drawBoundingBox;
        this.requestRender();
    }

    public boolean isDrawBoundingBox() {
        return this.drawBoundingBox;
    }

    public boolean isDrawNormals() {
        return this.drawNormals;
    }

    public void toggleTextures() {
        this.drawTextures = !this.drawTextures;
    }

    public void toggleLighting() {
        if (this.drawLighting && this.rotatingLight) {
            this.rotatingLight = false;
        } else if (this.drawLighting && !this.rotatingLight) {
            this.drawLighting = false;
        } else {
            this.drawLighting = true;
            this.rotatingLight = true;
        }
        this.requestRender();
    }

    public boolean isDrawTextures() {
        return this.drawTextures;
    }

    public boolean isDrawLighting() {
        return this.drawLighting;
    }

    public Object3DData getSelectedObject() {
        return this.selectedObject;
    }

    public void setSelectedObject(Object3DData selectedObject) {
        this.selectedObject = selectedObject;
    }

    public void loadTexture(final Object3DData data, final URL url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    InputStream stream = url.openStream();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)bos);
                    stream.close();
                    data.setTextureData(bos.toByteArray());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
    }

    public void setScale(float scale) {
        for (Object3DData data : this.objects) {
            data.setScale(new float[]{scale, scale, scale});
        }
    }

    public Animator getAnimator() {
        return this.animator;
    }
}

