/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.services;

import android.content.res.AssetManager;
import android.opengl.GLES20;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class WavefrontLoader {
    private static final float DUMMY_Z_TC = -5.0f;
    static final boolean INDEXES_START_AT_1 = true;
    private boolean hasTCs3D = false;
    private ArrayList<Tuple3> texCoords;
    private Faces faces;
    private FaceMaterials faceMats;
    private Materials materials;
    private ModelDimensions modelDims;
    private String modelNm;
    private float maxSize;
    int numVerts = 0;
    int numTextures = 0;
    int numNormals = 0;
    int numFaces = 0;
    int numVertsReferences = 0;
    private FloatBuffer vertsBuffer;
    private FloatBuffer normalsBuffer;
    private FloatBuffer textureCoordsBuffer;
    private static final int triangleMode = 6;

    public WavefrontLoader(String nm) {
        this.modelNm = nm;
        this.maxSize = 1.0f;
        this.texCoords = new ArrayList();
        this.faceMats = new FaceMaterials();
        this.modelDims = new ModelDimensions();
    }

    public FloatBuffer getVerts() {
        return this.vertsBuffer;
    }

    public FloatBuffer getNormals() {
        return this.normalsBuffer;
    }

    public ArrayList<Tuple3> getTexCoords() {
        return this.texCoords;
    }

    public Faces getFaces() {
        return this.faces;
    }

    public FaceMaterials getFaceMats() {
        return this.faceMats;
    }

    public Materials getMaterials() {
        return this.materials;
    }

    public ModelDimensions getDimensions() {
        return this.modelDims;
    }

    public void analyzeModel(InputStream is) {
        int lineNum = 0;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                ++lineNum;
                if ((line = line.trim()).length() <= 0) continue;
                if (line.startsWith("v ")) {
                    ++this.numVerts;
                    continue;
                }
                if (line.startsWith("vt")) {
                    ++this.numTextures;
                    continue;
                }
                if (line.startsWith("vn")) {
                    ++this.numNormals;
                    continue;
                }
                if (line.startsWith("f ")) {
                    int faceSize = line.contains("  ") ? line.split(" +").length - 1 : line.split(" ").length - 1;
                    this.numFaces += faceSize - 2;
                    this.numVertsReferences += (faceSize - 2) * 3;
                    continue;
                }
                if (line.startsWith("mtllib ")) {
                    this.materials = new Materials(line.substring(7));
                    continue;
                }
                if (line.startsWith("usemtl ") || line.charAt(0) == 'g' || line.charAt(0) == 's' || line.charAt(0) == '#' || line.charAt(0) == 'o') continue;
                System.out.println("Ignoring line " + lineNum + " : " + line);
            }
        }
        catch (IOException e) {
            Log.e((String)"WavefrontLoader", (String)("Problem reading line '" + ++lineNum + "'"));
            Log.e((String)"WavefrontLoader", (String)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Log.e((String)"WavefrontLoader", (String)e.getMessage(), (Throwable)e);
                }
            }
        }
        Log.i((String)"WavefrontLoader", (String)("Number of vertices:" + this.numVerts));
        Log.i((String)"WavefrontLoader", (String)("Number of faces:" + this.numFaces));
    }

    public void allocateBuffers() {
        this.vertsBuffer = WavefrontLoader.createNativeByteBuffer(this.numVerts * 3 * 4).asFloatBuffer();
        if (this.numNormals > 0) {
            this.normalsBuffer = WavefrontLoader.createNativeByteBuffer(this.numNormals * 3 * 4).asFloatBuffer();
        }
        this.textureCoordsBuffer = WavefrontLoader.createNativeByteBuffer(this.numTextures * 3 * 4).asFloatBuffer();
        if (this.numFaces > 0) {
            IntBuffer buffer = WavefrontLoader.createNativeByteBuffer(this.numFaces * 3 * 4).asIntBuffer();
            this.faces = new Faces(this.numFaces, buffer, this.vertsBuffer, this.normalsBuffer, this.texCoords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadModel(InputStream is) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            this.readModel(br);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static ByteBuffer createNativeByteBuffer(int length) {
        ByteBuffer bb = ByteBuffer.allocateDirect(length);
        bb.order(ByteOrder.nativeOrder());
        return bb;
    }

    private void readModel(BufferedReader br) {
        boolean isLoaded = true;
        int lineNum = 0;
        boolean isFirstCoord = true;
        boolean isFirstTC = true;
        int numFaces = 0;
        int vertNumber = 0;
        int normalNumber = 0;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ++lineNum;
                if ((line = line.trim()).length() <= 0) continue;
                if (line.startsWith("v ")) {
                    boolean bl = isLoaded = this.addVert(this.vertsBuffer, vertNumber++ * 3, line, isFirstCoord, this.modelDims) && isLoaded;
                    if (!isFirstCoord) continue;
                    isFirstCoord = false;
                    continue;
                }
                if (line.startsWith("vt")) {
                    boolean bl = isLoaded = this.addTexCoord(line, isFirstTC) && isLoaded;
                    if (!isFirstTC) continue;
                    isFirstTC = false;
                    continue;
                }
                if (line.startsWith("vn")) {
                    isLoaded = this.addVert(this.normalsBuffer, normalNumber++ * 3, line, isFirstCoord, null) && isLoaded;
                    continue;
                }
                if (line.startsWith("f ")) {
                    isLoaded = this.faces.addFace(line) && isLoaded;
                    ++numFaces;
                    continue;
                }
                if (line.startsWith("mtllib ")) continue;
                if (line.startsWith("usemtl ")) {
                    this.faceMats.addUse(numFaces, line.substring(7));
                    continue;
                }
                if (line.charAt(0) == 'g' || line.charAt(0) == 's' || line.charAt(0) == '#' || line.charAt(0) == 'o') continue;
                System.out.println("Ignoring line " + lineNum + " : " + line);
            }
        }
        catch (IOException e) {
            Log.e((String)"WavefrontLoader", (String)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (!isLoaded) {
            Log.e((String)"WavefrontLoader", (String)"Error loading model");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addVert(FloatBuffer buffer, int offset, String line, boolean isFirstCoord, ModelDimensions dimensions) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        try {
            String[] tokens = null;
            tokens = line.contains("  ") ? line.split(" +") : line.split(" ");
            x = Float.parseFloat(tokens[1]);
            y = Float.parseFloat(tokens[2]);
            z = Float.parseFloat(tokens[3]);
            if (dimensions != null) {
                if (isFirstCoord) {
                    this.modelDims.set(x, y, z);
                } else {
                    this.modelDims.update(x, y, z);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (NumberFormatException ex) {
            Log.e((String)"WavefrontLoader", (String)ex.getMessage());
        }
        finally {
            buffer.put(offset, x).put(offset + 1, y).put(offset + 2, z);
        }
        return false;
    }

    private boolean addTexCoord(String line, boolean isFirstTC) {
        Tuple3 texCoord;
        if (isFirstTC) {
            this.hasTCs3D = this.checkTC3D(line);
            System.out.println("Using 3D tex coords: " + this.hasTCs3D);
        }
        if ((texCoord = this.readTCTuple(line)) != null) {
            this.texCoords.add(texCoord);
            return true;
        }
        return false;
    }

    private boolean checkTC3D(String line) {
        String[] tokens = line.split("\\s+");
        return tokens.length == 4;
    }

    private Tuple3 readTCTuple(String line) {
        StringTokenizer tokens = new StringTokenizer(line, " ");
        tokens.nextToken();
        try {
            float x = Float.parseFloat(tokens.nextToken());
            float y = Float.parseFloat(tokens.nextToken());
            float z = -5.0f;
            if (this.hasTCs3D) {
                z = Float.parseFloat(tokens.nextToken());
            }
            return new Tuple3(x, y, z);
        }
        catch (NumberFormatException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void reportOnModel() {
        Log.i((String)"WavefrontLoader", (String)("No. of vertices: " + this.vertsBuffer.capacity() / 3));
        Log.i((String)"WavefrontLoader", (String)("No. of normal coords: " + this.numNormals));
        Log.i((String)"WavefrontLoader", (String)("No. of tex coords: " + this.texCoords.size()));
        Log.i((String)"WavefrontLoader", (String)("No. of faces: " + this.numFaces));
        this.modelDims.reportDimensions();
        if (this.materials != null) {
            this.materials.showMaterials();
        }
        this.faceMats.showUsedMaterials();
    }

    public static class FaceMaterials {
        private HashMap<Integer, String> faceMats = new HashMap();
        private HashMap<String, Integer> matCount = new HashMap();

        public void addUse(int faceIdx, String matName) {
            if (this.faceMats.containsKey(faceIdx)) {
                System.out.println("Face index " + faceIdx + " changed to use material " + matName);
            }
            this.faceMats.put(faceIdx, matName);
            if (this.matCount.containsKey(matName)) {
                int i = this.matCount.get(matName) + 1;
                this.matCount.put(matName, i);
            } else {
                this.matCount.put(matName, 1);
            }
        }

        public String findMaterial(int faceIdx) {
            return this.faceMats.get(faceIdx);
        }

        public void showUsedMaterials() {
            System.out.println("No. of materials used: " + this.faceMats.size());
            Set<String> keys = this.matCount.keySet();
            for (String matName : keys) {
                int count = this.matCount.get(matName);
                System.out.print(matName + ": " + count);
                System.out.println();
            }
        }

        public boolean isEmpty() {
            return this.faceMats.isEmpty() || this.matCount.isEmpty();
        }
    }

    public static class Faces {
        private static final float DUMMY_Z_TC = -5.0f;
        public final int totalFaces;
        public IntBuffer facesVertIdxs;
        public ArrayList<int[]> facesTexIdxs;
        public ArrayList<int[]> facesNormIdxs;
        private FloatBuffer normals;
        private ArrayList<Tuple3> texCoords;
        private int facesLoadCounter;
        private int faceVertexLoadCounter = 0;
        private int verticesReferencesCount;

        public Faces(int numFaces) {
            this.totalFaces = numFaces;
            this.facesLoadCounter = numFaces;
        }

        Faces(int totalFaces, IntBuffer buffer, FloatBuffer vs, FloatBuffer ns, ArrayList<Tuple3> ts) {
            this.totalFaces = totalFaces;
            this.normals = ns;
            this.texCoords = ts;
            this.facesVertIdxs = buffer;
            this.facesTexIdxs = new ArrayList();
            this.facesNormIdxs = new ArrayList();
        }

        public int getSize() {
            return this.totalFaces;
        }

        public boolean loaded() {
            return this.facesLoadCounter == this.totalFaces;
        }

        public boolean addFace(String line) {
            try {
                line = line.substring(2);
                String[] tokens = null;
                tokens = line.contains("  ") ? line.split(" +") : line.split(" ");
                int numTokens = tokens.length;
                int[] vt = null;
                int[] vn = null;
                int i = 0;
                int faceIndex = 0;
                while (i < numTokens) {
                    if (faceIndex > 2) {
                        faceIndex = 0;
                        ++this.facesLoadCounter;
                        this.verticesReferencesCount += 3;
                        if (vt != null) {
                            this.facesTexIdxs.add(vt);
                        }
                        if (vn != null) {
                            this.facesNormIdxs.add(vn);
                        }
                        vt = null;
                        vn = null;
                        i -= 2;
                    }
                    String faceToken = null;
                    faceToken = faceIndex == 0 ? tokens[0] : tokens[i];
                    String[] faceTokens = faceToken.split("/");
                    int numSeps = faceTokens.length;
                    int vertIdx = Integer.parseInt(faceTokens[0]);
                    if (numSeps > 1) {
                        if (vt == null) {
                            vt = new int[3];
                        }
                        try {
                            vt[faceIndex] = Integer.parseInt(faceTokens[1]);
                        }
                        catch (NumberFormatException ex) {
                            vt[faceIndex] = 0;
                        }
                    }
                    if (numSeps > 2) {
                        if (vn == null) {
                            vn = new int[3];
                        }
                        try {
                            vn[faceIndex] = Integer.parseInt(faceTokens[2]);
                        }
                        catch (NumberFormatException ex) {
                            vn[faceIndex] = 0;
                        }
                    }
                    --vertIdx;
                    if (vt != null) {
                        vt[faceIndex] = vt[faceIndex] - 1;
                    }
                    if (vn != null) {
                        vn[faceIndex] = vn[faceIndex] - 1;
                    }
                    this.facesVertIdxs.put(this.faceVertexLoadCounter++, vertIdx);
                    ++i;
                    ++faceIndex;
                }
                if (vt != null) {
                    this.facesTexIdxs.add(vt);
                }
                if (vn != null) {
                    this.facesNormIdxs.add(vn);
                }
                ++this.facesLoadCounter;
                this.verticesReferencesCount += 3;
            }
            catch (NumberFormatException e) {
                Log.e((String)"WavefrontLoader", (String)e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }

        public int getVerticesReferencesCount() {
            return this.getSize() * 3;
        }

        public IntBuffer getIndexBuffer() {
            return this.facesVertIdxs;
        }
    }

    public static class Material {
        private String name;
        private Tuple3 ka;
        private Tuple3 kd;
        private Tuple3 ks;
        private float ns;
        private float d;
        private String texFnm;
        private String texture;

        public Material(String nm) {
            this.name = nm;
            this.d = 1.0f;
            this.ns = 0.0f;
            this.ka = null;
            this.kd = null;
            this.ks = null;
            this.texFnm = null;
            this.texture = null;
        }

        public void showMaterial() {
            System.out.println(this.name);
            if (this.ka != null) {
                System.out.println("  Ka: " + this.ka.toString());
            }
            if (this.kd != null) {
                System.out.println("  Kd: " + this.kd.toString());
            }
            if (this.ks != null) {
                System.out.println("  Ks: " + this.ks.toString());
            }
            if (this.ns != 0.0f) {
                System.out.println("  Ns: " + this.ns);
            }
            if (this.d != 1.0f) {
                System.out.println("  d: " + this.d);
            }
            if (this.texFnm != null) {
                System.out.println("  Texture file: " + this.texFnm);
            }
        }

        public boolean hasName(String nm) {
            return this.name.equals(nm);
        }

        public void setD(float val) {
            this.d = val;
        }

        public float getD() {
            return this.d;
        }

        public void setNs(float val) {
            this.ns = val;
        }

        public float getNs() {
            return this.ns;
        }

        public void setKa(Tuple3 t) {
            this.ka = t;
        }

        public Tuple3 getKa() {
            return this.ka;
        }

        public void setKd(Tuple3 t) {
            this.kd = t;
        }

        public Tuple3 getKd() {
            return this.kd;
        }

        public float[] getKdColor() {
            if (this.kd == null) {
                return null;
            }
            return new float[]{this.kd.getX(), this.kd.getY(), this.kd.getZ(), this.getD()};
        }

        public void setKs(Tuple3 t) {
            this.ks = t;
        }

        public Tuple3 getKs() {
            return this.ks;
        }

        public void setMaterialColors(GLES20 gl) {
        }

        public void setTexture(String t) {
            this.texture = t;
        }

        public String getTexture() {
            return this.texture;
        }

        String getName() {
            return this.name;
        }
    }

    public static class Materials {
        public Map<String, Material> materials = new LinkedHashMap<String, Material>();
        private String mfnm;

        public Materials(String mtlFnm) {
            this.mfnm = mtlFnm;
        }

        public void readMaterials(File currentDir, String assetsDir, AssetManager am) {
            try {
                InputStream is;
                if (currentDir != null) {
                    File file = new File(currentDir, this.mfnm);
                    System.out.println("Loading material from " + file);
                    is = new FileInputStream(file);
                } else {
                    System.out.println("Loading material from " + this.mfnm);
                    is = am.open(assetsDir + "/" + this.mfnm);
                }
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                this.readMaterials(br);
                br.close();
            }
            catch (FileNotFoundException ex) {
                Log.w((String)"WavefrontLoader", (String)ex.getMessage());
            }
            catch (IOException e) {
                Log.e((String)"WavefrontLoader", (String)e.getMessage(), (Throwable)e);
            }
        }

        private void readMaterials(BufferedReader br) {
            Log.v((String)"materials", (String)"Reading material...");
            try {
                String line;
                Material currMaterial = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    if (line.startsWith("newmtl ")) {
                        if (currMaterial != null) {
                            this.materials.put(currMaterial.getName(), currMaterial);
                        }
                        String name = line.substring(7);
                        Log.d((String)"Loader", (String)("New material found: " + name));
                        currMaterial = new Material(name);
                        continue;
                    }
                    if (line.startsWith("map_Kd ")) {
                        String textureFilename = line.substring(7);
                        Log.d((String)"Loader", (String)("New texture found: " + textureFilename));
                        currMaterial.setTexture(textureFilename);
                        continue;
                    }
                    if (line.startsWith("Ka ")) {
                        currMaterial.setKa(this.readTuple3(line));
                        continue;
                    }
                    if (line.startsWith("Kd ")) {
                        currMaterial.setKd(this.readTuple3(line));
                        continue;
                    }
                    if (line.startsWith("Ks ")) {
                        currMaterial.setKs(this.readTuple3(line));
                        continue;
                    }
                    if (line.startsWith("Ns ")) {
                        float val = Float.valueOf(line.substring(3)).floatValue();
                        currMaterial.setNs(val);
                        continue;
                    }
                    if (line.charAt(0) == 'd') {
                        float val = Float.valueOf(line.substring(2)).floatValue();
                        currMaterial.setD(val);
                        continue;
                    }
                    if (line.startsWith("Tr ")) {
                        float val = Float.valueOf(line.substring(3)).floatValue();
                        currMaterial.setD(1.0f - val);
                        continue;
                    }
                    if (line.startsWith("illum ") || line.charAt(0) == '#') continue;
                    System.out.println("Ignoring MTL line: " + line);
                }
                if (currMaterial != null) {
                    this.materials.put(currMaterial.getName(), currMaterial);
                }
            }
            catch (Exception e) {
                Log.e((String)"materials", (String)e.getMessage(), (Throwable)e);
            }
        }

        private Tuple3 readTuple3(String line) {
            StringTokenizer tokens = new StringTokenizer(line, " ");
            tokens.nextToken();
            try {
                float x = Float.parseFloat(tokens.nextToken());
                float y = Float.parseFloat(tokens.nextToken());
                float z = Float.parseFloat(tokens.nextToken());
                return new Tuple3(x, y, z);
            }
            catch (NumberFormatException e) {
                System.out.println(e.getMessage());
                return null;
            }
        }

        public void showMaterials() {
            Log.i((String)"WavefrontLoader", (String)("No. of materials: " + this.materials.size()));
            for (int i = 0; i < this.materials.size(); ++i) {
                Material m = this.materials.get(i);
                m.showMaterial();
            }
        }

        public Material getMaterial(String name) {
            return this.materials.get(name);
        }
    }

    public static class ModelDimensions {
        public float leftPt = 0.0f;
        public float rightPt = 0.0f;
        public float topPt = 0.0f;
        public float bottomPt = 0.0f;
        public float farPt = 0.0f;
        public float nearPt = 0.0f;
        private DecimalFormat df = new DecimalFormat("0.##");

        public void set(float x, float y, float z) {
            this.rightPt = x;
            this.leftPt = x;
            this.topPt = y;
            this.bottomPt = y;
            this.nearPt = z;
            this.farPt = z;
        }

        public void update(float x, float y, float z) {
            if (x > this.rightPt) {
                this.rightPt = x;
            }
            if (x < this.leftPt) {
                this.leftPt = x;
            }
            if (y > this.topPt) {
                this.topPt = y;
            }
            if (y < this.bottomPt) {
                this.bottomPt = y;
            }
            if (z > this.nearPt) {
                this.nearPt = z;
            }
            if (z < this.farPt) {
                this.farPt = z;
            }
        }

        public float getWidth() {
            return this.rightPt - this.leftPt;
        }

        public float getHeight() {
            return this.topPt - this.bottomPt;
        }

        public float getDepth() {
            return this.nearPt - this.farPt;
        }

        public float getLargest() {
            float height = this.getHeight();
            float depth = this.getDepth();
            float largest = this.getWidth();
            if (height > largest) {
                largest = height;
            }
            if (depth > largest) {
                largest = depth;
            }
            return largest;
        }

        public Tuple3 getCenter() {
            float xc = (this.rightPt + this.leftPt) / 2.0f;
            float yc = (this.topPt + this.bottomPt) / 2.0f;
            float zc = (this.nearPt + this.farPt) / 2.0f;
            return new Tuple3(xc, yc, zc);
        }

        public void reportDimensions() {
            Tuple3 center = this.getCenter();
            System.out.println("x Coords: " + this.df.format(this.leftPt) + " to " + this.df.format(this.rightPt));
            System.out.println("  Mid: " + this.df.format(center.getX()) + "; Width: " + this.df.format(this.getWidth()));
            System.out.println("y Coords: " + this.df.format(this.bottomPt) + " to " + this.df.format(this.topPt));
            System.out.println("  Mid: " + this.df.format(center.getY()) + "; Height: " + this.df.format(this.getHeight()));
            System.out.println("z Coords: " + this.df.format(this.nearPt) + " to " + this.df.format(this.farPt));
            System.out.println("  Mid: " + this.df.format(center.getZ()) + "; Depth: " + this.df.format(this.getDepth()));
        }
    }

    public static class Tuple3 {
        private float x;
        private float y;
        private float z;

        public Tuple3(float xc, float yc, float zc) {
            this.x = xc;
            this.y = yc;
            this.z = zc;
        }

        public String toString() {
            return "( " + this.x + ", " + this.y + ", " + this.z + " )";
        }

        public void setX(float xc) {
            this.x = xc;
        }

        public float getX() {
            return this.x;
        }

        public void setY(float yc) {
            this.y = yc;
        }

        public float getY() {
            return this.y;
        }

        public void setZ(float zc) {
            this.z = zc;
        }

        public float getZ() {
            return this.z;
        }
    }
}

