/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.services.collada.entities;

import android.opengl.Matrix;
import java.util.ArrayList;
import java.util.List;

public class Joint {
    public final int index;
    public final String name;
    public final List<Joint> children = new ArrayList<Joint>();
    private float[] animatedTransform = new float[16];
    private final float[] localBindTransform;
    private float[] inverseBindTransform = new float[16];

    public Joint(int index, String name, float[] bindLocalTransform) {
        this.index = index;
        this.name = name;
        this.localBindTransform = bindLocalTransform;
        Matrix.setIdentityM((float[])this.animatedTransform, (int)0);
    }

    public void addChild(Joint child) {
        this.children.add(child);
    }

    public float[] getAnimatedTransform() {
        return this.animatedTransform;
    }

    public void setAnimationTransform(float[] animationTransform) {
        this.animatedTransform = animationTransform;
    }

    public float[] getInverseBindTransform() {
        return this.inverseBindTransform;
    }

    public void calcInverseBindTransform(float[] parentBindTransform) {
        float[] bindTransform = new float[16];
        Matrix.multiplyMM((float[])bindTransform, (int)0, (float[])parentBindTransform, (int)0, (float[])this.localBindTransform, (int)0);
        Matrix.invertM((float[])this.inverseBindTransform, (int)0, (float[])bindTransform, (int)0);
        for (Joint child : this.children) {
            child.calcInverseBindTransform(bindTransform);
        }
    }
}

