/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.services.collada.entities;

import java.nio.FloatBuffer;

public class MeshData {
    private static final int DIMENSIONS = 3;
    private String id;
    private float[] vertices;
    private float[] textureCoords;
    private float[] normals;
    private FloatBuffer colorsBuffer;
    private String texture;
    private int[] indices;
    private int[] jointIds;
    private float[] vertexWeights;

    public MeshData(String id, float[] vertices, float[] textureCoords, float[] normals, FloatBuffer colorsBuffer, String texture, int[] indices, int[] jointIds, float[] vertexWeights) {
        this.id = id;
        this.vertices = vertices;
        this.textureCoords = textureCoords;
        this.normals = normals;
        this.colorsBuffer = colorsBuffer;
        this.texture = texture;
        this.indices = indices;
        this.jointIds = jointIds;
        this.vertexWeights = vertexWeights;
    }

    public int[] getJointIds() {
        return this.jointIds;
    }

    public float[] getVertexWeights() {
        return this.vertexWeights;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public float[] getTextureCoords() {
        return this.textureCoords;
    }

    public float[] getNormals() {
        return this.normals;
    }

    public FloatBuffer getColorsBuffer() {
        return this.colorsBuffer;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public int getVertexCount() {
        return this.vertices.length / 3;
    }

    public String getId() {
        return this.id;
    }

    public String getTexture() {
        return this.texture;
    }
}

