/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.services.collada.entities;

import java.util.ArrayList;
import java.util.List;

public class VertexSkinData {
    public final List<Integer> jointIds = new ArrayList<Integer>();
    public final List<Float> weights = new ArrayList<Float>();

    public void addJointEffect(int jointId, float weight) {
        for (int i = 0; i < this.weights.size(); ++i) {
            if (!(weight > this.weights.get(i).floatValue())) continue;
            this.jointIds.add(i, jointId);
            this.weights.add(i, Float.valueOf(weight));
            return;
        }
        this.jointIds.add(jointId);
        this.weights.add(Float.valueOf(weight));
    }

    public void limitJointNumber(int max) {
        if (this.jointIds.size() > max) {
            float[] topWeights = new float[max];
            float total = this.saveTopWeights(topWeights);
            this.refillWeightList(topWeights, total);
            this.removeExcessJointIds(max);
        } else if (this.jointIds.size() < max) {
            this.fillEmptyWeights(max);
        }
    }

    private void fillEmptyWeights(int max) {
        while (this.jointIds.size() < max) {
            this.jointIds.add(0);
            this.weights.add(Float.valueOf(0.0f));
        }
    }

    private float saveTopWeights(float[] topWeightsArray) {
        float total = 0.0f;
        for (int i = 0; i < topWeightsArray.length; ++i) {
            topWeightsArray[i] = this.weights.get(i).floatValue();
            total += topWeightsArray[i];
        }
        return total;
    }

    private void refillWeightList(float[] topWeights, float total) {
        this.weights.clear();
        for (int i = 0; i < topWeights.length; ++i) {
            this.weights.add(Float.valueOf(Math.min(topWeights[i] / total, 1.0f)));
        }
    }

    private void removeExcessJointIds(int max) {
        while (this.jointIds.size() > max) {
            this.jointIds.remove(this.jointIds.size() - 1);
        }
    }
}

