/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.services.collada.loader;

import android.opengl.Matrix;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.andresoviedo.app.model3D.services.collada.entities.AnimationData;
import org.andresoviedo.app.model3D.services.collada.entities.JointTransformData;
import org.andresoviedo.app.model3D.services.collada.entities.KeyFrameData;
import org.andresoviedo.app.util.xml.XmlNode;

public class AnimationLoader {
    private static final float[] CORRECTION = new float[16];
    private XmlNode animationData;
    private XmlNode jointHierarchy;

    public AnimationLoader(XmlNode animationData, XmlNode jointHierarchy) {
        this.animationData = animationData;
        this.jointHierarchy = jointHierarchy;
    }

    public AnimationData extractAnimation() {
        String rootNode = this.findRootJointName();
        TreeSet<Float> times = this.getKeyTimes();
        float duration = times.last().floatValue();
        ArrayList<Float> keyTimes = new ArrayList<Float>(times);
        KeyFrameData[] keyFrames = this.initKeyFrames(keyTimes);
        List<XmlNode> animationNodes = this.animationData.getChildren("animation");
        for (XmlNode jointNode : animationNodes) {
            if (jointNode.getChild("animation") != null) {
                jointNode = jointNode.getChild("animation");
            }
            this.loadJointTransforms(keyTimes, keyFrames, jointNode, rootNode);
        }
        Log.i((String)"AnimationLoader", (String)("Animation duration: " + duration + ", key frames(" + keyFrames.length + "):" + times));
        return new AnimationData(duration, keyFrames);
    }

    private TreeSet<Float> getKeyTimes() {
        TreeSet<Float> ret = new TreeSet<Float>();
        for (XmlNode animation : this.animationData.getChildren("animation")) {
            if (animation.getChild("animation") != null) {
                animation = animation.getChild("animation");
            }
            XmlNode timeData = animation.getChild("source").getChild("float_array");
            String[] rawTimes = timeData.getData().trim().split("\\s+");
            for (int i = 0; i < rawTimes.length; ++i) {
                ret.add(Float.valueOf(Float.parseFloat(rawTimes[i])));
            }
        }
        return ret;
    }

    private KeyFrameData[] initKeyFrames(List<Float> times) {
        KeyFrameData[] frames = new KeyFrameData[times.size()];
        int i = 0;
        for (Float time : times) {
            frames[i++] = new KeyFrameData(time.floatValue());
        }
        return frames;
    }

    private void loadJointTransforms(List<Float> keyTimes, KeyFrameData[] frames, XmlNode jointData, String rootNodeId) {
        String[] channel = this.getChannel(jointData);
        String jointNameId = channel[0];
        String transform = channel[1];
        String dataId = this.getDataId(jointData);
        String timeId = this.getTimeId(jointData);
        try {
            XmlNode timeData = jointData.getChildWithAttribute("source", "id", timeId);
            String[] rawTimes = timeData.getChild("float_array").getData().trim().split("\\s+");
            XmlNode transformData = jointData.getChildWithAttribute("source", "id", dataId);
            String[] rawData = transformData.getChild("float_array").getData().trim().split("\\s+");
            XmlNode technique_common = transformData.getChild("technique_common");
            XmlNode accessor = technique_common.getChild("accessor");
            if (accessor.getAttribute("stride").equals("16")) {
                this.processTransforms(jointNameId, rawTimes, rawData, keyTimes, frames, jointNameId.equals(rootNodeId));
            } else if (accessor.getAttribute("stride").equals("2")) {
                this.processXYTransforms(jointNameId, rawTimes, rawData, keyTimes, frames, jointNameId.equals(rootNodeId));
            } else if (accessor.getAttribute("stride").equals("1")) {
                if (accessor.getChildWithAttribute("param", "name", "X") != null) {
                    this.processXTransforms(jointNameId, rawTimes, rawData, keyTimes, frames, jointNameId.equals(rootNodeId));
                } else if (accessor.getChildWithAttribute("param", "name", "Z") != null) {
                    this.processZTransforms(jointNameId, rawTimes, rawData, keyTimes, frames, jointNameId.equals(rootNodeId));
                } else if (transform.equals("rotationZ.ANGLE")) {
                    this.processRotationZTransforms(jointNameId, rawTimes, rawData, keyTimes, frames, jointNameId.equals(rootNodeId));
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"AnimationLoader", (String)("Problem loading animation for joint '" + jointNameId + "' with source '" + dataId + "'"), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getDataId(XmlNode jointData) {
        XmlNode node = jointData.getChild("sampler").getChildWithAttribute("input", "semantic", "OUTPUT");
        return node.getAttribute("source").substring(1);
    }

    private String getTimeId(XmlNode jointData) {
        XmlNode node = jointData.getChild("sampler").getChildWithAttribute("input", "semantic", "INPUT");
        return node.getAttribute("source").substring(1);
    }

    private String[] getChannel(XmlNode jointData) {
        XmlNode channelNode = jointData.getChild("channel");
        String data = channelNode.getAttribute("target");
        return data.split("/");
    }

    private void processTransforms(String jointName, String[] rawTimes, String[] rawData, List<Float> keyTimes, KeyFrameData[] keyFrames, boolean root) {
        float[] matrixData = new float[16];
        for (int i = 0; i < rawTimes.length; ++i) {
            Float keyTime = Float.valueOf(Float.parseFloat(rawTimes[i]));
            for (int j = 0; j < 16; ++j) {
                matrixData[j] = Float.parseFloat(rawData[i * 16 + j]);
            }
            float[] transpose = new float[16];
            Matrix.transposeM((float[])transpose, (int)0, (float[])matrixData, (int)0);
            if (root) {
                Matrix.multiplyMM((float[])transpose, (int)0, (float[])CORRECTION, (int)0, (float[])transpose, (int)0);
            }
            int keyFrameIndex = keyTimes.indexOf(keyTime);
            keyFrames[keyFrameIndex].addJointTransform(new JointTransformData(jointName, transpose));
        }
    }

    private void processXYTransforms(String jointName, String[] rawTimes, String[] rawData, List<Float> keyTimes, KeyFrameData[] keyFrames, boolean root) {
        for (int i = 0; i < rawTimes.length; ++i) {
            Float keyTime = Float.valueOf(Float.parseFloat(rawTimes[i]));
            float[] matrixData = new float[16];
            Matrix.setIdentityM((float[])matrixData, (int)0);
            Matrix.translateM((float[])matrixData, (int)0, (float[])matrixData, (int)0, (float)Float.parseFloat(rawData[i * 2 + 0]), (float)Float.parseFloat(rawData[i * 2 + 1]), (float)0.0f);
            if (root) {
                Matrix.multiplyMM((float[])matrixData, (int)0, (float[])CORRECTION, (int)0, (float[])matrixData, (int)0);
            }
            keyFrames[keyTimes.indexOf(keyTime)].addJointTransform(new JointTransformData(jointName, matrixData));
        }
    }

    private void processXTransforms(String jointName, String[] rawTimes, String[] rawData, List<Float> keyTimes, KeyFrameData[] keyFrames, boolean root) {
        for (int i = 0; i < rawTimes.length; ++i) {
            Float keyTime = Float.valueOf(Float.parseFloat(rawTimes[i]));
            float[] matrixData = new float[16];
            Matrix.setIdentityM((float[])matrixData, (int)0);
            Matrix.translateM((float[])matrixData, (int)0, (float[])matrixData, (int)0, (float)Float.parseFloat(rawData[i]), (float)0.0f, (float)0.0f);
            if (root) {
                Matrix.multiplyMM((float[])matrixData, (int)0, (float[])CORRECTION, (int)0, (float[])matrixData, (int)0);
            }
            keyFrames[keyTimes.indexOf(keyTime)].addJointTransform(new JointTransformData(jointName, matrixData));
        }
    }

    private void processZTransforms(String jointName, String[] rawTimes, String[] rawData, List<Float> keyTimes, KeyFrameData[] keyFrames, boolean root) {
        for (int i = 0; i < rawTimes.length; ++i) {
            Float keyTime = Float.valueOf(Float.parseFloat(rawTimes[i]));
            float[] matrixData = new float[16];
            Matrix.setIdentityM((float[])matrixData, (int)0);
            Matrix.translateM((float[])matrixData, (int)0, (float[])matrixData, (int)0, (float)0.0f, (float)0.0f, (float)Float.parseFloat(rawData[i]));
            if (root) {
                Matrix.multiplyMM((float[])matrixData, (int)0, (float[])CORRECTION, (int)0, (float[])matrixData, (int)0);
            }
            keyFrames[keyTimes.indexOf(keyTime)].addJointTransform(new JointTransformData(jointName, matrixData));
        }
    }

    private void processRotationZTransforms(String jointName, String[] rawTimes, String[] rawData, List<Float> keyTimes, KeyFrameData[] keyFrames, boolean root) {
        for (int i = 0; i < rawTimes.length; ++i) {
            Float keyTime = Float.valueOf(Float.parseFloat(rawTimes[i]));
            float[] matrixData = new float[16];
            Matrix.setIdentityM((float[])matrixData, (int)0);
            Matrix.rotateM((float[])matrixData, (int)0, (float[])matrixData, (int)0, (float)Float.parseFloat(rawData[i]), (float)0.0f, (float)1.0f, (float)0.0f);
            keyFrames[keyTimes.indexOf(keyTime)].addJointTransform(new JointTransformData(jointName, matrixData));
        }
    }

    private String findRootJointName() {
        XmlNode skeleton = this.jointHierarchy.getChild("visual_scene").getChildWithAttribute("node", "id", "Armature");
        return skeleton.getChild("node").getAttribute("id");
    }

    static {
        Matrix.setIdentityM((float[])CORRECTION, (int)0);
        Matrix.rotateM((float[])CORRECTION, (int)0, (float[])CORRECTION, (int)0, (float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    }
}

