/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.services.collada.loader;

import android.opengl.Matrix;
import android.renderscript.Matrix4f;
import android.util.Log;
import java.util.List;
import org.andresoviedo.app.model3D.services.collada.entities.JointData;
import org.andresoviedo.app.model3D.services.collada.entities.SkeletonData;
import org.andresoviedo.app.util.xml.XmlNode;

public class SkeletonLoader {
    private XmlNode armatureData;
    private List<String> boneOrder;
    private int jointCount = 0;
    private static final float[] CORRECTION = new float[16];

    public SkeletonLoader(XmlNode visualSceneNode, List<String> boneOrder) {
        this.armatureData = visualSceneNode.getChild("visual_scene").getChildWithAttribute("node", "id", "Armature");
        this.boneOrder = boneOrder;
    }

    public SkeletonData extractBoneData() {
        XmlNode headNode = this.armatureData.getChildWithAttribute("node", "type", "JOINT");
        JointData headJoint = this.loadJointData(headNode, true);
        if (this.jointCount != this.boneOrder.size()) {
            Log.e((String)"SkeletonLoader", (String)("jointCount != boneOrder: " + this.jointCount + " != " + this.boneOrder.size()));
            this.jointCount = this.boneOrder.size();
        }
        return new SkeletonData(this.jointCount, headJoint);
    }

    private JointData loadJointData(XmlNode jointNode, boolean isRoot) {
        JointData joint = this.extractMainJointData(jointNode, isRoot);
        for (XmlNode childNode : jointNode.getChildren("node")) {
            joint.addChild(this.loadJointData(childNode, false));
        }
        return joint;
    }

    private JointData extractMainJointData(XmlNode jointNode, boolean isRoot) {
        String nameId = jointNode.getAttribute("id");
        int index = this.boneOrder.indexOf(nameId);
        if (index == -1) {
            Log.e((String)"SkeletonLoader", (String)("Joint not found in order: " + nameId));
            this.boneOrder.add(nameId);
            index = this.boneOrder.indexOf(nameId);
        }
        String[] matrixData = jointNode.getChild("matrix").getData().trim().split("\\s+");
        Matrix4f matrix = new Matrix4f(this.convertData(matrixData));
        matrix.transpose();
        if (isRoot) {
            Matrix4f correction = new Matrix4f(CORRECTION);
            correction.multiply(matrix);
            matrix = correction;
        }
        ++this.jointCount;
        return new JointData(index, nameId, matrix.getArray());
    }

    private float[] convertData(String[] rawData) {
        float[] matrixData = new float[16];
        for (int i = 0; i < matrixData.length; ++i) {
            matrixData[i] = Float.parseFloat(rawData[i]);
        }
        return matrixData;
    }

    static {
        Matrix.setIdentityM((float[])CORRECTION, (int)0);
        Matrix.rotateM((float[])CORRECTION, (int)0, (float[])CORRECTION, (int)0, (float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    }
}

