/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.services.collada.loader;

import android.opengl.Matrix;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.andresoviedo.app.model3D.services.collada.entities.JointData;
import org.andresoviedo.app.model3D.services.collada.entities.SkeletonData;
import org.andresoviedo.app.util.xml.XmlNode;

public class SkeletonLoader2 {
    private XmlNode visualScene;
    private List<String> boneOrder = new ArrayList<String>();
    private int jointCount = 0;
    private static final float[] CORRECTION = new float[16];

    public SkeletonLoader2(XmlNode visualSceneNode) {
        this.visualScene = visualSceneNode.getChild("visual_scene");
    }

    public SkeletonData extractBoneData() {
        XmlNode node = this.visualScene.getChildWithAttribute("node", "id", "Armature");
        JointData headJoint = this.loadJointData(node, true);
        if (this.jointCount != this.boneOrder.size()) {
            Log.e((String)"SkeletonLoader2", (String)("jointCount != boneOrder: " + this.jointCount + " != " + this.boneOrder.size()));
            this.jointCount = this.boneOrder.size();
        }
        return new SkeletonData(this.jointCount, headJoint);
    }

    private JointData loadJointData(XmlNode jointNode, boolean isRoot) {
        JointData joint = this.extractMainJointData(jointNode, isRoot);
        for (XmlNode childNode : jointNode.getChildren("node")) {
            joint.addChild(this.loadJointData(childNode, false));
        }
        return joint;
    }

    private JointData extractMainJointData(XmlNode jointNode, boolean isRoot) {
        XmlNode instance_geometry = jointNode.getChild("instance_geometry");
        String meshId = instance_geometry != null ? instance_geometry.getAttribute("url").substring(1) : null;
        String nameId = jointNode.getAttribute("id");
        int index = this.boneOrder.indexOf(nameId);
        if (index == -1) {
            Log.e((String)"SkeletonLoader2", (String)("Joint not found in order: " + nameId));
            this.boneOrder.add(nameId);
            index = this.boneOrder.indexOf(nameId);
        }
        String[] matrixData = jointNode.getChild("translate").getData().split(" ");
        float[] matrix = new float[16];
        Matrix.setIdentityM((float[])matrix, (int)0);
        Matrix.translateM((float[])matrix, (int)0, (float[])matrix, (int)0, (float)Float.valueOf(matrixData[0]).floatValue(), (float)Float.valueOf(matrixData[1]).floatValue(), (float)Float.valueOf(matrixData[2]).floatValue());
        if (isRoot) {
            // empty if block
        }
        ++this.jointCount;
        return new JointData(index, nameId, matrix).setMeshId(meshId);
    }

    private float[] convertData(String[] rawData) {
        float[] matrixData = new float[16];
        for (int i = 0; i < matrixData.length; ++i) {
            matrixData[i] = Float.parseFloat(rawData[i]);
        }
        return matrixData;
    }

    static {
        Matrix.setIdentityM((float[])CORRECTION, (int)0);
        Matrix.rotateM((float[])CORRECTION, (int)0, (float[])CORRECTION, (int)0, (float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    }
}

