/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.services.wavefront;

import android.content.Context;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.andresoviedo.app.model3D.controller.LoaderTask;
import org.andresoviedo.app.model3D.model.Object3DBuilder;
import org.andresoviedo.app.model3D.model.Object3DData;
import org.andresoviedo.app.model3D.services.WavefrontLoader;

public class WavefrontLoader2 {
    public static void loadAsync(Context context, URL url, Object3DBuilder.Callback callback) {
        new LoaderTask(context, url, callback){

            private InputStream getInputStream() {
                try {
                    return this.url.openStream();
                }
                catch (Exception e) {
                    Log.e((String)"LoaderTask", (String)e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }

            private void closeStream(InputStream stream) {
                if (stream == null) {
                    return;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException ex) {
                    Log.e((String)"LoaderTask", (String)("Problem closing stream: " + ex.getMessage()), (Throwable)ex);
                }
            }

            @Override
            protected List<Object3DData> build() throws IOException {
                InputStream params0 = this.getInputStream();
                WavefrontLoader wfl = new WavefrontLoader("");
                this.publishProgress(new Integer[]{0});
                wfl.analyzeModel(params0);
                this.closeStream(params0);
                this.publishProgress(new Integer[]{1});
                wfl.allocateBuffers();
                wfl.reportOnModel();
                Object3DData data3D = new Object3DData(wfl.getVerts(), wfl.getNormals(), wfl.getTexCoords(), wfl.getFaces(), wfl.getFaceMats(), wfl.getMaterials());
                data3D.setLoader(wfl);
                data3D.setDrawMode(4);
                data3D.setDimensions(data3D.getLoader().getDimensions());
                return Collections.singletonList(data3D);
            }

            @Override
            protected void build(List<Object3DData> datas) throws Exception {
                InputStream stream = this.getInputStream();
                try {
                    Object3DData data = datas.get(0);
                    this.publishProgress(new Integer[]{2});
                    data.getLoader().loadModel(stream);
                    this.closeStream(stream);
                    this.publishProgress(new Integer[]{3});
                    data.centerScale();
                    data.setDrawMode(4);
                    this.publishProgress(new Integer[]{4});
                    Object3DBuilder.generateArrays(this.context.getAssets(), data);
                    this.publishProgress(new Integer[]{5});
                }
                catch (Exception e) {
                    Log.e((String)"Object3DBuilder", (String)e.getMessage(), (Throwable)e);
                    throw e;
                }
                finally {
                    this.closeStream(stream);
                }
            }
        }.execute(new Void[0]);
    }
}

