/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import java.io.InputStream;

public final class GLUtil {
    private static final String TAG = "GLUtil";

    private GLUtil() {
    }

    public static int createAndLinkProgram(int vertexShaderHandle, int fragmentShaderHandle, String[] attributes) {
        int programHandle = GLES20.glCreateProgram();
        if (programHandle != 0) {
            GLES20.glAttachShader((int)programHandle, (int)vertexShaderHandle);
            GLES20.glAttachShader((int)programHandle, (int)fragmentShaderHandle);
            if (attributes != null) {
                int size = attributes.length;
                for (int i = 0; i < size; ++i) {
                    GLES20.glBindAttribLocation((int)programHandle, (int)i, (String)attributes[i]);
                }
            }
            GLES20.glLinkProgram((int)programHandle);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)programHandle, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] == 0) {
                Log.e((String)TAG, (String)("Error compiling program: " + GLES20.glGetProgramInfoLog((int)programHandle)));
                GLES20.glDeleteProgram((int)programHandle);
                programHandle = 0;
            }
        }
        if (programHandle == 0) {
            throw new RuntimeException("Error creating program.");
        }
        return programHandle;
    }

    public static int loadShader(int type, String shaderCode) {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)shaderCode);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            GLES20.glDeleteShader((int)shader);
            Log.e((String)TAG, (String)("Could not compile program: " + GLES20.glGetShaderInfoLog((int)shader) + " | " + shaderCode));
        }
        return shader;
    }

    public static int loadTexture(InputStream is) {
        Log.v((String)TAG, (String)("Loading texture '" + is + "' from stream..."));
        int[] textureHandle = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandle, (int)0);
        GLUtil.checkGlError("glGenTextures");
        if (textureHandle[0] != 0) {
            Log.i((String)TAG, (String)("Handler: " + textureHandle[0]));
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inScaled = false;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            if (bitmap == null) {
                throw new RuntimeException("couldnt load bitmap");
            }
            GLES20.glBindTexture((int)3553, (int)textureHandle[0]);
            GLUtil.checkGlError("glBindTexture");
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            GLUtil.checkGlError("texImage2D");
            bitmap.recycle();
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (textureHandle[0] == 0) {
            throw new RuntimeException("Error loading texture.");
        }
        return textureHandle[0];
    }

    public static void checkGlError(String glOperation) {
        int error;
        while ((error = GLES20.glGetError()) != 0) {
        }
    }
}

