/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.util;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import org.andresoviedo.app.model3D.util.SystemUiHiderBase;
import org.andresoviedo.app.model3D.util.SystemUiHiderHoneycomb;

public abstract class SystemUiHider {
    public static final int FLAG_LAYOUT_IN_SCREEN_OLDER_DEVICES = 1;
    public static final int FLAG_FULLSCREEN = 2;
    public static final int FLAG_HIDE_NAVIGATION = 6;
    protected Activity mActivity;
    protected View mAnchorView;
    protected int mFlags;
    protected OnVisibilityChangeListener mOnVisibilityChangeListener = sDummyListener;
    private static OnVisibilityChangeListener sDummyListener = new OnVisibilityChangeListener(){

        @Override
        public void onVisibilityChange(boolean visible) {
        }
    };

    public static SystemUiHider getInstance(Activity activity, View anchorView, int flags) {
        if (Build.VERSION.SDK_INT >= 11) {
            return new SystemUiHiderHoneycomb(activity, anchorView, flags);
        }
        return new SystemUiHiderBase(activity, anchorView, flags);
    }

    protected SystemUiHider(Activity activity, View anchorView, int flags) {
        this.mActivity = activity;
        this.mAnchorView = anchorView;
        this.mFlags = flags;
    }

    public abstract void setup();

    public abstract boolean isVisible();

    public abstract void hide();

    public abstract void show();

    public void toggle() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    public void setOnVisibilityChangeListener(OnVisibilityChangeListener listener) {
        if (listener == null) {
            listener = sDummyListener;
        }
        this.mOnVisibilityChangeListener = listener;
    }

    public static interface OnVisibilityChangeListener {
        public void onVisibilityChange(boolean var1);
    }
}

