/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.view;

import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.andresoviedo.app.model3D.entities.Camera;
import org.andresoviedo.app.model3D.model.Object3D;
import org.andresoviedo.app.model3D.model.Object3DBuilder;
import org.andresoviedo.app.model3D.model.Object3DData;
import org.andresoviedo.app.model3D.model.Object3DImpl;
import org.andresoviedo.app.model3D.services.SceneLoader;
import org.andresoviedo.app.model3D.util.GLUtil;
import org.andresoviedo.app.model3D.view.ModelSurfaceView;

public class ModelRenderer
implements GLSurfaceView.Renderer {
    private static final String TAG = ModelRenderer.class.getName();
    private ModelSurfaceView main;
    private int width;
    private int height;
    private Camera camera;
    private final float near = 1.0f;
    private final float far = 100.0f;
    private Object3DBuilder drawer;
    private Map<Object3DData, Object3DData> wireframes = new HashMap<Object3DData, Object3DData>();
    private Map<byte[], Integer> textures = new HashMap<byte[], Integer>();
    private Map<Object3DData, Object3DData> boundingBoxes = new HashMap<Object3DData, Object3DData>();
    private Map<Object3DData, Object3DData> normals = new HashMap<Object3DData, Object3DData>();
    private final float[] modelProjectionMatrix = new float[16];
    private final float[] modelViewMatrix = new float[16];
    private final float[] mvpMatrix = new float[16];
    private final float[] lightPosInEyeSpace = new float[4];

    public ModelRenderer(ModelSurfaceView modelSurfaceView) {
        this.main = modelSurfaceView;
    }

    public float getNear() {
        return 1.0f;
    }

    public float getFar() {
        return 100.0f;
    }

    public void onSurfaceCreated(GL10 unused, EGLConfig config) {
        float[] backgroundColor = this.main.getModelActivity().getBackgroundColor();
        GLES20.glClearColor((float)backgroundColor[0], (float)backgroundColor[1], (float)backgroundColor[2], (float)backgroundColor[3]);
        GLES20.glEnable((int)2929);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)1, (int)771);
        this.camera = new Camera();
        this.drawer = new Object3DBuilder();
    }

    public void onSurfaceChanged(GL10 unused, int width, int height) {
        this.width = width;
        this.height = height;
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        Matrix.setLookAtM((float[])this.modelViewMatrix, (int)0, (float)this.camera.xPos, (float)this.camera.yPos, (float)this.camera.zPos, (float)this.camera.xView, (float)this.camera.yView, (float)this.camera.zView, (float)this.camera.xUp, (float)this.camera.yUp, (float)this.camera.zUp);
        float ratio = (float)width / (float)height;
        Log.d((String)TAG, (String)("projection: [" + -ratio + "," + ratio + ",-1,1]-near/far[1,10]"));
        Matrix.frustumM((float[])this.modelProjectionMatrix, (int)0, (float)(-ratio), (float)ratio, (float)-1.0f, (float)1.0f, (float)this.getNear(), (float)this.getFar());
        Matrix.multiplyMM((float[])this.mvpMatrix, (int)0, (float[])this.modelProjectionMatrix, (int)0, (float[])this.modelViewMatrix, (int)0);
    }

    public void onDrawFrame(GL10 unused) {
        SceneLoader scene;
        GLES20.glClear((int)16640);
        this.camera.animate();
        if (this.camera.hasChanged()) {
            Matrix.setLookAtM((float[])this.modelViewMatrix, (int)0, (float)this.camera.xPos, (float)this.camera.yPos, (float)this.camera.zPos, (float)this.camera.xView, (float)this.camera.yView, (float)this.camera.zView, (float)this.camera.xUp, (float)this.camera.yUp, (float)this.camera.zUp);
            Matrix.multiplyMM((float[])this.mvpMatrix, (int)0, (float[])this.modelProjectionMatrix, (int)0, (float[])this.modelViewMatrix, (int)0);
            this.camera.setChanged(false);
        }
        if ((scene = this.main.getModelActivity().getScene()) == null) {
            return;
        }
        this.camera.setScene(scene);
        scene.onDrawFrame();
        if (scene.isDrawLighting()) {
            Object3DImpl lightBulbDrawer = (Object3DImpl)this.drawer.getPointDrawer();
            float[] lightModelViewMatrix = lightBulbDrawer.getMvMatrix(lightBulbDrawer.getMMatrix(scene.getLightBulb()), this.modelViewMatrix);
            Matrix.multiplyMV((float[])this.lightPosInEyeSpace, (int)0, (float[])lightModelViewMatrix, (int)0, (float[])scene.getLightPosition(), (int)0);
            lightBulbDrawer.draw(scene.getLightBulb(), this.modelProjectionMatrix, this.modelViewMatrix, -1, this.lightPosInEyeSpace);
        }
        List<Object3DData> objects = scene.getObjects();
        for (int i = 0; i < objects.size(); ++i) {
            Object3DData objData = null;
            try {
                objData = objects.get(i);
                boolean changed = objData.isChanged();
                Object3D drawerObject = this.drawer.getDrawer(objData, scene.isDrawTextures(), scene.isDrawLighting());
                Integer textureId = this.textures.get(objData.getTextureData());
                if (textureId == null && objData.getTextureData() != null) {
                    ByteArrayInputStream textureIs = new ByteArrayInputStream(objData.getTextureData());
                    textureId = GLUtil.loadTexture(textureIs);
                    textureIs.close();
                    this.textures.put(objData.getTextureData(), textureId);
                }
                if (scene.isDrawWireframe() && objData.getDrawMode() != 0 && objData.getDrawMode() != 1 && objData.getDrawMode() != 3 && objData.getDrawMode() != 2) {
                    try {
                        Object3DData wireframe = this.wireframes.get(objData);
                        if (wireframe == null || changed) {
                            Log.i((String)"ModelRenderer", (String)"Generating wireframe model...");
                            wireframe = Object3DBuilder.buildWireframe(objData);
                            this.wireframes.put(objData, wireframe);
                        }
                        drawerObject.draw(wireframe, this.modelProjectionMatrix, this.modelViewMatrix, wireframe.getDrawMode(), wireframe.getDrawSize(), textureId != null ? textureId : -1, this.lightPosInEyeSpace);
                    }
                    catch (Error e) {
                        Log.e((String)"ModelRenderer", (String)e.getMessage(), (Throwable)e);
                    }
                } else if (scene.isDrawPoints() || objData.getFaces() == null || !objData.getFaces().loaded()) {
                    drawerObject.draw(objData, this.modelProjectionMatrix, this.modelViewMatrix, 0, objData.getDrawSize(), textureId != null ? textureId : -1, this.lightPosInEyeSpace);
                } else {
                    drawerObject.draw(objData, this.modelProjectionMatrix, this.modelViewMatrix, textureId != null ? textureId : -1, this.lightPosInEyeSpace);
                }
                if (!scene.isDrawNormals()) continue;
                Object3DData normalData = this.normals.get(objData);
                if ((normalData == null || changed) && (normalData = Object3DBuilder.buildFaceNormals(objData)) != null) {
                    this.normals.put(objData, normalData);
                }
                if (normalData == null) continue;
                Object3D normalsDrawer = this.drawer.getFaceNormalsDrawer();
                normalsDrawer.draw(normalData, this.modelProjectionMatrix, this.modelViewMatrix, -1, null);
                continue;
            }
            catch (Exception ex) {
                Log.e((String)"ModelRenderer", (String)("There was a problem rendering the object '" + objData.getId() + "':" + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float[] getModelProjectionMatrix() {
        return this.modelProjectionMatrix;
    }

    public float[] getModelViewMatrix() {
        return this.modelViewMatrix;
    }

    public Camera getCamera() {
        return this.camera;
    }
}

