/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.view;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.view.MotionEvent;
import org.andresoviedo.app.model3D.controller.TouchController;
import org.andresoviedo.app.model3D.services.SceneLoader;
import org.andresoviedo.app.model3D.view.ModelRenderer;
import se.bonniernews.rn3d.RN3DView;

public class ModelSurfaceView
extends GLSurfaceView {
    private RN3DView parent;
    private ModelRenderer mRenderer;
    private TouchController touchHandler;
    private SceneLoader scene;
    private Handler handler;
    private String modelSrc;
    private String textureSrc;
    private float[] backgroundColor;
    private float scale;

    public ModelSurfaceView(Context context, RN3DView parent, String modelSrc, String textureSrc, float[] backgroundColor) {
        super(context);
        this.parent = parent;
        this.modelSrc = modelSrc;
        this.textureSrc = textureSrc;
        this.backgroundColor = backgroundColor;
        this.setEGLContextClientVersion(2);
        this.mRenderer = new ModelRenderer(this);
        this.setRenderer(this.mRenderer);
        this.touchHandler = new TouchController(this, this.mRenderer);
        this.handler = new Handler(context.getMainLooper());
        this.scene = new SceneLoader(this, context);
        this.scene.init(modelSrc, textureSrc);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.touchHandler.onTouchEvent(event);
    }

    public ModelSurfaceView getModelActivity() {
        return this;
    }

    public ModelRenderer getModelRenderer() {
        return this.mRenderer;
    }

    public SceneLoader getScene() {
        return this.scene;
    }

    public ModelSurfaceView getgLView() {
        return this;
    }

    public float[] getBackgroundColor() {
        return this.backgroundColor;
    }

    private void tryInitScene() {
        if (this.modelSrc != null && this.textureSrc != null && this.backgroundColor != null) {
            this.scene.init(this.modelSrc, this.textureSrc);
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.scene.setScale(scale);
    }

    public void setPlay(boolean play) {
        if (this.scene.getAnimator() != null) {
            this.scene.getAnimator().setPlay(play);
            if (play) {
                this.parent.onAnimationStart();
            } else {
                this.parent.onAnimationStop();
            }
        }
    }

    public void setProgress(float progress) {
        if (this.scene.getAnimator() != null && this.scene.getSelectedObject() != null) {
            this.scene.getAnimator().setProgress(progress, this.scene.getSelectedObject());
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void onLoadModelSuccess() {
        this.parent.onLoadModelSuccess();
    }

    public void onLoadModelError() {
        this.parent.onLoadModelError();
    }

    public void onAnimationStart() {
        this.parent.onAnimationStart();
    }

    public void onAnimationStop() {
        this.parent.onAnimationStop();
    }

    public void onAnimationUpdate(double progress) {
        this.parent.onAnimationUpdate(progress);
    }
}

