/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public final class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAssets(Context context, String sourceDirectory, File targetDir) {
        OutputStream fileOutputStream = null;
        try {
            AssetManager assets = context.getAssets();
            String[] files = assets.list(sourceDirectory);
            if (files == null || files.length == 0) {
                throw new IllegalStateException("No se han encontrado los ficheros fuente de instalaci\u00f3n");
            }
            if (!targetDir.exists()) {
                boolean ret = targetDir.mkdirs();
                Log.d((String)"copyAssets", (String)("Creaci\u00f3n del directorio '" + targetDir + "' retorno '" + ret + "'"));
            }
            for (String file : files) {
                File sdFile = new File(targetDir, file);
                if (sdFile.exists()) {
                    Log.d((String)"copyAssets", (String)("Fichero '" + sdFile + "' ya existe. Continuando..."));
                    continue;
                }
                sdFile.createNewFile();
                fileOutputStream = new BufferedOutputStream(new FileOutputStream(sdFile));
                Log.d((String)"copyAssets", (String)("Copiando fichero '" + file + "' a '" + sdFile + "'..."));
                InputStream assetStream = assets.open(sourceDirectory + File.separator + file);
                IOUtils.copy((InputStream)new BufferedInputStream(assetStream), (OutputStream)fileOutputStream);
                assetStream.close();
                fileOutputStream.close();
            }
            Log.i((String)"copyAssets", (String)("Copiado directorio de assets '" + sourceDirectory + "'"));
        }
        catch (IOException ex) {
            Log.e((String)"copyAssets", (String)("Se ha producido una exepci\u00f3n copiando el directorio de assets '" + sourceDirectory + "'"), (Throwable)ex);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ex) {
                    Log.e((String)"copyAssets", (String)("Se ha producido una exepci\ufffdn copiando ficheros desde '" + sourceDirectory + "'"), (Throwable)ex);
                }
            }
        }
    }

    public static void printTouchCapabilities(PackageManager packageManager) {
        if (packageManager.hasSystemFeature("android.hardware.touchscreen.multitouch")) {
            Log.i((String)"utils", (String)"System supports multitouch (2 fingers)");
        }
        if (packageManager.hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) {
            Log.i((String)"utils", (String)"System supports advanced multitouch (multiple fingers). Cool!");
        }
    }

    public static Intent createGetContentIntent() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent.addCategory("android.intent.category.OPENABLE");
        return intent;
    }
}

