/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.util.math;

import android.opengl.Matrix;

public class Math3DUtils {
    public static float[] calculateFaceNormal2(float[] v0, float[] v1, float[] v2) {
        float[] va = new float[]{v1[0] - v0[0], v1[1] - v0[1], v1[2] - v0[2]};
        float[] vb = new float[]{v2[0] - v0[0], v2[1] - v0[1], v2[2] - v0[2]};
        float[] n = new float[]{va[1] * vb[2] - va[2] * vb[1], va[2] * vb[0] - va[0] * vb[2], va[0] * vb[1] - va[1] * vb[0]};
        float modul = Matrix.length((float)n[0], (float)n[1], (float)n[2]);
        float[] vn = new float[]{n[0] / modul, n[1] / modul, n[2] / modul};
        return vn;
    }

    public static float[][] calculateFaceNormal(float[] v0, float[] v1, float[] v2) {
        float[] va = new float[]{v1[0] - v0[0], v1[1] - v0[1], v1[2] - v0[2]};
        float[] vb = new float[]{v2[0] - v0[0], v2[1] - v0[1], v2[2] - v0[2]};
        float[] n = new float[]{va[1] * vb[2] - va[2] * vb[1], va[2] * vb[0] - va[0] * vb[2], va[0] * vb[1] - va[1] * vb[0]};
        float modul = Matrix.length((float)n[0], (float)n[1], (float)n[2]);
        float[] vn = new float[]{n[0] / modul, n[1] / modul, n[2] / modul};
        float[] faceCenter = Math3DUtils.calculateFaceCenter(v0, v1, v2);
        float[] vn2 = new float[]{faceCenter[0] + vn[0], faceCenter[1] + vn[1], faceCenter[2] + vn[2]};
        String msg = "fNormal(" + v0[0] + "," + v0[1] + "," + v0[2] + "#" + v1[0] + "," + v1[1] + "," + v1[2] + "#" + v2[0] + "," + v2[1] + "," + v2[2] + ")#normal(" + vn[0] + "," + vn[1] + "," + vn[2] + ") center(" + faceCenter[0] + "," + faceCenter[1] + "," + faceCenter[2] + ") to(" + vn2[0] + "," + vn2[1] + "," + vn2[2] + ")";
        return new float[][]{faceCenter, vn2};
    }

    public static float[] calculateFaceCenter(float[] v0, float[] v1, float[] v2) {
        return new float[]{(v0[0] + v1[0] + v2[0]) / 3.0f, (v0[1] + v1[1] + v2[1]) / 3.0f, (v0[2] + v1[2] + v2[2]) / 3.0f};
    }

    public static float calculateDistanceOfIntersection(float[] rayPoint1, float[] rayPoint2, float[] target, float precision) {
        float raySteps = 100.0f;
        float objHalfWidth = precision / 2.0f;
        float length = Matrix.length((float)(rayPoint2[0] - rayPoint1[0]), (float)(rayPoint2[1] - rayPoint1[1]), (float)(rayPoint2[2] - rayPoint1[2]));
        float lengthDiff = length / raySteps;
        float xDif = (rayPoint2[0] - rayPoint1[0]) / raySteps;
        float yDif = (rayPoint2[1] - rayPoint1[1]) / raySteps;
        float zDif = (rayPoint2[2] - rayPoint1[2]) / raySteps;
        int i = 0;
        while ((float)i < raySteps) {
            if (rayPoint1[0] + xDif * (float)i > target[0] - objHalfWidth && rayPoint1[0] + xDif * (float)i < target[0] + objHalfWidth && rayPoint1[1] + yDif * (float)i > target[1] - objHalfWidth && rayPoint1[1] + yDif * (float)i < target[1] + objHalfWidth && rayPoint1[2] + zDif * (float)i > target[2] - objHalfWidth && rayPoint1[2] + zDif * (float)i < target[2] + objHalfWidth) {
                return (float)i * lengthDiff;
            }
            ++i;
        }
        return -1.0f;
    }

    public static float[] substract(float[] a, float[] b) {
        return new float[]{a[0] - b[0], a[1] - b[1], a[2] - b[2]};
    }

    public static float[] divide(float[] a, float[] b) {
        return new float[]{a[0] / b[0], a[1] / b[1], a[2] / b[2]};
    }

    public static float[] divide(float[] a, float b) {
        return new float[]{a[0] / b, a[1] / b, a[2] / b};
    }

    public static float[] min(float[] a, float[] b) {
        return new float[]{Math.min(a[0], b[0]), Math.min(a[1], b[1]), Math.min(a[2], b[2])};
    }

    public static float[] max(float[] a, float[] b) {
        return new float[]{Math.max(a[0], b[0]), Math.max(a[1], b[1]), Math.max(a[2], b[2])};
    }

    public static void normalize(float[] a) {
        float length = Matrix.length((float)a[0], (float)a[1], (float)a[2]);
        a[0] = a[0] / length;
        a[1] = a[1] / length;
        a[2] = a[2] / length;
    }

    public static float[] crossProduct(float[] a, float[] b) {
        float x = a[1] * b[2] - a[2] * b[1];
        float y = a[2] * b[0] - a[0] * b[2];
        float z = a[0] * b[1] - a[1] * b[0];
        return new float[]{x, y, z};
    }

    public static float dotProduct(float[] a, float[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static float[] multiply(float[] a, float t) {
        return new float[]{a[0] * t, a[1] * t, a[2] * t};
    }

    public static float[] add(float[] a, float[] b) {
        return new float[]{a[0] + b[0], a[1] + b[1], a[2] + b[2]};
    }
}

