/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.util.math;

public class Quaternion {
    private float x;
    private float y;
    private float z;
    private float w;

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        this.normalize();
    }

    public void normalize() {
        float mag = (float)Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
        this.w /= mag;
        this.x /= mag;
        this.y /= mag;
        this.z /= mag;
    }

    public float[] toRotationMatrix() {
        float[] matrix = new float[16];
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float xw = this.x * this.w;
        float yz = this.y * this.z;
        float yw = this.y * this.w;
        float zw = this.z * this.w;
        float xSquared = this.x * this.x;
        float ySquared = this.y * this.y;
        float zSquared = this.z * this.z;
        matrix[0] = 1.0f - 2.0f * (ySquared + zSquared);
        matrix[1] = 2.0f * (xy - zw);
        matrix[2] = 2.0f * (xz + yw);
        matrix[3] = 0.0f;
        matrix[4] = 2.0f * (xy + zw);
        matrix[5] = 1.0f - 2.0f * (xSquared + zSquared);
        matrix[6] = 2.0f * (yz - xw);
        matrix[7] = 0.0f;
        matrix[8] = 2.0f * (xz - yw);
        matrix[9] = 2.0f * (yz + xw);
        matrix[10] = 1.0f - 2.0f * (xSquared + ySquared);
        matrix[11] = 0.0f;
        matrix[12] = 0.0f;
        matrix[13] = 0.0f;
        matrix[14] = 0.0f;
        matrix[15] = 1.0f;
        return matrix;
    }

    public static Quaternion fromMatrix(float[] matrix) {
        float z;
        float y;
        float x;
        float w;
        float diagonal = matrix[0] + matrix[5] + matrix[10];
        if (diagonal > 0.0f) {
            float w4 = (float)(Math.sqrt(diagonal + 1.0f) * 2.0);
            w = w4 / 4.0f;
            x = (matrix[9] - matrix[6]) / w4;
            y = (matrix[2] - matrix[8]) / w4;
            z = (matrix[4] - matrix[1]) / w4;
        } else if (matrix[0] > matrix[5] && matrix[0] > matrix[10]) {
            float x4 = (float)(Math.sqrt(1.0f + matrix[0] - matrix[5] - matrix[10]) * 2.0);
            w = (matrix[9] - matrix[6]) / x4;
            x = x4 / 4.0f;
            y = (matrix[1] + matrix[4]) / x4;
            z = (matrix[2] + matrix[8]) / x4;
        } else if (matrix[5] > matrix[10]) {
            float y4 = (float)(Math.sqrt(1.0f + matrix[5] - matrix[0] - matrix[10]) * 2.0);
            w = (matrix[2] - matrix[8]) / y4;
            x = (matrix[1] + matrix[4]) / y4;
            y = y4 / 4.0f;
            z = (matrix[6] + matrix[9]) / y4;
        } else {
            float z4 = (float)(Math.sqrt(1.0f + matrix[10] - matrix[0] - matrix[5]) * 2.0);
            w = (matrix[4] - matrix[1]) / z4;
            x = (matrix[2] + matrix[8]) / z4;
            y = (matrix[6] + matrix[9]) / z4;
            z = z4 / 4.0f;
        }
        return new Quaternion(x, y, z, w);
    }

    public static Quaternion interpolate(Quaternion a, Quaternion b, float blend) {
        Quaternion result = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        float dot = a.w * b.w + a.x * b.x + a.y * b.y + a.z * b.z;
        float blendI = 1.0f - blend;
        if (dot < 0.0f) {
            result.w = blendI * a.w + blend * -b.w;
            result.x = blendI * a.x + blend * -b.x;
            result.y = blendI * a.y + blend * -b.y;
            result.z = blendI * a.z + blend * -b.z;
        } else {
            result.w = blendI * a.w + blend * b.w;
            result.x = blendI * a.x + blend * b.x;
            result.y = blendI * a.y + blend * b.y;
            result.z = blendI * a.z + blend * b.z;
        }
        result.normalize();
        return result;
    }
}

