/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.util.url.android;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class Handler
extends URLStreamHandler {
    public static ClassLoader classLoader;
    public static Resources androidResources;
    public static AssetManager assets;

    public Handler() {
        classLoader = this.getClass().getClassLoader();
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new ClasspathURLConnection(url);
    }

    private class ClasspathURLConnection
    extends URLConnection {
        private final URL url;
        private InputStream stream;

        public ClasspathURLConnection(URL url) {
            super(url);
            this.url = url;
        }

        @Override
        public void connect() throws IOException {
            if (this.stream != null) {
                return;
            }
            Log.i((String)"Handler", (String)("Connecting to '" + this.url + "'..."));
            if (this.url.getPath().startsWith("/res")) {
                String resPath = this.url.getHost() + ":" + this.url.getPath().substring(5);
                Log.i((String)"Handler", (String)("Opening resource '" + resPath + "'..."));
                int raw = androidResources.getIdentifier(resPath, null, null);
                if (raw == 0) {
                    throw new IOException("Resource /ref not found: " + resPath);
                }
                this.stream = androidResources.openRawResource(raw);
            } else if (this.url.getPath().startsWith("/assets")) {
                String resPath = this.url.getPath().substring(8);
                Log.i((String)"Handler", (String)("Opening asset '" + resPath + "'..."));
                this.stream = assets.open(resPath);
            }
            if (this.stream == null) {
                throw new IOException("stream is null");
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.stream;
        }
    }
}

