/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.util.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlNode {
    private String name;
    private Map<String, String> attributes;
    private String data;
    private Map<String, List<XmlNode>> childNodes;

    protected XmlNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public String getAttribute(String attr) {
        if (this.attributes != null) {
            return this.attributes.get(attr);
        }
        return null;
    }

    public XmlNode getChild(String childName) {
        List<XmlNode> nodes;
        if (this.childNodes != null && (nodes = this.childNodes.get(childName)) != null && !nodes.isEmpty()) {
            return nodes.get(0);
        }
        return null;
    }

    public XmlNode getChildWithAttribute(String childName, String attr, String value) {
        List<XmlNode> children = this.getChildren(childName);
        if (children == null || children.isEmpty()) {
            return null;
        }
        for (XmlNode child : children) {
            String val = child.getAttribute(attr);
            if (!value.equals(val)) continue;
            return child;
        }
        return null;
    }

    public List<XmlNode> getChildren(String name) {
        List<XmlNode> children;
        if (this.childNodes != null && (children = this.childNodes.get(name)) != null) {
            return children;
        }
        return new ArrayList<XmlNode>();
    }

    protected void addAttribute(String attr, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(attr, value);
    }

    protected void addChild(XmlNode child) {
        List<XmlNode> list;
        if (this.childNodes == null) {
            this.childNodes = new HashMap<String, List<XmlNode>>();
        }
        if ((list = this.childNodes.get(child.name)) == null) {
            list = new ArrayList<XmlNode>();
            this.childNodes.put(child.name, list);
        }
        list.add(child);
    }

    protected void setData(String data) {
        this.data = data;
    }
}

