/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.util.xml;

import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import org.andresoviedo.app.util.xml.XmlNode;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlParser {
    public static XmlNode parse(InputStream in) {
        try {
            XmlPullParser xpp = Xml.newPullParser();
            xpp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            xpp.setInput(in, null);
            int eventType = xpp.getEventType();
            if (eventType == 0) {
                XmlNode parent = new XmlNode("xml");
                XmlParser.loadNode(xpp, parent);
                XmlNode xmlNode = parent.getChild("COLLADA");
                return xmlNode;
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static void loadNode(XmlPullParser xpp, XmlNode parentNode) throws XmlPullParserException, IOException {
        int eventType = xpp.next();
        while (eventType != 1) {
            if (eventType == 2) {
                XmlNode childNode = new XmlNode(xpp.getName());
                for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                    childNode.addAttribute(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                }
                parentNode.addChild(childNode);
                XmlParser.loadNode(xpp, childNode);
            } else {
                if (eventType == 3) {
                    return;
                }
                if (eventType == 4) {
                    parentNode.setData(xpp.getText());
                }
            }
            eventType = xpp.next();
        }
    }
}

