/*
 * Decompiled with CFR 0.152.
 */
package se.bonniernews.rn3d;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import org.andresoviedo.app.model3D.view.ModelSurfaceView;

public class RN3DView
extends RelativeLayout {
    public ModelSurfaceView modelView;
    private Context context;
    private String modelSrc;
    private String textureSrc;
    private float[] backgroundColor;
    private float scale = 1.0f;
    private boolean autoPlay = true;
    private float progress = 0.0f;

    public RN3DView(Context context) {
        super(context);
        this.context = context;
    }

    private void tryInitScene() {
        if (this.context != null && this.modelSrc != null && this.textureSrc != null && this.backgroundColor != null) {
            this.modelView = new ModelSurfaceView(this.context, this, this.modelSrc, this.textureSrc, this.backgroundColor);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(13);
            this.modelView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.modelView.setScale(this.scale);
            this.modelView.setPlay(this.autoPlay);
            this.modelView.setProgress(this.progress);
            this.addView((View)this.modelView);
        }
    }

    public void setModelSrc(String modelSrc) {
        this.modelSrc = modelSrc;
        this.tryInitScene();
    }

    public void setTextureSrc(String textureSrc) {
        this.textureSrc = textureSrc;
        this.tryInitScene();
    }

    public void setBackgroundColor(Integer color) {
        if (color == null) {
            return;
        }
        float red = (float)Color.red((int)color) / 255.0f;
        float green = (float)Color.green((int)color) / 255.0f;
        float blue = (float)Color.blue((int)color) / 255.0f;
        float alpha = (float)Color.alpha((int)color) / 255.0f;
        this.backgroundColor = new float[]{red, green, blue, alpha};
        this.tryInitScene();
    }

    public void setScale(float scale) {
        this.scale = scale;
        if (this.modelView != null) {
            this.modelView.setScale(scale);
        }
    }

    public void setPlay(boolean play) {
        this.autoPlay = play;
        if (this.modelView != null) {
            this.modelView.setPlay(play);
        }
    }

    public void setProgress(float progress) {
        this.progress = progress;
        if (this.modelView != null) {
            this.modelView.setProgress(progress);
        }
    }

    public void onLoadModelSuccess() {
        WritableMap event = Arguments.createMap();
        ReactContext reactContext = (ReactContext)this.getContext();
        ((RCTEventEmitter)reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), "onLoadModelSuccess", event);
    }

    public void onLoadModelError() {
        WritableMap event = Arguments.createMap();
        ReactContext reactContext = (ReactContext)this.getContext();
        ((RCTEventEmitter)reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), "onLoadModelError", event);
    }

    public void onAnimationStart() {
        WritableMap event = Arguments.createMap();
        ReactContext reactContext = (ReactContext)this.getContext();
        ((RCTEventEmitter)reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), "onAnimationStart", event);
    }

    public void onAnimationStop() {
        WritableMap event = Arguments.createMap();
        ReactContext reactContext = (ReactContext)this.getContext();
        ((RCTEventEmitter)reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), "onAnimationStop", event);
    }

    public void onAnimationUpdate(double progress) {
        WritableMap event = Arguments.createMap();
        event.putDouble("progress", progress);
        ReactContext reactContext = (ReactContext)this.getContext();
        ((RCTEventEmitter)reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), "onAnimationUpdate", event);
    }
}

