/*
 * Decompiled with CFR 0.152.
 */
package se.bonniernews.rn3d;

import android.content.Context;
import android.support.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import java.util.Map;
import se.bonniernews.rn3d.RN3DView;

@ReactModule(name="RCT3DScnModelView")
class RN3DViewManager
extends ViewGroupManager<RN3DView> {
    public static final String REACT_CLASS = "RCT3DScnModelView";
    private RN3DView view;
    public static final int COMMAND_START_ANIMATION = 1;
    public static final int COMMAND_STOP_ANIMATION = 2;
    public static final int COMMAND_SET_PROGRESS = 3;

    RN3DViewManager() {
    }

    public String getName() {
        return REACT_CLASS;
    }

    protected RN3DView createViewInstance(ThemedReactContext themedReactContext) {
        this.view = new RN3DView((Context)themedReactContext);
        return this.view;
    }

    @ReactProp(name="modelSrc")
    public void setModelSrc(RN3DView view, String modelSrc) {
        view.setModelSrc(modelSrc);
    }

    @ReactProp(name="textureSrc")
    public void setTextureSrc(RN3DView view, String textureSrc) {
        view.setTextureSrc(textureSrc);
    }

    @ReactProp(name="backgroundColor", customType="Color")
    public void setBackgroundColor(RN3DView view, Integer color) {
        view.setBackgroundColor(color);
    }

    @ReactProp(name="scale")
    public void setScale(RN3DView view, float scale) {
        view.setScale(scale);
    }

    @ReactProp(name="autoPlayAnimations")
    public void setAutoPlayAnimations(RN3DView view, boolean autoPlay) {
        view.setPlay(autoPlay);
    }

    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"startAnimation", (Object)1, (Object)"stopAnimation", (Object)2, (Object)"setProgress", (Object)3);
    }

    public void receiveCommand(RN3DView view, int commandType, @Nullable ReadableArray args) {
        Assertions.assertNotNull((Object)((Object)view));
        Assertions.assertNotNull((Object)args);
        switch (commandType) {
            case 1: {
                view.setPlay(true);
                return;
            }
            case 2: {
                view.setPlay(false);
                return;
            }
            case 3: {
                view.setProgress((float)args.getDouble(0));
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported command %d received by %s.", commandType, ((Object)((Object)this)).getClass().getSimpleName()));
    }

    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        MapBuilder.Builder builder = MapBuilder.builder();
        return builder.put((Object)"onLoadModelSuccess", (Object)MapBuilder.of((Object)"registrationName", (Object)"onLoadModelSuccess")).put((Object)"onLoadModelError", (Object)MapBuilder.of((Object)"registrationName", (Object)"onLoadModelError")).put((Object)"onAnimationStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onAnimationStart")).put((Object)"onAnimationStop", (Object)MapBuilder.of((Object)"registrationName", (Object)"onAnimationStop")).put((Object)"onAnimationUpdate", (Object)MapBuilder.of((Object)"registrationName", (Object)"onAnimationUpdate")).build();
    }
}

