/*
 * Decompiled with CFR 0.152.
 */
package com.auth.react;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.Base64;
import androidx.browser.customtabs.CustomTabsIntent;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class AzureAuthModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    private static final int CANCEL_EVENT_DELAY = 100;
    private final ReactApplicationContext reactContext;
    private Callback callback;
    private boolean closeOnLoad;

    public AzureAuthModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
        this.reactContext.addLifecycleEventListener((LifecycleEventListener)this);
    }

    public String getName() {
        return "AzureAuth";
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("bundleIdentifier", this.reactContext.getApplicationInfo().packageName);
        return constants;
    }

    @ReactMethod
    public void showUrl(String url, boolean closeOnLoad, Map<String, String> headers, Callback callback) {
        Activity activity = this.getCurrentActivity();
        this.callback = callback;
        this.closeOnLoad = closeOnLoad;
        if (activity != null) {
            try {
                CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
                CustomTabsIntent customTabsIntent = builder.build();
                if (headers != null) {
                    Bundle reqHeaders = new Bundle();
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        reqHeaders.putString(entry.getKey(), entry.getValue());
                    }
                    customTabsIntent.intent.putExtra("com.android.browser.headers", reqHeaders);
                }
                customTabsIntent.launchUrl((Context)activity, Uri.parse((String)url));
            }
            catch (ActivityNotFoundException e) {
                this.startNewBrowserActivity(url);
            }
        } else {
            this.startNewBrowserActivity(url);
        }
    }

    private void startNewBrowserActivity(String url) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.setData(Uri.parse((String)url));
        this.getReactApplicationContext().startActivity(intent);
    }

    @ReactMethod
    public void oauthParameters(Callback callback) {
        WritableMap parameters = Arguments.createMap();
        parameters.putString("state", this.generateRandomValue());
        parameters.putString("nonce", this.generateRandomValue());
        parameters.putString("verifier", this.generateRandomValue());
        callback.invoke(new Object[]{parameters});
    }

    @ReactMethod
    public void hide() {
        this.callback = null;
    }

    private String getBase64String(byte[] source) {
        return Base64.encodeToString((byte[])source, (int)11);
    }

    String generateRandomValue() {
        SecureRandom sr = new SecureRandom();
        byte[] code = new byte[32];
        sr.nextBytes(code);
        return this.getBase64String(code);
    }

    public void onHostResume() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                Callback cb = AzureAuthModule.this.callback;
                if (cb != null) {
                    if (AzureAuthModule.this.closeOnLoad) {
                        cb.invoke(new Object[0]);
                    } else {
                        WritableMap error = Arguments.createMap();
                        error.putString("error", "aa.session.user_cancelled");
                        error.putString("error_description", "User cancelled the Auth");
                        cb.invoke(new Object[]{error});
                    }
                    AzureAuthModule.this.callback = null;
                }
            }
        }, 100L);
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
    }
}

