/*
 * Decompiled with CFR 0.152.
 */
package io.adbrix;

import android.app.Activity;
import android.content.Context;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.RCTNativeAppEventEmitter;
import com.igaworks.v2.core.AbxCommerce;
import com.igaworks.v2.core.AbxCommon;
import com.igaworks.v2.core.AbxGame;
import com.igaworks.v2.core.AdBrixRm;
import com.igaworks.v2.core.application.AbxActivityHelper;
import io.adbrix.AdbrixUtils;
import java.util.List;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ReactModule(name="AdbrixRm")
public class AdbrixModule
extends ReactContextBaseJavaModule
implements AdBrixRm.DeferredDeeplinkListener,
AdBrixRm.DeeplinkListener {
    private final ReactApplicationContext mContext;
    public static final String NAME = "AdbrixRm";

    public AdbrixModule(@Nonnull ReactApplicationContext reactContext) {
        super(reactContext);
        this.mContext = reactContext;
    }

    @Nonnull
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void initRNPlugin() {
        AdBrixRm.setDeferredDeeplinkListener((AdBrixRm.DeferredDeeplinkListener)this);
    }

    @ReactMethod
    public void gdprForgetMe() {
        AdBrixRm.gdprForgetMe((Context)this.mContext);
    }

    @ReactMethod
    public void setDeviceId(String deviceId) {
    }

    @ReactMethod
    public void setAge(int age) {
        AdBrixRm.setAge((int)age);
    }

    @ReactMethod
    public void setGender(int gender) {
        switch (gender) {
            case 0: {
                AdBrixRm.setGender((AdBrixRm.AbxGender)AdBrixRm.AbxGender.UNKNOWN);
                break;
            }
            case 1: {
                AdBrixRm.setGender((AdBrixRm.AbxGender)AdBrixRm.AbxGender.MALE);
                break;
            }
            case 2: {
                AdBrixRm.setGender((AdBrixRm.AbxGender)AdBrixRm.AbxGender.FEMALE);
                break;
            }
            default: {
                AdBrixRm.setGender((AdBrixRm.AbxGender)AdBrixRm.AbxGender.UNKNOWN);
            }
        }
    }

    @ReactMethod
    public void setEventUploadCountInterval(int interval) {
        switch (interval) {
            case 10: {
                AdBrixRm.setEventUploadCountInterval((AdBrixRm.AdBrixEventUploadCountInterval)AdBrixRm.AdBrixEventUploadCountInterval.MIN);
                break;
            }
            case 30: {
                AdBrixRm.setEventUploadCountInterval((AdBrixRm.AdBrixEventUploadCountInterval)AdBrixRm.AdBrixEventUploadCountInterval.NORMAL);
                break;
            }
            case 60: {
                AdBrixRm.setEventUploadCountInterval((AdBrixRm.AdBrixEventUploadCountInterval)AdBrixRm.AdBrixEventUploadCountInterval.MAX);
                break;
            }
            default: {
                AdBrixRm.setEventUploadCountInterval((AdBrixRm.AdBrixEventUploadCountInterval)AdBrixRm.AdBrixEventUploadCountInterval.NORMAL);
            }
        }
    }

    @ReactMethod
    public void setEventUploadTimeInterval(int interval) {
        switch (interval) {
            case 30: {
                AdBrixRm.setEventUploadTimeInterval((AdBrixRm.AdBrixEventUploadTimeInterval)AdBrixRm.AdBrixEventUploadTimeInterval.MIN);
                break;
            }
            case 60: {
                AdBrixRm.setEventUploadTimeInterval((AdBrixRm.AdBrixEventUploadTimeInterval)AdBrixRm.AdBrixEventUploadTimeInterval.NORMAL);
                break;
            }
            case 120: {
                AdBrixRm.setEventUploadTimeInterval((AdBrixRm.AdBrixEventUploadTimeInterval)AdBrixRm.AdBrixEventUploadTimeInterval.MAX);
                break;
            }
            default: {
                AdBrixRm.setEventUploadTimeInterval((AdBrixRm.AdBrixEventUploadTimeInterval)AdBrixRm.AdBrixEventUploadTimeInterval.NORMAL);
            }
        }
    }

    @ReactMethod
    public void setEnableLocationListening(boolean option) {
        AdBrixRm.setEnableLocationListening((Boolean)option);
    }

    @ReactMethod
    public void setLocation(double lat, double lon) {
        AdBrixRm.setLocation((double)lat, (double)lon);
    }

    @ReactMethod
    public void setUserProperties(String jsonString) {
        JSONObject userPropertiesJSON = new JSONObject();
        try {
            if (!AdbrixUtils.isNullString(jsonString)) {
                userPropertiesJSON = new JSONObject(jsonString);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        AdBrixRm.UserProperties userProperties = AdbrixUtils.makeUserProperties(userPropertiesJSON);
        AdBrixRm.saveUserProperties((AdBrixRm.UserProperties)userProperties);
    }

    @ReactMethod
    public void event(String eventName, String paramJson) {
        if (AdbrixUtils.isNullString(paramJson)) {
            AdBrixRm.event((String)eventName);
        } else {
            try {
                JSONObject attrmodel = new JSONObject(paramJson);
                AdBrixRm.event((String)eventName, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(attrmodel));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @ReactMethod
    public void login(String userId) {
        AdBrixRm.login((String)userId);
    }

    @ReactMethod
    public void logout() {
        AdBrixRm.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void commerceViewHome(String extraAttrJsonString) {
        if (extraAttrJsonString == null) {
            AdBrixRm.Commerce.viewHome();
            return;
        }
        JSONObject commerceExtraAttributes = null;
        try {
            if (extraAttrJsonString != null && extraAttrJsonString.length() > 0) {
                commerceExtraAttributes = new JSONObject(extraAttrJsonString);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            AbxCommerce.viewHome((AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(commerceExtraAttributes));
        }
    }

    @ReactMethod
    public void commerceCategoryView(String categoryString, String productListString, String extraString) {
        try {
            JSONArray categoryArray = new JSONArray();
            JSONArray items = new JSONArray();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(categoryString)) {
                categoryArray = new JSONArray(categoryString);
            }
            if (!AdbrixUtils.isNullString(productListString)) {
                items = new JSONArray(productListString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.CommerceCategoriesModel categories = new AdBrixRm.CommerceCategoriesModel();
            for (int i = 0; i < categoryArray.length(); ++i) {
                categories.setCategory(categoryArray.getString(i));
            }
            List<AdBrixRm.CommerceProductModel> products = AdbrixUtils.makeProductList(items);
            AbxCommerce.categoryView((AdBrixRm.CommerceCategoriesModel)categories, products, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commerceProductView(String productString, String extraString) {
        try {
            JSONObject product = new JSONObject();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                product = new JSONObject(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.CommerceProductModel productModel = AdbrixUtils.makeProductModel(product);
            AbxCommerce.productView((AdBrixRm.CommerceProductModel)productModel, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commerceAddToCart(String productString, String extraString) {
        try {
            JSONArray items = new JSONArray();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                items = new JSONArray(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            List<AdBrixRm.CommerceProductModel> products = AdbrixUtils.makeProductList(items);
            AbxCommerce.addToCart(products, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commerceAddToWishList(String productString, String extraString) {
        try {
            JSONObject product = new JSONObject();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                product = new JSONObject(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.CommerceProductModel productModel = AdbrixUtils.makeProductModel(product);
            AbxCommerce.addToWishList((AdBrixRm.CommerceProductModel)productModel, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commerceReviewOrder(String orderId, String productString, double discount, double deliveryCharge, String extraString) {
        try {
            JSONArray items = new JSONArray();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                items = new JSONArray(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            List<AdBrixRm.CommerceProductModel> products = AdbrixUtils.makeProductList(items);
            AbxCommerce.reviewOrder((String)orderId, products, (double)discount, (double)deliveryCharge, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commerceRefund(String orderId, String productString, double penaltyCharge, String extraString) {
        try {
            JSONArray items = new JSONArray();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                items = new JSONArray(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            List<AdBrixRm.CommerceProductModel> products = AdbrixUtils.makeProductList(items);
            AbxCommerce.refund((String)orderId, products, (double)penaltyCharge, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commerceSearch(String keyword, String productString, String extraString) {
        try {
            JSONArray items = new JSONArray();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                items = new JSONArray(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            List<AdBrixRm.CommerceProductModel> products = AdbrixUtils.makeProductList(items);
            AbxCommerce.search((String)keyword, products, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commerceShare(String sharingChannel, String productString, String extraString) {
        try {
            JSONObject product = new JSONObject();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                product = new JSONObject(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.CommerceProductModel productModel = AdbrixUtils.makeProductModel(product);
            AbxCommerce.share((AdBrixRm.CommerceSharingChannel)AdBrixRm.CommerceSharingChannel.getChannelByChannelCode((String)sharingChannel), (AdBrixRm.CommerceProductModel)productModel, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commerceListView(String productString, String extraString) {
        try {
            JSONArray items = new JSONArray();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                items = new JSONArray(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            List<AdBrixRm.CommerceProductModel> products = AdbrixUtils.makeProductList(items);
            AbxCommerce.listView(products, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commerceCartView(String productString, String extraString) {
        try {
            JSONArray items = new JSONArray();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                items = new JSONArray(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            List<AdBrixRm.CommerceProductModel> products = AdbrixUtils.makeProductList(items);
            AbxCommerce.cartView(products, (AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commercePaymentInfoAdded(String extraString) {
        try {
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AbxCommerce.paymentInfoAdded((AdBrixRm.AttrModel)AdbrixUtils.makeEventProperties(extraAttrs));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void gameTutorialCompleted(boolean is_skip, String extraString) {
        try {
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.GameProperties.TutorialComplete gameProperties = new AdBrixRm.GameProperties.TutorialComplete().setIsSkip(is_skip);
            AbxGame.tutorialComplete((AdBrixRm.GameProperties.TutorialComplete)gameProperties.setAttrModel(AdbrixUtils.makeEventProperties(extraAttrs)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void gameLevelAchieved(int level, String extraString) {
        try {
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.GameProperties.LevelAchieved gameProperties = new AdBrixRm.GameProperties.LevelAchieved().setLevel(level);
            AbxGame.levelAchieved((AdBrixRm.GameProperties.LevelAchieved)gameProperties.setAttrModel(AdbrixUtils.makeEventProperties(extraAttrs)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void gameCharacterCreated(String extraString) {
        try {
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.GameProperties.CharacterCreated gameProperties = new AdBrixRm.GameProperties.CharacterCreated();
            AbxGame.characterCreated((AdBrixRm.GameProperties.CharacterCreated)gameProperties.setAttrModel(AdbrixUtils.makeEventProperties(extraAttrs)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void gameStageCleared(String stageName, String extraString) {
        try {
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.GameProperties.StageCleared gameProperties = new AdBrixRm.GameProperties.StageCleared().setStageName(stageName);
            AbxGame.stageCleared((AdBrixRm.GameProperties.StageCleared)gameProperties.setAttrModel(AdbrixUtils.makeEventProperties(extraAttrs)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commonPurchase(String orderID, String productString, double discount, double deliveryCharge, String paymentMethod, String extraString) {
        try {
            JSONArray items = new JSONArray();
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(productString)) {
                items = new JSONArray(productString);
            }
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            List<AdBrixRm.CommerceProductModel> products = AdbrixUtils.makeProductList(items);
            AdBrixRm.CommonProperties.Purchase purchaseEventProperties = new AdBrixRm.CommonProperties.Purchase().setAttrModel(AdbrixUtils.makeEventProperties(extraAttrs));
            AbxCommon.purchase((String)orderID, products, (double)discount, (double)deliveryCharge, (AdBrixRm.CommercePaymentMethod)AdBrixRm.CommercePaymentMethod.getMethodByMethodCode((String)paymentMethod), (AdBrixRm.CommonProperties.Purchase)purchaseEventProperties);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commonSignUp(String channelName, String extraString) {
        try {
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.CommonProperties.SignUp properties = new AdBrixRm.CommonProperties.SignUp().setAttrModel(AdbrixUtils.makeEventProperties(extraAttrs));
            AbxCommon.signUp((AdBrixRm.CommonSignUpChannel)AdBrixRm.CommonSignUpChannel.getChannelByChannelCode((String)channelName), (AdBrixRm.CommonProperties.SignUp)properties);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commonUseCredit(String extraString) {
        try {
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.CommonProperties.UseCredit properties = new AdBrixRm.CommonProperties.UseCredit().setAttrModel(AdbrixUtils.makeEventProperties(extraAttrs));
            AbxCommon.useCredit((AdBrixRm.CommonProperties.UseCredit)properties);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commonAppUpdate(String prev_ver, String curr_ver, String extraString) {
        try {
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.CommonProperties.AppUpdate properties = new AdBrixRm.CommonProperties.AppUpdate().setPrevVersion(prev_ver).setCurrVersion(curr_ver).setAttrModel(AdbrixUtils.makeEventProperties(extraAttrs));
            AbxCommon.appUpdate((AdBrixRm.CommonProperties.AppUpdate)properties);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void commonInvite(String channelName, String extraString) {
        try {
            JSONObject extraAttrs = new JSONObject();
            if (!AdbrixUtils.isNullString(extraString)) {
                extraAttrs = new JSONObject(extraString);
            }
            AdBrixRm.CommonProperties.Invite properties = new AdBrixRm.CommonProperties.Invite().setAttrModel(AdbrixUtils.makeEventProperties(extraAttrs));
            AbxCommon.invite((AdBrixRm.CommonInviteChannel)AdBrixRm.CommonInviteChannel.getChannelByChannelCode((String)channelName), (AdBrixRm.CommonProperties.Invite)properties);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void setPushEnable(boolean toEnable) {
        AdBrixRm.setPushEnable((boolean)toEnable);
    }

    @ReactMethod
    public void setRegistrationId(String token) {
        AdBrixRm.setRegistrationId((String)token);
    }

    @ReactMethod
    public void setAppScanEnable(boolean enable) {
        AdBrixRm.setAppScanEnable((boolean)enable);
    }

    public void onReceiveDeferredDeeplink(String deeplink) {
        ((RCTNativeAppEventEmitter)this.mContext.getJSModule(RCTNativeAppEventEmitter.class)).emit("AdbrixDeferredDeeplinkListener", (Object)deeplink);
    }

    @ReactMethod
    public void startAdbrixSDK(String appKey, String secretKey) {
        AbxActivityHelper.initializeSdk((Context)this.mContext, (String)appKey, (String)secretKey);
        AdBrixRm.setDeferredDeeplinkListener((AdBrixRm.DeferredDeeplinkListener)this);
        AdBrixRm.setDeeplinkListener((AdBrixRm.DeeplinkListener)this);
        this.registerLifeCycle();
    }

    public void registerLifeCycle() {
        this.mContext.addLifecycleEventListener(new LifecycleEventListener(){

            public void onHostResume() {
                AdBrixRm.onResume((Activity)AdbrixModule.this.mContext.getCurrentActivity());
                AdBrixRm.deeplinkEvent((Activity)AdbrixModule.this.mContext.getCurrentActivity());
            }

            public void onHostPause() {
                AdBrixRm.onPause();
            }

            public void onHostDestroy() {
            }
        });
    }

    public void onReceiveDeeplink(String deeplink) {
        ((RCTNativeAppEventEmitter)this.mContext.getJSModule(RCTNativeAppEventEmitter.class)).emit("AdbrixDeeplinkListener", (Object)deeplink);
    }
}

