/*
 * Decompiled with CFR 0.152.
 */
package io.adbrix;

import com.igaworks.v2.core.AdBrixRm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdbrixUtils {
    public static long castStringToLong(String beforeCasting) {
        return Long.valueOf(beforeCasting);
    }

    public static boolean isNullString(String s) {
        try {
            return s == null || s.equals("null");
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static List<AdBrixRm.CommerceProductModel> makeProductList(JSONArray items) {
        try {
            ArrayList<AdBrixRm.CommerceProductModel> products = new ArrayList<AdBrixRm.CommerceProductModel>();
            for (int i = 0; i < items.length(); ++i) {
                JSONObject product = items.getJSONObject(i);
                AdBrixRm.CommerceProductModel productModel = AdbrixUtils.makeProductModel(product);
                products.add(productModel);
            }
            return products;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<AdBrixRm.CommerceProductModel>();
        }
    }

    public static AdBrixRm.CommerceProductModel makeProductModel(JSONObject product) {
        try {
            AdBrixRm.CommerceProductModel productModel = new AdBrixRm.CommerceProductModel();
            Iterator it = product.keys();
            while (it.hasNext()) {
                String element;
                switch (element = (String)it.next()) {
                    case "productId": {
                        productModel.setProductID(product.getString("productId"));
                        break;
                    }
                    case "productName": {
                        productModel.setProductName(product.getString("productName"));
                        break;
                    }
                    case "price": {
                        productModel.setPrice(product.getDouble("price"));
                        break;
                    }
                    case "discount": {
                        productModel.setDiscount(product.getDouble("discount"));
                        break;
                    }
                    case "currency": {
                        productModel.setCurrency(AdBrixRm.Currency.getCurrencyByCurrencyCode((String)product.getString("currency")));
                        break;
                    }
                    case "category": {
                        AdBrixRm.CommerceCategoriesModel extraCategory = new AdBrixRm.CommerceCategoriesModel();
                        for (int j = 0; j < product.getJSONArray("category").length(); ++j) {
                            extraCategory.setCategory(product.getJSONArray("category").getString(j));
                        }
                        productModel.setCategory(extraCategory);
                        break;
                    }
                    case "quantity": {
                        productModel.setQuantity(product.getInt("quantity"));
                    }
                }
            }
            return productModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AdBrixRm.CommerceProductModel();
        }
    }

    public static AdBrixRm.UserProperties makeUserProperties(JSONObject userPropertiesJSON) {
        AdBrixRm.UserProperties userProperties = new AdBrixRm.UserProperties();
        Iterator it = userPropertiesJSON.keys();
        while (it.hasNext()) {
            try {
                String key = (String)it.next();
                Object value = userPropertiesJSON.get(key);
                if (value instanceof Integer) {
                    userProperties.setAttrs(key, (Object)((Integer)value));
                    continue;
                }
                if (value instanceof Long) {
                    userProperties.setAttrs(key, (Object)((Long)value));
                    continue;
                }
                if (value instanceof Boolean) {
                    userProperties.setAttrs(key, (Object)((Boolean)value));
                    continue;
                }
                if (value instanceof Double) {
                    userProperties.setAttrs(key, (Object)((Double)value));
                    continue;
                }
                if (value instanceof Float) {
                    userProperties.setAttrs(key, (Object)Float.valueOf(((Float)value).floatValue()));
                    continue;
                }
                userProperties.setAttrs(key, (Object)String.valueOf(value));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return userProperties;
    }

    public static AdBrixRm.AttrModel makeEventProperties(JSONObject eventProperties) {
        AdBrixRm.AttrModel eventProps = new AdBrixRm.AttrModel();
        Iterator it = eventProperties.keys();
        while (it.hasNext()) {
            try {
                String key = (String)it.next();
                Object value = eventProperties.get(key);
                if (value instanceof Integer) {
                    eventProps.setAttrs(key, (Object)((Integer)value));
                    continue;
                }
                if (value instanceof Long) {
                    eventProps.setAttrs(key, (Object)((Long)value));
                    continue;
                }
                if (value instanceof Boolean) {
                    eventProps.setAttrs(key, (Object)((Boolean)value));
                    continue;
                }
                if (value instanceof Double) {
                    eventProps.setAttrs(key, (Object)((Double)value));
                    continue;
                }
                if (value instanceof Float) {
                    eventProps.setAttrs(key, (Object)Float.valueOf(((Float)value).floatValue()));
                    continue;
                }
                eventProps.setAttrs(key, (Object)String.valueOf(value));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return eventProps;
    }
}

