/*
 * Decompiled with CFR 0.152.
 */
package com.ammarahmed.rnadmob.nativeads;

import com.ammarahmed.rnadmob.nativeads.RNAdMobUnifiedAdContainer;
import com.ammarahmed.rnadmob.nativeads.RNAdMobUnifiedAdQueueWrapper;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.google.android.gms.ads.AdListener;
import java.util.HashMap;
import java.util.Map;

public class CacheManager {
    public static final String EVENT_AD_PRELOAD_LOADED = "onAdPreloadLoaded";
    public static final String EVENT_AD_PRELOAD_ERROR = "onAdPreloadError";
    public static final String EVENT_AD_CLOSED = "onAdPreloadClosed";
    public static final String EVENT_AD_OPEN = "onAdPreloadOpen";
    public static final String EVENT_AD_CLICKED = "onAdPreloadClicked";
    public static final String EVENT_AD_IMPRESSION = "onAdPreloadImpression";
    public static CacheManager instance = new CacheManager();
    Map<String, RNAdMobUnifiedAdQueueWrapper> repositoriesMap = new HashMap<String, RNAdMobUnifiedAdQueueWrapper>();

    public boolean isLoading(String id2) {
        if (this.repositoriesMap.get(id2) != null) {
            return this.repositoriesMap.get(id2).isLoading();
        }
        return false;
    }

    public int numberOfAds(String id2) {
        if (this.repositoriesMap.containsKey(id2)) {
            return this.repositoriesMap.get((Object)id2).nativeAds.size();
        }
        return 0;
    }

    public void attachAdListener(String id2, AdListener listener) {
        if (this.repositoriesMap.get(id2) != null) {
            this.repositoriesMap.get(id2).attachAdListener(listener);
        }
    }

    public void detachAdListener(String id2, AdListener listener) {
        if (this.repositoriesMap.get(id2) != null) {
            this.repositoriesMap.get(id2).detachAdListener(listener);
        }
    }

    public void registerRepository(ReactContext context, ReadableMap config, Promise promise) {
        try {
            String name = config.getString("name");
            String adUnitId = config.getString("adUnitId");
            if (adUnitId == null) {
                promise.reject("Error", "the adUnitId has to be set in config");
                return;
            }
            if (name == null) {
                name = adUnitId;
            }
            if (!this.repositoriesMap.containsKey(name)) {
                this.repositoriesMap.put(name, new RNAdMobUnifiedAdQueueWrapper(context, config, name));
                instance.requestAds(name);
            }
            promise.resolve((Object)true);
        }
        catch (Exception e) {
            promise.reject("Error", e.getMessage());
        }
    }

    public void unRegisterRepository(String repo) {
        this.repositoriesMap.remove(repo);
    }

    public void resetCache() {
        this.repositoriesMap.clear();
    }

    public void requestAds(String repo) {
        this.repositoriesMap.get(repo).fillAds();
    }

    public Boolean isRegistered(String repository) {
        return this.repositoriesMap.containsKey(repository);
    }

    public RNAdMobUnifiedAdContainer getNativeAd(String repository) {
        if (this.repositoriesMap.containsKey(repository)) {
            return this.repositoriesMap.get(repository).getAd();
        }
        return null;
    }

    public WritableMap hasAd(String repository) {
        if (this.repositoriesMap.containsKey(repository)) {
            return this.repositoriesMap.get(repository).hasAd();
        }
        WritableMap args = Arguments.createMap();
        args.putInt(repository, 0);
        return args;
    }
}

