/*
 * Decompiled with CFR 0.152.
 */
package com.ammarahmed.rnadmob.nativeads;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.ammarahmed.rnadmob.nativeads.EventEmitter;
import com.ammarahmed.rnadmob.nativeads.RNAdMobUnifiedAdComparator;
import com.ammarahmed.rnadmob.nativeads.RNAdMobUnifiedAdContainer;
import com.ammarahmed.rnadmob.nativeads.UnifiedNativeAdLoadedListener;
import com.ammarahmed.rnadmob.nativeads.Utils;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RNAdMobUnifiedAdQueueWrapper {
    public String adUnitId;
    public String name;
    public Integer totalAds = 5;
    public long expirationInterval = 3600000L;
    public int totalRetryCount = 10;
    public long retryDelay = 3000L;
    private int retryCount = 0;
    public Boolean muted = true;
    public Boolean mediation = false;
    public List<RNAdMobUnifiedAdContainer> nativeAds;
    List<AdListener> attachedAdListeners = new ArrayList<AdListener>();
    ReactContext mContext;
    int loadingAdRequestCount = 0;
    VideoOptions.Builder videoOptions;
    NativeAdOptions.Builder adOptions;
    AdListener adListener;
    private AdLoader adLoader;
    private AdManagerAdRequest.Builder adRequest;
    private UnifiedNativeAdLoadedListener unifiedNativeAdLoadedListener;
    private final Handler handler = new Handler();
    AdLoader.Builder adLoaderBuilder;

    public RNAdMobUnifiedAdQueueWrapper(ReactContext context, ReadableMap config, String repository) {
        this.mContext = context;
        this.adUnitId = config.getString("adUnitId");
        this.name = repository;
        this.videoOptions = new VideoOptions.Builder();
        this.adRequest = new AdManagerAdRequest.Builder();
        this.adOptions = new NativeAdOptions.Builder();
        this.adListener = new AdListener(){

            public void onAdFailedToLoad(LoadAdError adError) {
                super.onAdFailedToLoad(adError);
                RNAdMobUnifiedAdQueueWrapper.this.loadingAdRequestCount = RNAdMobUnifiedAdQueueWrapper.this.mediation.booleanValue() ? --RNAdMobUnifiedAdQueueWrapper.this.loadingAdRequestCount : 0;
                if (RNAdMobUnifiedAdQueueWrapper.this.loadingAdRequestCount > 0) {
                    return;
                }
                boolean stopPreloading = false;
                switch (adError.getCode()) {
                    case 0: 
                    case 1: {
                        stopPreloading = true;
                    }
                }
                if (stopPreloading) {
                    WritableMap event = Arguments.createMap();
                    WritableMap error = Arguments.createMap();
                    error.putString("message", adError.getMessage());
                    error.putInt("code", adError.getCode());
                    error.putString("domain", adError.getDomain());
                    event.putMap("error", (ReadableMap)error);
                    EventEmitter.sendEvent(RNAdMobUnifiedAdQueueWrapper.this.mContext, "onAdPreloadError:" + RNAdMobUnifiedAdQueueWrapper.this.name, event);
                    RNAdMobUnifiedAdQueueWrapper.this.notifyOnAdsLoadFailed(adError);
                    return;
                }
                if (RNAdMobUnifiedAdQueueWrapper.this.retryCount >= RNAdMobUnifiedAdQueueWrapper.this.totalRetryCount) {
                    WritableMap event = RNAdMobUnifiedAdQueueWrapper.this.getDefaultEventData();
                    WritableMap error = Arguments.createMap();
                    error.putString("message", "reach maximum retry");
                    error.putInt("code", 0);
                    error.putString("domain", "");
                    event.putMap("error", (ReadableMap)error);
                    EventEmitter.sendEvent(RNAdMobUnifiedAdQueueWrapper.this.mContext, "onAdPreloadError:" + RNAdMobUnifiedAdQueueWrapper.this.name, event);
                    RNAdMobUnifiedAdQueueWrapper.this.notifyOnAdsLoadFailed(adError);
                    return;
                }
                ++RNAdMobUnifiedAdQueueWrapper.this.retryCount;
                RNAdMobUnifiedAdQueueWrapper.this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        RNAdMobUnifiedAdQueueWrapper.this.fillAds();
                    }
                }, RNAdMobUnifiedAdQueueWrapper.this.retryDelay);
            }

            public void onAdImpression() {
                super.onAdImpression();
                EventEmitter.sendEvent(RNAdMobUnifiedAdQueueWrapper.this.mContext, "onAdPreloadImpression:" + RNAdMobUnifiedAdQueueWrapper.this.name, RNAdMobUnifiedAdQueueWrapper.this.getDefaultEventData());
            }

            public void onAdClosed() {
                super.onAdClosed();
                WritableMap map = Arguments.createMap();
                EventEmitter.sendEvent(RNAdMobUnifiedAdQueueWrapper.this.mContext, "onAdPreloadClosed:" + RNAdMobUnifiedAdQueueWrapper.this.name, RNAdMobUnifiedAdQueueWrapper.this.getDefaultEventData());
            }

            public void onAdOpened() {
                super.onAdOpened();
                EventEmitter.sendEvent(RNAdMobUnifiedAdQueueWrapper.this.mContext, "onAdPreloadOpen:" + RNAdMobUnifiedAdQueueWrapper.this.name, RNAdMobUnifiedAdQueueWrapper.this.getDefaultEventData());
            }

            public void onAdClicked() {
                super.onAdClicked();
                EventEmitter.sendEvent(RNAdMobUnifiedAdQueueWrapper.this.mContext, "onAdPreloadClicked:" + RNAdMobUnifiedAdQueueWrapper.this.name, RNAdMobUnifiedAdQueueWrapper.this.getDefaultEventData());
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                EventEmitter.sendEvent(RNAdMobUnifiedAdQueueWrapper.this.mContext, "onAdPreloadLoaded:" + RNAdMobUnifiedAdQueueWrapper.this.name, RNAdMobUnifiedAdQueueWrapper.this.getDefaultEventData());
                RNAdMobUnifiedAdQueueWrapper.this.retryCount = 0;
                RNAdMobUnifiedAdQueueWrapper.this.loadingAdRequestCount = RNAdMobUnifiedAdQueueWrapper.this.mediation.booleanValue() ? --RNAdMobUnifiedAdQueueWrapper.this.loadingAdRequestCount : 0;
                RNAdMobUnifiedAdQueueWrapper.this.notifyOnAdsLoaded();
                if (RNAdMobUnifiedAdQueueWrapper.this.loadingAdRequestCount == 0) {
                    RNAdMobUnifiedAdQueueWrapper.this.fillAds();
                }
            }
        };
        this.setConfiguration(config);
    }

    private WritableMap getDefaultEventData() {
        WritableMap map = Arguments.createMap();
        map.putString("adUnitId", this.adUnitId);
        map.putString("repo", this.name);
        return map;
    }

    private void notifyOnAdsLoadFailed(LoadAdError adError) {
        AdListener[] array;
        for (AdListener item : array = this.attachedAdListeners.toArray(new AdListener[0])) {
            item.onAdFailedToLoad(adError);
        }
    }

    private void notifyOnAdsLoaded() {
        AdListener[] array;
        for (AdListener item : array = this.attachedAdListeners.toArray(new AdListener[0])) {
            item.onAdLoaded();
        }
    }

    public void attachAdListener(AdListener listener) {
        this.attachedAdListeners.add(listener);
    }

    public void detachAdListener(AdListener listener) {
        this.attachedAdListeners.remove(listener);
    }

    public void setConfiguration(ReadableMap config) {
        if (config.hasKey("retryDelay")) {
            this.retryDelay = config.getInt("retryDelay");
        }
        if (config.hasKey("totalRetryCount")) {
            this.totalRetryCount = config.getInt("totalRetryCount");
        }
        if (config.hasKey("numOfAds")) {
            this.totalAds = config.getInt("numOfAds");
        }
        this.nativeAds = new ArrayList<RNAdMobUnifiedAdContainer>(this.totalAds);
        if (config.hasKey("mute")) {
            this.muted = config.getBoolean("mute");
        }
        if (config.hasKey("expirationPeriod")) {
            this.expirationInterval = config.getInt("expirationPeriod");
        }
        if (config.hasKey("mediationEnabled")) {
            this.mediation = config.getBoolean("mediationEnabled");
        }
        if (config.hasKey("adChoicesPlacement")) {
            this.adOptions.setAdChoicesPlacement(config.getInt("adChoicesPlacement"));
        }
        if (config.hasKey("requestNonPersonalizedAdsOnly")) {
            Utils.setRequestNonPersonalizedAdsOnly(config.getBoolean("requestNonPersonalizedAdsOnly"), this.adRequest);
        }
        if (config.hasKey("mediaAspectRatio")) {
            Utils.setMediaAspectRatio(config.getInt("mediaAspectRatio"), this.adOptions);
        }
        if (config.hasKey("swipeGestureDirection")) {
            this.adOptions.enableCustomClickGestureDirection(config.getInt("swipeGestureDirection"), config.hasKey("tapsAllowed") && config.getBoolean("tapsAllowed"));
        }
        Utils.setVideoOptions(config.getMap("videoOptions"), this.videoOptions, this.adOptions);
        Utils.setTargetingOptions(config.getMap("targetingOptions"), this.adRequest);
        this.unifiedNativeAdLoadedListener = new UnifiedNativeAdLoadedListener(this.name, this.nativeAds, this.totalAds, (Context)this.mContext);
    }

    public void fillAds() {
        try {
            int require2fill = this.totalAds - this.nativeAds.size();
            if (require2fill <= 0 || this.isLoading().booleanValue()) {
                return;
            }
            this.adLoaderBuilder = new AdLoader.Builder((Context)this.mContext, this.adUnitId);
            this.adLoaderBuilder.withNativeAdOptions(this.adOptions.build());
            this.adLoaderBuilder.forNativeAd((NativeAd.OnNativeAdLoadedListener)this.unifiedNativeAdLoadedListener);
            this.adLoaderBuilder.withAdListener(this.adListener);
            this.adLoader = this.adLoaderBuilder.build();
            Log.i((String)"AdMob repo", (String)("require to load >" + require2fill + "< ads more"));
            this.loadingAdRequestCount = require2fill;
            if (this.mediation.booleanValue()) {
                for (int i = 0; i < require2fill; ++i) {
                    this.adLoader.loadAd(this.adRequest.build());
                }
            } else {
                this.adLoader.loadAds((AdRequest)this.adRequest.build(), require2fill);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RNAdMobUnifiedAdContainer getAd() {
        if (this.nativeAds.isEmpty()) {
            return null;
        }
        long now = System.currentTimeMillis();
        RNAdMobUnifiedAdContainer ad = null;
        Collections.sort(this.nativeAds, new RNAdMobUnifiedAdComparator());
        ArrayList<RNAdMobUnifiedAdContainer> discardItems = new ArrayList<RNAdMobUnifiedAdContainer>();
        for (RNAdMobUnifiedAdContainer item : this.nativeAds) {
            if (now - item.loadTime < this.expirationInterval) {
                ad = item;
                break;
            }
            if (item.references > 0) continue;
            discardItems.add(item);
        }
        for (RNAdMobUnifiedAdContainer item : discardItems) {
            item.unifiedNativeAd.destroy();
            this.nativeAds.remove(item);
        }
        this.fillAds();
        if (ad == null) {
            return null;
        }
        Object object = ad;
        ((RNAdMobUnifiedAdContainer)object).showCount = ((RNAdMobUnifiedAdContainer)object).showCount + 1;
        object = ad;
        ((RNAdMobUnifiedAdContainer)object).references = ((RNAdMobUnifiedAdContainer)object).references + 1;
        return ad;
    }

    public Boolean isLoading() {
        if (this.adLoader != null) {
            return this.adLoader.isLoading() || this.loadingAdRequestCount > 0;
        }
        return false;
    }

    public WritableMap hasAd() {
        WritableMap args = Arguments.createMap();
        args.putInt(this.name, this.nativeAds.size());
        return args;
    }
}

