/*
 * Decompiled with CFR 0.152.
 */
package com.ammarahmed.rnadmob.nativeads;

import android.content.Context;
import android.view.View;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.nativead.MediaView;
import javax.annotation.Nullable;

public class RNAdmobMediaView
extends MediaView {
    ReactContext mContext;
    VideoController vc;
    MediaContent mediaContent;
    private final Runnable measureAndLayout = new Runnable(){

        @Override
        public void run() {
            RNAdmobMediaView.this.measure(View.MeasureSpec.makeMeasureSpec((int)RNAdmobMediaView.this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)RNAdmobMediaView.this.getHeight(), (int)0x40000000));
            RNAdmobMediaView.this.layout(RNAdmobMediaView.this.getLeft(), RNAdmobMediaView.this.getTop(), RNAdmobMediaView.this.getRight(), RNAdmobMediaView.this.getBottom());
        }
    };
    public VideoController.VideoLifecycleCallbacks videoLifecycleCallbacks = new VideoController.VideoLifecycleCallbacks(){

        public void onVideoStart() {
            super.onVideoStart();
            RNAdmobMediaView.this.sendEvent("onVideoStart", null);
        }

        public void onVideoPlay() {
            super.onVideoPlay();
            RNAdmobMediaView.this.sendEvent("onVideoPlay", null);
        }

        public void onVideoPause() {
            super.onVideoPause();
            RNAdmobMediaView.this.sendEvent("onVideoPause", null);
        }

        public void onVideoEnd() {
            super.onVideoEnd();
            RNAdmobMediaView.this.sendEvent("onVideoEnd", null);
        }

        public void onVideoMute(boolean b) {
            super.onVideoMute(b);
            WritableMap event = Arguments.createMap();
            event.putBoolean("muted", b);
            RNAdmobMediaView.this.sendEvent("onVideoMute", event);
        }
    };

    public void setVideoController(VideoController videoController) {
        this.vc = videoController;
    }

    public void setMedia(MediaContent mc) {
        this.mediaContent = mc;
    }

    public void getCurrentProgress() {
        if (this.vc == null) {
            return;
        }
        WritableMap progress = Arguments.createMap();
        if (this.vc.getPlaybackState() == 1 && this.mediaContent != null) {
            progress.putString("currentTime", String.valueOf(this.mediaContent.getCurrentTime()));
            progress.putString("duration", String.valueOf(this.mediaContent.getDuration()));
            this.sendEvent("onVideoProgress", progress);
        }
    }

    public RNAdmobMediaView(ReactContext context) {
        super((Context)context);
        this.mContext = context;
        this.requestLayout();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestLayout();
    }

    public void setPause(boolean pause) {
        if (this.vc == null) {
            return;
        }
        if (pause) {
            this.vc.pause();
        } else {
            this.vc.play();
        }
    }

    public void setMuted(boolean muted) {
        if (this.vc == null) {
            return;
        }
        this.vc.mute(muted);
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.measureAndLayout);
    }

    public void sendEvent(String name, @Nullable WritableMap event) {
        ReactContext reactContext = this.mContext;
        ((RCTEventEmitter)reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), name, event);
    }
}

