/*
 * Decompiled with CFR 0.152.
 */
package com.ammarahmed.rnadmob.nativeads;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ammarahmed.rnadmob.nativeads.CacheManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.google.android.gms.ads.AdInspectorError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import java.util.List;
import java.util.Map;

public class RNAdmobNativeAdsManager
extends ReactContextBaseJavaModule {
    public ReactApplicationContext mContext;

    public RNAdmobNativeAdsManager(ReactApplicationContext context) {
        super(context);
        this.mContext = context;
    }

    @NonNull
    public String getName() {
        return "RNAdmobNativeAdsManager";
    }

    @ReactMethod
    public void startInspector() {
        MobileAds.openAdInspector((Context)this.mContext, (OnAdInspectorClosedListener)new OnAdInspectorClosedListener(){

            public void onAdInspectorClosed(@Nullable AdInspectorError adInspectorError) {
            }
        });
    }

    @ReactMethod
    public void openDebugMenu(String adUnitId) {
        MobileAds.openDebugMenu((Context)this.mContext, (String)adUnitId);
    }

    @ReactMethod
    public void setRequestConfiguration(ReadableMap config, Promise promise) {
        String maxAdContentRating;
        Activity context = this.getReactApplicationContext().getCurrentActivity();
        if (context == null) {
            Log.e((String)"AdmobNativeAds", (String)"setRequestConfiguration() is called outside MainActivity");
            context = this.getReactApplicationContext();
        }
        RequestConfiguration.Builder configuration = new RequestConfiguration.Builder();
        if (config.hasKey("maxAdContentRating") && config.getString("maxAdContentRating") != null && (maxAdContentRating = config.getString("maxAdContentRating")) != null) {
            if (maxAdContentRating.equals("UNSPECIFIED")) {
                maxAdContentRating = "";
            }
            configuration.setMaxAdContentRating(maxAdContentRating);
        }
        if (config.hasKey("tagForChildDirectedTreatment")) {
            boolean tagForChildDirectedTreatment = config.getBoolean("tagForChildDirectedTreatment");
            configuration.setTagForChildDirectedTreatment(tagForChildDirectedTreatment ? 1 : 0);
        }
        if (config.hasKey("tagForUnderAgeOfConsent")) {
            boolean tagForUnderAgeOfConsent = config.getBoolean("tagForUnderAgeOfConsent");
            configuration.setTagForUnderAgeOfConsent(tagForUnderAgeOfConsent ? 1 : 0);
        }
        if (config.hasKey("testDeviceIds")) {
            configuration.setTestDeviceIds((List)Arguments.toList((ReadableArray)config.getArray("testDeviceIds")));
        }
        MobileAds.setRequestConfiguration((RequestConfiguration)configuration.build());
        MobileAds.initialize((Context)context, status -> {
            WritableArray array = Arguments.createArray();
            for (Map.Entry entry : status.getAdapterStatusMap().entrySet()) {
                WritableMap info = Arguments.createMap();
                info.putString("name", (String)entry.getKey());
                info.putInt("state", ((AdapterStatus)entry.getValue()).getInitializationState().ordinal());
                info.putString("description", ((AdapterStatus)entry.getValue()).getDescription());
                array.pushMap((ReadableMap)info);
            }
            promise.resolve((Object)array);
        });
    }

    @ReactMethod
    public void isTestDevice(Promise promise) {
        AdRequest builder = new AdRequest.Builder().build();
        promise.resolve((Object)builder.isTestDevice((Context)this.getReactApplicationContext()));
    }

    @ReactMethod
    public void registerRepository(ReadableMap config, Promise promise) {
        CacheManager.instance.registerRepository((ReactContext)this.mContext, config, promise);
    }

    @ReactMethod
    public void unRegisterRepository(String id2) {
        CacheManager.instance.unRegisterRepository(id2);
    }

    @ReactMethod
    public void resetCache() {
        CacheManager.instance.resetCache();
    }

    @ReactMethod
    public void hasAd(String repository, Promise promise) {
        promise.resolve((Object)CacheManager.instance.hasAd(repository));
    }
}

