/*
 * Decompiled with CFR 0.152.
 */
package com.ammarahmed.rnadmob.nativeads;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ammarahmed.rnadmob.nativeads.CacheManager;
import com.ammarahmed.rnadmob.nativeads.R;
import com.ammarahmed.rnadmob.nativeads.RNAdMobUnifiedAdContainer;
import com.ammarahmed.rnadmob.nativeads.RNAdmobMediaView;
import com.ammarahmed.rnadmob.nativeads.Utils;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeAdView;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.UUID;

public class RNAdmobNativeView
extends LinearLayout {
    private final Runnable measureAndLayout = () -> {
        this.measure(View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)0x40000000));
        this.layout(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
    };
    public int adRefreshInterval = 60000;
    @Nullable
    protected ReactContext mContext;
    NativeAdView nativeAdView;
    NativeAd nativeAd;
    VideoOptions.Builder videoOptions;
    AdManagerAdRequest.Builder adRequest;
    NativeAdOptions.Builder adOptions;
    AdLoader.Builder builder;
    AdLoader adLoader;
    RNAdmobMediaView mediaView;
    RNAdMobUnifiedAdContainer unifiedNativeAdContainer;
    CatalystInstance mCatalystInstance;
    private int mediaAspectRatio = 1;
    private boolean loadingAd = false;
    private Runnable retryRunnable;
    private String adRepo;
    private int adChoicesPlacement = 1;
    private boolean requestNonPersonalizedAdsOnly = false;
    private String admobAdUnitId = "";
    private Handler handler;
    AdListener adListener = new AdListener(){

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            WritableMap event = Arguments.createMap();
            WritableMap error = Arguments.createMap();
            error.putString("message", loadAdError.getMessage());
            error.putInt("code", loadAdError.getCode());
            error.putString("domain", loadAdError.getDomain());
            event.putMap("error", (ReadableMap)error);
            RNAdmobNativeView.this.loadingAd = false;
            if (RNAdmobNativeView.this.adRepo != null) {
                CacheManager.instance.detachAdListener(RNAdmobNativeView.this.adRepo, RNAdmobNativeView.this.adListener);
            }
            RNAdmobNativeView.this.sendEvent("onAdFailedToLoad", event);
        }

        public void onAdClosed() {
            super.onAdClosed();
            RNAdmobNativeView.this.sendEvent("onAdClosed", null);
        }

        public void onAdOpened() {
            super.onAdOpened();
            RNAdmobNativeView.this.sendEvent("onAdOpened", null);
        }

        public void onAdClicked() {
            super.onAdClicked();
            RNAdmobNativeView.this.sendEvent("onAdClicked", null);
        }

        public void onAdLoaded() {
            super.onAdLoaded();
            if (RNAdmobNativeView.this.adRepo != null) {
                CacheManager.instance.detachAdListener(RNAdmobNativeView.this.adRepo, RNAdmobNativeView.this.adListener);
                RNAdmobNativeView.this.loadAd();
            }
            RNAdmobNativeView.this.loadingAd = false;
            RNAdmobNativeView.this.sendEvent("onAdLoaded", null);
        }

        public void onAdImpression() {
            super.onAdImpression();
            RNAdmobNativeView.this.sendEvent("onAdImpression", null);
        }
    };
    NativeAd.OnNativeAdLoadedListener onNativeAdLoadedListener = new NativeAd.OnNativeAdLoadedListener(){

        public void onNativeAdLoaded(NativeAd ad) {
            if (RNAdmobNativeView.this.nativeAd != null) {
                RNAdmobNativeView.this.nativeAd.destroy();
            }
            RNAdmobNativeView.this.loadingAd = false;
            RNAdmobNativeView.this.setNativeAdToJS(ad);
        }
    };
    public NativeAd lastNativeAd;

    public RNAdmobNativeView(ReactContext context) {
        super((Context)context);
        this.mContext = context;
        this.createView((Context)context);
        this.handler = new Handler();
        this.mCatalystInstance = this.mContext.getCatalystInstance();
        this.setId(UUID.randomUUID().hashCode() + this.getId());
        this.videoOptions = new VideoOptions.Builder();
        this.adRequest = new AdManagerAdRequest.Builder();
        this.adOptions = new NativeAdOptions.Builder();
    }

    public void createView(Context context) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        View viewRoot = layoutInflater.inflate(R.layout.rn_ad_unified_native_ad, (ViewGroup)this, true);
        this.nativeAdView = (NativeAdView)viewRoot.findViewById(R.id.native_ad_view);
    }

    public String getAdRepo() {
        return this.adRepo;
    }

    public void addMediaView(int id2) {
        try {
            this.mediaView = (RNAdmobMediaView)this.nativeAdView.findViewById(id2);
            if (this.mediaView != null) {
                Objects.requireNonNull(this.nativeAd.getMediaContent()).getVideoController().setVideoLifecycleCallbacks(this.mediaView.videoLifecycleCallbacks);
                this.nativeAdView.setMediaView((MediaView)this.nativeAdView.findViewById(id2));
                this.mediaView.requestLayout();
                this.setNativeAd();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Method getDeclaredMethod(Object obj, String name) {
        try {
            return obj.getClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setNativeAdToJS(NativeAd ad) {
        try {
            this.nativeAd = ad;
            WritableMap args = Arguments.createMap();
            args.putString("headline", this.nativeAd.getHeadline());
            args.putString("tagline", this.nativeAd.getBody());
            args.putString("advertiser", this.nativeAd.getAdvertiser());
            args.putString("callToAction", this.nativeAd.getCallToAction());
            args.putBoolean("video", Objects.requireNonNull(this.nativeAd.getMediaContent()).hasVideoContent());
            if (this.nativeAd.getPrice() != null) {
                args.putString("price", this.nativeAd.getPrice());
            }
            if (this.nativeAd.getStore() != null) {
                args.putString("store", this.nativeAd.getStore());
            }
            if (this.nativeAd.getStarRating() != null) {
                args.putInt("rating", this.nativeAd.getStarRating().intValue());
            }
            float aspectRatio = 1.0f;
            MediaContent mediaContent = this.nativeAd.getMediaContent();
            if (this.nativeAdView.getMediaView() != null) {
                this.nativeAdView.getMediaView().setMediaContent(this.nativeAd.getMediaContent());
            }
            if (mediaContent != null && null != this.getDeclaredMethod(mediaContent, "getAspectRatio")) {
                aspectRatio = this.nativeAd.getMediaContent().getAspectRatio();
                if (aspectRatio > 0.0f) {
                    args.putString("aspectRatio", String.valueOf(aspectRatio));
                } else {
                    args.putString("aspectRatio", String.valueOf(1.0f));
                }
            } else {
                args.putString("aspectRatio", String.valueOf(1.0f));
            }
            WritableNativeArray images = new WritableNativeArray();
            if (!this.nativeAd.getImages().isEmpty()) {
                for (int i = 0; i < this.nativeAd.getImages().size(); ++i) {
                    WritableMap map = Arguments.createMap();
                    if (this.nativeAd.getImages().get(i) == null) continue;
                    map.putString("url", Objects.requireNonNull(((NativeAd.Image)this.nativeAd.getImages().get(i)).getUri()).toString());
                    map.putInt("width", 0);
                    map.putInt("height", 0);
                    images.pushMap((ReadableMap)map);
                }
            }
            args.putArray("images", (ReadableArray)images);
            if (this.nativeAd.getIcon() != null) {
                if (this.nativeAd.getIcon().getUri() != null) {
                    args.putString("icon", this.nativeAd.getIcon().getUri().toString());
                } else {
                    args.putString("icon", "empty");
                }
            } else {
                args.putString("icon", "noicon");
            }
            this.sendEvent("onNativeAdLoaded", args);
            this.setNativeAd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.loadingAd = false;
    }

    public void sendEvent(String name, @Nullable WritableMap event) {
        ReactContext reactContext = this.mContext;
        ((RCTEventEmitter)reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), name, event);
    }

    public void loadAd() {
        if (this.adRepo != null) {
            this.getAdFromRepository();
        } else {
            try {
                if (this.loadingAd) {
                    return;
                }
                this.loadingAd = true;
                this.adLoader.loadAd(this.adRequest.build());
            }
            catch (Exception e) {
                this.loadingAd = false;
            }
        }
    }

    private void getAdFromRepository() {
        try {
            if (!CacheManager.instance.isRegistered(this.adRepo).booleanValue()) {
                if (this.adListener != null) {
                    this.adListener.onAdFailedToLoad(new LoadAdError(3, "The requested repo is not registered", "", null, null));
                }
            } else {
                CacheManager.instance.attachAdListener(this.adRepo, this.adListener);
                if (CacheManager.instance.numberOfAds(this.adRepo) != 0) {
                    this.unifiedNativeAdContainer = CacheManager.instance.getNativeAd(this.adRepo);
                    if (this.unifiedNativeAdContainer != null) {
                        this.nativeAd = this.unifiedNativeAdContainer.unifiedNativeAd;
                        if (this.mediaView != null) {
                            this.nativeAdView.setMediaView((MediaView)this.mediaView);
                            this.mediaView.requestLayout();
                        }
                        this.setNativeAdToJS(this.nativeAd);
                    }
                } else if (!CacheManager.instance.isLoading(this.adRepo)) {
                    CacheManager.instance.requestAds(this.adRepo);
                }
            }
        }
        catch (Exception e) {
            this.adListener.onAdFailedToLoad(new LoadAdError(3, e.toString(), "", null, null));
        }
    }

    private void resetView(View view) {
        if (view.getParent() != null) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
    }

    public void addNewView(View child, int index) {
        try {
            this.resetView(child);
            this.nativeAdView.addView(child, index);
            this.requestLayout();
            this.nativeAdView.requestLayout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addView(View child) {
        this.resetView(child);
        super.addView(child);
        this.requestLayout();
    }

    public void setAdRefreshInterval(int interval) {
        this.adRefreshInterval = interval;
    }

    public void setAdRepository(String repo) {
        this.adRepo = repo;
    }

    public void setAdUnitId(String id2) {
        this.admobAdUnitId = id2;
        if (id2 == null) {
            return;
        }
        this.loadAdBuilder();
    }

    public void loadAdBuilder() {
        this.builder = new AdLoader.Builder((Context)this.mContext, this.admobAdUnitId);
        this.builder.forNativeAd(this.onNativeAdLoadedListener);
        this.builder.withNativeAdOptions(this.adOptions.build());
        this.adLoader = this.builder.withAdListener(this.adListener).build();
    }

    public void setAdChoicesPlacement(int location) {
        this.adChoicesPlacement = location;
        this.adOptions.setAdChoicesPlacement(this.adChoicesPlacement);
    }

    public void setRequestNonPersonalizedAdsOnly(boolean npa) {
        Utils.setRequestNonPersonalizedAdsOnly(npa, this.adRequest);
    }

    public void setMediaAspectRatio(int type) {
        this.mediaAspectRatio = type;
        this.adOptions.setMediaAspectRatio(this.mediaAspectRatio);
    }

    public void setSwipeGestureOptions(int direction, boolean tapsAllowed) {
        this.adOptions.enableCustomClickGestureDirection(direction, tapsAllowed);
    }

    public void setNativeAd() {
        try {
            if (this.nativeAdView != null && this.nativeAd != null && this.lastNativeAd != this.nativeAd) {
                this.lastNativeAd = this.nativeAd;
                this.nativeAdView.setNativeAd(this.nativeAd);
                if (this.nativeAdView.getMediaView() != null) {
                    this.nativeAdView.getMediaView().setMediaContent(this.nativeAd.getMediaContent());
                    if (Objects.requireNonNull(this.nativeAd.getMediaContent()).hasVideoContent()) {
                        this.mediaView.setVideoController(this.nativeAd.getMediaContent().getVideoController());
                        this.mediaView.setMedia(this.nativeAd.getMediaContent());
                    }
                }
                this.handler.postDelayed(() -> this.nativeAdView.getRootView().requestLayout(), 1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVideoOptions(ReadableMap options) {
        Utils.setVideoOptions(options, this.videoOptions, this.adOptions);
    }

    public void setTargetingOptions(ReadableMap options) {
        Utils.setTargetingOptions(options, this.adRequest);
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.measureAndLayout);
    }

    public void removeHandler() {
        this.loadingAd = false;
        if (this.handler != null) {
            this.handler = null;
        }
    }
}

