/*
 * Decompiled with CFR 0.152.
 */
package com.ammarahmed.rnadmob.nativeads;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.ammarahmed.rnadmob.nativeads.CacheManager;
import com.ammarahmed.rnadmob.nativeads.RNAdMobUnifiedAdContainer;
import com.ammarahmed.rnadmob.nativeads.RNAdmobNativeView;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import java.util.Map;
import javax.annotation.Nullable;

public class RNAdmobNativeViewManager
extends ViewGroupManager<RNAdmobNativeView> {
    public static final String REACT_CLASS = "RNGADNativeView";
    public static final String EVENT_AD_FAILED_TO_LOAD = "onAdFailedToLoad";
    public static final String EVENT_AD_CLICKED = "onAdClicked";
    public static final String EVENT_AD_CLOSED = "onAdClosed";
    public static final String EVENT_AD_OPENED = "onAdOpened";
    public static final String EVENT_AD_IMPRESSION = "onAdImpression";
    public static final String EVENT_AD_LOADED = "onAdLoaded";
    public static final String EVENT_AD_LEFT_APPLICATION = "onAdLeftApplication";
    public static final String EVENT_NATIVE_AD_LOADED = "onNativeAdLoaded";
    public static final String PROP_DELAY_AD_LOAD = "delayAdLoad";
    public static final String PROP_TEST_DEVICES = "testDevices";
    public static final String PROP_AD_UNIT_ID = "adUnitID";
    public static final String PROP_MEDIA_VIEW = "mediaview";
    public static final String PROP_REFRESH_INTERVAL = "refreshInterval";
    public static final String PROP_HEADLINE_VIEW = "headline";
    public static final String PROP_TAGLINE_VIEW = "tagline";
    public static final String PROP_ADVERTISER_VIEW = "advertiser";
    public static final String PROP_STORE_VIEW = "store";
    public static final String PROP_IMAGE_VIEW = "image";
    public static final String PROP_CALL_TO_ACTION_VIEW = "callToAction";
    public static final String PROP_PRICE_VIEW = "price";
    public static final String PROP_ICON_VIEW = "icon";
    public static final String PROP_STAR_RATING_VIEW = "starrating";
    public static final String PROP_AD_CHOICES_PLACEMENT = "adChoicesPlacement";
    public static final String PROP_NON_PERSONALIZED_ADS = "requestNonPersonalizedAdsOnly";
    public static final String PROP_PAUSE_AD_RELOAD = "pauseAdReload";
    public static final String PROP_MEDIA_ASPECT_RATIO = "mediaAspectRatio";
    public static final String PROP_VIDEO_OPTIONS = "videoOptions";
    public static final String PROP_TARGETING_OPTIONS = "targetingOptions";
    public static final String PROP_AD_REPOSITORY = "repository";
    public static final int COMMAND_LOAD_AD = 1;

    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        String[] events;
        MapBuilder.Builder builder = MapBuilder.builder();
        for (String event : events = new String[]{EVENT_AD_FAILED_TO_LOAD, EVENT_AD_CLICKED, EVENT_AD_CLOSED, EVENT_AD_OPENED, EVENT_AD_IMPRESSION, EVENT_AD_LOADED, EVENT_AD_LEFT_APPLICATION, EVENT_NATIVE_AD_LOADED}) {
            builder.put((Object)event, (Object)MapBuilder.of((Object)"registrationName", (Object)event));
        }
        return builder.build();
    }

    public String getName() {
        return REACT_CLASS;
    }

    protected RNAdmobNativeView createViewInstance(ThemedReactContext reactContext) {
        return new RNAdmobNativeView((ReactContext)reactContext);
    }

    public void addView(RNAdmobNativeView parent, View child, int index) {
        parent.addNewView(child, index);
    }

    @ReactProp(name="targetingOptions")
    public void setPropTargetingOptions(RNAdmobNativeView nativeAdWrapper, ReadableMap options) {
        nativeAdWrapper.setTargetingOptions(options);
    }

    @ReactProp(name="videoOptions")
    public void setVideoOptions(RNAdmobNativeView nativeAdWrapper, ReadableMap options) {
        nativeAdWrapper.setVideoOptions(options);
    }

    @ReactProp(name="requestNonPersonalizedAdsOnly", defaultBoolean=false)
    public void setPropNonPersonalizedAds(RNAdmobNativeView nativeAdWrapper, boolean npa) {
        nativeAdWrapper.setRequestNonPersonalizedAdsOnly(npa);
    }

    @ReactProp(name="adChoicesPlacement")
    public void setPropAdChoicesPlacement(RNAdmobNativeView nativeAdWrapper, int location) {
        nativeAdWrapper.setAdChoicesPlacement(location);
    }

    @ReactProp(name="mediaAspectRatio")
    public void setMediaAspectRatio(RNAdmobNativeView nativeAdWrapper, int type) {
        nativeAdWrapper.setMediaAspectRatio(type);
    }

    @ReactProp(name="mediaview")
    public void setMediaView(RNAdmobNativeView nativeAdWrapper, int id2) {
        nativeAdWrapper.addMediaView(id2);
        nativeAdWrapper.setNativeAd();
    }

    @ReactProp(name="headline")
    public void setHeadlineView(RNAdmobNativeView nativeAdWrapper, int id2) {
        TextView view = (TextView)nativeAdWrapper.findViewById(id2);
        nativeAdWrapper.nativeAdView.setHeadlineView((View)view);
        nativeAdWrapper.setNativeAd();
    }

    @ReactProp(name="tagline")
    public void setPropTaglineView(RNAdmobNativeView nativeAdWrapper, int id2) {
        TextView view = (TextView)nativeAdWrapper.findViewById(id2);
        nativeAdWrapper.nativeAdView.setBodyView((View)view);
        nativeAdWrapper.setNativeAd();
    }

    @ReactProp(name="advertiser")
    public void setPropAdvertiserView(RNAdmobNativeView nativeAdWrapper, int id2) {
        TextView view = (TextView)nativeAdWrapper.findViewById(id2);
        nativeAdWrapper.nativeAdView.setAdvertiserView((View)view);
        nativeAdWrapper.setNativeAd();
    }

    @ReactProp(name="image")
    public void setPropImageView(RNAdmobNativeView nativeAdWrapper, int id2) {
        ImageView view = (ImageView)nativeAdWrapper.findViewById(id2);
        nativeAdWrapper.nativeAdView.setImageView((View)view);
        nativeAdWrapper.setNativeAd();
    }

    @ReactProp(name="icon")
    public void setPropIconView(RNAdmobNativeView nativeAdWrapper, int id2) {
        ImageView view = (ImageView)nativeAdWrapper.findViewById(id2);
        nativeAdWrapper.nativeAdView.setIconView((View)view);
        nativeAdWrapper.setNativeAd();
    }

    @ReactProp(name="store")
    public void setPropStoreView(RNAdmobNativeView nativeAdWrapper, int id2) {
        TextView view = (TextView)nativeAdWrapper.findViewById(id2);
        nativeAdWrapper.nativeAdView.setStoreView((View)view);
        nativeAdWrapper.setNativeAd();
    }

    @ReactProp(name="price")
    public void setPropPriceView(RNAdmobNativeView nativeAdWrapper, int id2) {
        TextView view = (TextView)nativeAdWrapper.findViewById(id2);
        nativeAdWrapper.nativeAdView.setPriceView((View)view);
        nativeAdWrapper.setNativeAd();
    }

    @ReactProp(name="starrating")
    public void setPropStarRatingView(RNAdmobNativeView nativeAdWrapper, int id2) {
        View view = nativeAdWrapper.findViewById(id2);
        nativeAdWrapper.nativeAdView.setStarRatingView(view);
        nativeAdWrapper.setNativeAd();
    }

    @ReactProp(name="callToAction")
    public void setPropCallToActionView(RNAdmobNativeView nativeAdWrapper, int id2) {
        View view = nativeAdWrapper.findViewById(id2);
        nativeAdWrapper.nativeAdView.setCallToActionView(view);
        nativeAdWrapper.setNativeAd();
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.builder().put((Object)"loadAd", (Object)1).build();
    }

    public void receiveCommand(RNAdmobNativeView nativeAdWrapper, int commandId, @Nullable ReadableArray args) {
        if (commandId == 1) {
            nativeAdWrapper.loadAd();
        }
    }

    @ReactProp(name="adUnitID")
    public void setPropAdUnitId(RNAdmobNativeView nativeAdWrapper, String adUnitId) {
        if (adUnitId == null) {
            return;
        }
        nativeAdWrapper.setAdUnitId(adUnitId);
    }

    @ReactProp(name="repository")
    public void setPropAdRepository(RNAdmobNativeView nativeAdWrapper, String repo) {
        if (repo == null) {
            return;
        }
        nativeAdWrapper.setAdRepository(repo);
    }

    @ReactProp(name="enableSwipeGestureOptions")
    public void setEnableSwipeGestureOptions(RNAdmobNativeView nativeAdWrapper, ReadableMap options) {
        nativeAdWrapper.setSwipeGestureOptions(options.getInt("swipeGestureDirection"), options.hasKey("tapsAllowed") && options.getBoolean("tapsAllowed"));
    }

    @ReactProp(name="refreshInterval")
    public void setRefreshInterval(RNAdmobNativeView nativeAdWrapper, int interval) {
        nativeAdWrapper.setAdRefreshInterval(interval);
    }

    public void onDropViewInstance(@NonNull RNAdmobNativeView nativeAdWrapper) {
        super.onDropViewInstance((View)nativeAdWrapper);
        nativeAdWrapper.removeHandler();
        CacheManager.instance.detachAdListener(nativeAdWrapper.getAdRepo(), nativeAdWrapper.adListener);
        if (nativeAdWrapper.nativeAd != null && nativeAdWrapper.unifiedNativeAdContainer != null) {
            RNAdMobUnifiedAdContainer rNAdMobUnifiedAdContainer = nativeAdWrapper.unifiedNativeAdContainer;
            rNAdMobUnifiedAdContainer.references = rNAdMobUnifiedAdContainer.references - 1;
        }
        if (nativeAdWrapper.nativeAdView != null) {
            nativeAdWrapper.nativeAdView.removeAllViews();
            nativeAdWrapper.nativeAdView.destroy();
            nativeAdWrapper.removeAllViews();
        }
    }
}

