/*
 * Decompiled with CFR 0.152.
 */
package com.rnlib.adyen;

import android.content.Context;
import com.adyen.checkout.core.log.LogUtil;
import com.adyen.checkout.core.log.Logger;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.dropin.service.CallResult;
import com.adyen.checkout.dropin.service.DropInService;
import com.adyen.checkout.redirect.RedirectComponent;
import com.jakewharton.retrofit2.adapter.kotlin.coroutines.CoroutineCallAdapterFactory;
import com.rnlib.adyen.AdyenPaymentModule;
import com.rnlib.adyen.ApiService;
import com.rnlib.adyen.ApiWorker;
import com.rnlib.adyen.AppServiceConfigData;
import com.rnlib.adyen.CheckoutApiService;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/rnlib/adyen/AdyenDropInService;", "Lcom/adyen/checkout/dropin/service/DropInService;", "()V", "getCheckoutApi", "Lcom/rnlib/adyen/CheckoutApiService;", "baseURL", "", "handleResponse", "Lcom/adyen/checkout/dropin/service/CallResult;", "call", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "makeDetailsCall", "actionComponentData", "Lorg/json/JSONObject;", "makePaymentsCall", "paymentComponentData", "Companion", "react-native-adyen-payment_release"})
public final class AdyenDropInService
extends DropInService {
    private static final String TAG;
    private static final MediaType CONTENT_TYPE;
    public static final Companion Companion;

    @NotNull
    public final CheckoutApiService getCheckoutApi(@NotNull String baseURL) {
        Intrinsics.checkParameterIsNotNull((Object)baseURL, (String)"baseURL");
        Object object = new Retrofit.Builder().baseUrl(baseURL).client(ApiWorker.INSTANCE.getClient()).addConverterFactory((Converter.Factory)ApiWorker.INSTANCE.getGsonConverter()).addCallAdapterFactory((CallAdapter.Factory)CoroutineCallAdapterFactory.Companion.create()).build().create(CheckoutApiService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Retrofit.Builder()\n     \u2026utApiService::class.java)");
        return (CheckoutApiService)object;
    }

    @NotNull
    public CallResult makePaymentsCall(@NotNull JSONObject paymentComponentData) {
        Intrinsics.checkParameterIsNotNull((Object)paymentComponentData, (String)"paymentComponentData");
        Logger.d((String)TAG, (String)"makePaymentsCall");
        AppServiceConfigData configData = AdyenPaymentModule.Companion.getAppServiceConfigData();
        JSONObject paymentRequest = AdyenPaymentModule.Companion.getPaymentData();
        paymentRequest.putOpt("paymentMethod", (Object)paymentComponentData.getJSONObject("paymentMethod"));
        paymentRequest.put("storePaymentMethod", paymentComponentData.getBoolean("storePaymentMethod"));
        paymentRequest.put("returnUrl", (Object)RedirectComponent.getReturnUrl((Context)this.getApplicationContext()));
        paymentRequest.put("channel", (Object)"Android");
        Logger.v((String)TAG, (String)("paymentComponentData - " + JsonUtils.indent((JSONObject)paymentComponentData)));
        String string = paymentRequest.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"paymentRequest.toString()");
        RequestBody requestBody = RequestBody.Companion.create(string, CONTENT_TYPE);
        Call<ResponseBody> call = ApiService.INSTANCE.checkoutApi(configData.getBase_url()).payments(configData.getApp_url_headers(), requestBody);
        return this.handleResponse(call);
    }

    @NotNull
    public CallResult makeDetailsCall(@NotNull JSONObject actionComponentData) {
        Intrinsics.checkParameterIsNotNull((Object)actionComponentData, (String)"actionComponentData");
        Logger.d((String)TAG, (String)"makeDetailsCall");
        Logger.v((String)TAG, (String)("payments/details/ - " + JsonUtils.indent((JSONObject)actionComponentData)));
        AppServiceConfigData configData = AdyenPaymentModule.Companion.getAppServiceConfigData();
        String string = actionComponentData.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"actionComponentData.toString()");
        RequestBody requestBody = RequestBody.Companion.create(string, CONTENT_TYPE);
        Call<ResponseBody> call = ApiService.INSTANCE.checkoutApi(configData.getBase_url()).details(configData.getApp_url_headers(), requestBody);
        return this.handleResponse(call);
    }

    private final CallResult handleResponse(Call<ResponseBody> call) {
        CallResult callResult;
        try {
            CallResult callResult2;
            byte[] byteArray;
            Response response = call.execute();
            ResponseBody responseBody = response.errorBody();
            Object object = byteArray = (Object)(responseBody != null ? responseBody.bytes() : null);
            if (byteArray != null) {
                StringBuilder stringBuilder = new StringBuilder().append("errorBody - ");
                String string = TAG;
                boolean bl = false;
                String string2 = new String(byteArray, Charsets.UTF_8);
                Logger.e((String)string, (String)stringBuilder.append(string2).toString());
            }
            ResponseBody responseBody2 = (ResponseBody)response.body();
            JSONObject detailsResponse = new JSONObject(responseBody2 != null ? responseBody2.string() : null);
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            if (response2.isSuccessful()) {
                if (detailsResponse.has("action")) {
                    callResult2 = new CallResult(CallResult.ResultType.ACTION, detailsResponse.get("action").toString());
                } else {
                    Logger.d((String)TAG, (String)("Final result - " + JsonUtils.indent((JSONObject)detailsResponse)));
                    JSONObject successObj = new JSONObject();
                    successObj.put("resultType", (Object)"SUCCESS");
                    successObj.put("message", (Object)detailsResponse.toString());
                    String string = successObj.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"successObj.toString()");
                    callResult2 = new CallResult(CallResult.ResultType.FINISHED, string);
                }
            } else {
                Logger.e((String)TAG, (String)("FAILED - " + response.message()));
                JSONObject errObj = new JSONObject();
                errObj.put("resultType", (Object)"ERROR");
                errObj.put("code", (Object)"ERROR_GENERAL");
                errObj.put("message", (Object)response.message().toString());
                String string = errObj.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"errObj.toString()");
                callResult2 = new CallResult(CallResult.ResultType.FINISHED, string);
            }
            callResult = callResult2;
        }
        catch (IOException e) {
            Logger.e((String)TAG, (String)"IOException", (Throwable)e);
            JSONObject errObj = new JSONObject();
            errObj.put("resultType", (Object)"ERROR");
            errObj.put("code", (Object)"ERROR_IOEXCEPTION");
            errObj.put("message", (Object)"Unable to Connect to the Server");
            String string = errObj.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"errObj.toString()");
            callResult = new CallResult(CallResult.ResultType.FINISHED, string);
        }
        return callResult;
    }

    static {
        Companion = new Companion(null);
        String string = LogUtil.getTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LogUtil.getTag()");
        TAG = string;
        CONTENT_TYPE = MediaType.Companion.get("application/json");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/rnlib/adyen/AdyenDropInService$Companion;", "", "()V", "CONTENT_TYPE", "Lokhttp3/MediaType;", "TAG", "", "react-native-adyen-payment_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

