/*
 * Decompiled with CFR 0.152.
 */
package com.rnlib.adyen;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReactNativeUtils {
    public static WritableMap convertJsonToMap(JSONObject jsonObject) throws JSONException {
        WritableNativeMap map = new WritableNativeMap();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                map.putMap(key, (ReadableMap)ReactNativeUtils.convertJsonToMap((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                map.putArray(key, (ReadableArray)ReactNativeUtils.convertJsonToArray((JSONArray)value));
                continue;
            }
            if (value instanceof Boolean) {
                map.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                map.putInt(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Double) {
                map.putDouble(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof String) {
                map.putString(key, (String)value);
                continue;
            }
            map.putString(key, value.toString());
        }
        return map;
    }

    public static WritableArray convertJsonToArray(JSONArray jsonArray) throws JSONException {
        WritableNativeArray array = new WritableNativeArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.get(i);
            if (value instanceof JSONObject) {
                array.pushMap((ReadableMap)ReactNativeUtils.convertJsonToMap((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                array.pushArray((ReadableArray)ReactNativeUtils.convertJsonToArray((JSONArray)value));
                continue;
            }
            if (value instanceof Boolean) {
                array.pushBoolean(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                array.pushInt(((Integer)value).intValue());
                continue;
            }
            if (value instanceof Double) {
                array.pushDouble(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof String) {
                array.pushString((String)value);
                continue;
            }
            array.pushString(value.toString());
        }
        return array;
    }

    public static JSONObject convertMapToJson(ReadableMap readableMap) throws JSONException {
        JSONObject object = new JSONObject();
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            switch (readableMap.getType(key)) {
                case Null: {
                    object.put(key, JSONObject.NULL);
                    break;
                }
                case Boolean: {
                    object.put(key, readableMap.getBoolean(key));
                    break;
                }
                case Number: {
                    object.put(key, readableMap.getDouble(key));
                    break;
                }
                case String: {
                    object.put(key, (Object)readableMap.getString(key));
                    break;
                }
                case Map: {
                    object.put(key, (Object)ReactNativeUtils.convertMapToJson(readableMap.getMap(key)));
                    break;
                }
                case Array: {
                    object.put(key, (Object)ReactNativeUtils.convertArrayToJson(readableMap.getArray(key)));
                }
            }
        }
        return object;
    }

    public static JSONArray convertArrayToJson(ReadableArray readableArray) throws JSONException {
        JSONArray array = new JSONArray();
        block8: for (int i = 0; i < readableArray.size(); ++i) {
            switch (readableArray.getType(i)) {
                case Null: {
                    continue block8;
                }
                case Boolean: {
                    array.put(readableArray.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    array.put(readableArray.getDouble(i));
                    continue block8;
                }
                case String: {
                    array.put((Object)readableArray.getString(i));
                    continue block8;
                }
                case Map: {
                    array.put((Object)ReactNativeUtils.convertMapToJson(readableArray.getMap(i)));
                    continue block8;
                }
                case Array: {
                    array.put((Object)ReactNativeUtils.convertArrayToJson(readableArray.getArray(i)));
                }
            }
        }
        return array;
    }
}

