/*
 * Decompiled with CFR 0.152.
 */
package com.rn.amapmodule;

import android.content.Context;
import com.amap.api.location.AMapLocation;
import com.amap.api.location.AMapLocationClient;
import com.amap.api.location.AMapLocationClientOption;
import com.amap.api.location.AMapLocationListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.WritableMap;

public class YFAmapLocation
implements AMapLocationListener {
    private static final String ERROR_2 = "-1002";
    private static final String ERROR_3 = "-1003";
    private static final String ERROR_6 = "-1006";
    private AMapLocationClient locationClient = null;
    private AMapLocationClientOption locationOption = null;
    private Promise locationPromise = null;

    YFAmapLocation(Context context) {
        this.locationClient = new AMapLocationClient(context);
        this.locationOption = new AMapLocationClientOption();
        this.locationOption.setLocationMode(AMapLocationClientOption.AMapLocationMode.Hight_Accuracy);
        this.locationOption.setOnceLocation(true);
        this.locationOption.setOnceLocationLatest(true);
        this.locationOption.setLocationCacheEnable(false);
        this.locationClient.setLocationOption(this.locationOption);
        this.locationClient.setLocationListener((AMapLocationListener)this);
    }

    public void onLocationChanged(AMapLocation aMapLocation) {
        if (aMapLocation != null) {
            WritableMap map = Arguments.createMap();
            double longitude = aMapLocation.getLongitude();
            double latitude = aMapLocation.getLatitude();
            if (0.0 == latitude || 0.0 == longitude) {
                this.locationPromise.reject(ERROR_6, "\u7ecf\u7eac\u5ea6\u4fe1\u606f\u4e3a0");
                return;
            }
            map.putDouble("longitude", longitude);
            map.putDouble("latitude", latitude);
            String country = null == aMapLocation.getCountry() ? "" : aMapLocation.getCountry();
            String province = null == aMapLocation.getProvince() ? "" : aMapLocation.getProvince();
            String city = null == aMapLocation.getCity() ? "" : aMapLocation.getCity();
            String district = null == aMapLocation.getDistrict() ? "" : aMapLocation.getDistrict();
            String adcode = null == aMapLocation.getAdCode() ? "" : aMapLocation.getAdCode();
            String street = null == aMapLocation.getStreet() ? "" : aMapLocation.getStreet();
            map.putString("country", country);
            map.putString("province", province);
            map.putString("city", city);
            map.putString("district", district);
            map.putString("adcode", adcode);
            map.putString("street", street);
            this.locationPromise.resolve((Object)map);
        } else {
            this.locationPromise.reject(ERROR_2, "\u5b9a\u4f4d\u9519\u8bef");
        }
    }

    public void startLocation(Promise promise) {
        this.locationPromise = promise;
        this.locationClient.startLocation();
    }

    public void startRegeocode(Promise promise) {
    }

    public void stopLocation(Promise promise) {
        this.locationClient.stopLocation();
    }
}

