/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.CxxModuleWrapperBase;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.JavaModuleWrapper;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NativeModuleRegistry {
    private final ReactApplicationContext mReactApplicationContext;
    private final Map<Class<? extends NativeModule>, ModuleHolder> mModules;
    private final ArrayList<ModuleHolder> mBatchCompleteListenerModules;

    public NativeModuleRegistry(ReactApplicationContext reactApplicationContext, Map<Class<? extends NativeModule>, ModuleHolder> modules, ArrayList<ModuleHolder> batchCompleteListenerModules) {
        this.mReactApplicationContext = reactApplicationContext;
        this.mModules = modules;
        this.mBatchCompleteListenerModules = batchCompleteListenerModules;
    }

    private Map<Class<? extends NativeModule>, ModuleHolder> getModuleMap() {
        return this.mModules;
    }

    private ReactApplicationContext getReactApplicationContext() {
        return this.mReactApplicationContext;
    }

    private ArrayList<ModuleHolder> getBatchCompleteListenerModules() {
        return this.mBatchCompleteListenerModules;
    }

    Collection<JavaModuleWrapper> getJavaModules(JSInstance jsInstance) {
        ArrayList<JavaModuleWrapper> javaModules = new ArrayList<JavaModuleWrapper>();
        for (Map.Entry<Class<? extends NativeModule>, ModuleHolder> entry : this.mModules.entrySet()) {
            Class<? extends NativeModule> type = entry.getKey();
            if (CxxModuleWrapperBase.class.isAssignableFrom(type)) continue;
            javaModules.add(new JavaModuleWrapper(jsInstance, type, entry.getValue()));
        }
        return javaModules;
    }

    Collection<ModuleHolder> getCxxModules() {
        ArrayList<ModuleHolder> cxxModules = new ArrayList<ModuleHolder>();
        for (Map.Entry<Class<? extends NativeModule>, ModuleHolder> entry : this.mModules.entrySet()) {
            Class<? extends NativeModule> type = entry.getKey();
            if (!CxxModuleWrapperBase.class.isAssignableFrom(type)) continue;
            cxxModules.add(entry.getValue());
        }
        return cxxModules;
    }

    void registerModules(NativeModuleRegistry newRegister) {
        Assertions.assertCondition((boolean)((Object)((Object)this.mReactApplicationContext)).equals((Object)newRegister.getReactApplicationContext()), (String)"Extending native modules with non-matching application contexts.");
        Map<Class<? extends NativeModule>, ModuleHolder> newModules = newRegister.getModuleMap();
        ArrayList<ModuleHolder> batchCompleteListeners = newRegister.getBatchCompleteListenerModules();
        for (Map.Entry<Class<? extends NativeModule>, ModuleHolder> entry : newModules.entrySet()) {
            Class<? extends NativeModule> key = entry.getKey();
            if (this.mModules.containsKey(key)) continue;
            ModuleHolder value = entry.getValue();
            if (batchCompleteListeners.contains(value)) {
                this.mBatchCompleteListenerModules.add(value);
            }
            this.mModules.put(key, value);
        }
    }

    void notifyJSInstanceDestroy() {
        this.mReactApplicationContext.assertOnNativeModulesQueueThread();
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyJSInstanceDestroy");
        try {
            for (ModuleHolder module : this.mModules.values()) {
                module.destroy();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    void notifyJSInstanceInitialized() {
        this.mReactApplicationContext.assertOnNativeModulesQueueThread("From version React Native v0.44, native modules are explicitly not initialized on the UI thread. See https://github.com/facebook/react-native/wiki/Breaking-Changes#d4611211-reactnativeandroidbreaking-move-nativemodule-initialization-off-ui-thread---aaachiuuu  for more details.");
        ReactMarker.logMarker(ReactMarkerConstants.NATIVE_MODULE_INITIALIZE_START);
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyJSInstanceInitialized");
        try {
            for (ModuleHolder module : this.mModules.values()) {
                module.markInitializable();
            }
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.NATIVE_MODULE_INITIALIZE_END);
        }
    }

    public void onBatchComplete() {
        for (ModuleHolder moduleHolder : this.mBatchCompleteListenerModules) {
            if (!moduleHolder.hasInstance()) continue;
            ((OnBatchCompleteListener)((Object)moduleHolder.getModule())).onBatchComplete();
        }
    }

    public <T extends NativeModule> boolean hasModule(Class<T> moduleInterface) {
        return this.mModules.containsKey(moduleInterface);
    }

    public <T extends NativeModule> T getModule(Class<T> moduleInterface) {
        return (T)((ModuleHolder)Assertions.assertNotNull((Object)this.mModules.get(moduleInterface))).getModule();
    }

    public List<NativeModule> getAllModules() {
        ArrayList<NativeModule> modules = new ArrayList<NativeModule>();
        for (ModuleHolder module : this.mModules.values()) {
            modules.add(module.getModule());
        }
        return modules;
    }
}

