/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import com.facebook.react.flat.AbstractDrawBorder;
import javax.annotation.Nullable;

final class DrawBorder
extends AbstractDrawBorder {
    private static final Paint PAINT = new Paint(1);
    private static final float[] TMP_FLOAT_ARRAY = new float[4];
    private static final int BORDER_STYLE_SOLID = 0;
    private static final int BORDER_STYLE_DOTTED = 1;
    private static final int BORDER_STYLE_DASHED = 2;
    private static final int BORDER_LEFT_COLOR_SET = 2;
    private static final int BORDER_TOP_COLOR_SET = 4;
    private static final int BORDER_RIGHT_COLOR_SET = 8;
    private static final int BORDER_BOTTOM_COLOR_SET = 16;
    private static final int BORDER_PATH_EFFECT_DIRTY = 32;
    private static final int ALL_BITS_SET = -1;
    private static final int ALL_BITS_UNSET = 0;
    private float mBorderLeftWidth;
    private float mBorderTopWidth;
    private float mBorderRightWidth;
    private float mBorderBottomWidth;
    private int mBorderLeftColor;
    private int mBorderTopColor;
    private int mBorderRightColor;
    private int mBorderBottomColor;
    private int mBorderStyle = 0;
    private int mBackgroundColor;
    @Nullable
    private DashPathEffect mPathEffectForBorderStyle;
    @Nullable
    private Path mPathForBorder;

    DrawBorder() {
    }

    public void setBorderWidth(int position, float borderWidth) {
        switch (position) {
            case 0: {
                this.mBorderLeftWidth = borderWidth;
                break;
            }
            case 1: {
                this.mBorderTopWidth = borderWidth;
                break;
            }
            case 2: {
                this.mBorderRightWidth = borderWidth;
                break;
            }
            case 3: {
                this.mBorderBottomWidth = borderWidth;
                break;
            }
            case 8: {
                this.setBorderWidth(borderWidth);
            }
        }
    }

    public float getBorderWidth(int position) {
        switch (position) {
            case 0: {
                return this.mBorderLeftWidth;
            }
            case 1: {
                return this.mBorderTopWidth;
            }
            case 2: {
                return this.mBorderRightWidth;
            }
            case 3: {
                return this.mBorderBottomWidth;
            }
            case 8: {
                return this.getBorderWidth();
            }
        }
        return 0.0f;
    }

    public void setBorderStyle(@Nullable String style) {
        this.mBorderStyle = "dotted".equals(style) ? 1 : ("dashed".equals(style) ? 2 : 0);
        this.setFlag(32);
    }

    public void resetBorderColor(int position) {
        switch (position) {
            case 0: {
                this.resetFlag(2);
                break;
            }
            case 1: {
                this.resetFlag(4);
                break;
            }
            case 2: {
                this.resetFlag(8);
                break;
            }
            case 3: {
                this.resetFlag(16);
                break;
            }
            case 8: {
                this.setBorderColor(-16777216);
            }
        }
    }

    public void setBorderColor(int position, int borderColor) {
        switch (position) {
            case 0: {
                this.mBorderLeftColor = borderColor;
                this.setFlag(2);
                break;
            }
            case 1: {
                this.mBorderTopColor = borderColor;
                this.setFlag(4);
                break;
            }
            case 2: {
                this.mBorderRightColor = borderColor;
                this.setFlag(8);
                break;
            }
            case 3: {
                this.mBorderBottomColor = borderColor;
                this.setFlag(16);
                break;
            }
            case 8: {
                this.setBorderColor(borderColor);
            }
        }
    }

    public int getBorderColor(int position) {
        int defaultColor = this.getBorderColor();
        switch (position) {
            case 0: {
                return this.resolveBorderColor(2, this.mBorderLeftColor, defaultColor);
            }
            case 1: {
                return this.resolveBorderColor(4, this.mBorderTopColor, defaultColor);
            }
            case 2: {
                return this.resolveBorderColor(8, this.mBorderRightColor, defaultColor);
            }
            case 3: {
                return this.resolveBorderColor(16, this.mBorderBottomColor, defaultColor);
            }
            case 8: {
                return defaultColor;
            }
        }
        return defaultColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.getBorderRadius() >= 0.5f || this.getPathEffectForBorderStyle() != null) {
            this.drawRoundedBorders(canvas);
        } else {
            this.drawRectangularBorders(canvas);
        }
    }

    @Nullable
    protected DashPathEffect getPathEffectForBorderStyle() {
        if (this.isFlagSet(32)) {
            switch (this.mBorderStyle) {
                case 1: {
                    this.mPathEffectForBorderStyle = DrawBorder.createDashPathEffect(this.getBorderWidth());
                    break;
                }
                case 2: {
                    this.mPathEffectForBorderStyle = DrawBorder.createDashPathEffect(this.getBorderWidth() * 3.0f);
                    break;
                }
                default: {
                    this.mPathEffectForBorderStyle = null;
                }
            }
            this.resetFlag(32);
        }
        return this.mPathEffectForBorderStyle;
    }

    private void drawRoundedBorders(Canvas canvas) {
        if (this.mBackgroundColor != 0) {
            PAINT.setColor(this.mBackgroundColor);
            canvas.drawPath(this.getPathForBorderRadius(), PAINT);
        }
        this.drawBorders(canvas);
    }

    private static int fastBorderCompatibleColorOrZero(float borderLeft, float borderTop, float borderRight, float borderBottom, int colorLeft, int colorTop, int colorRight, int colorBottom) {
        int andSmear = (borderLeft > 0.0f ? colorLeft : -1) & (borderTop > 0.0f ? colorTop : -1) & (borderRight > 0.0f ? colorRight : -1) & (borderBottom > 0.0f ? colorBottom : -1);
        int orSmear = (borderLeft > 0.0f ? colorLeft : 0) | (borderTop > 0.0f ? colorTop : 0) | (borderRight > 0.0f ? colorRight : 0) | (borderBottom > 0.0f ? colorBottom : 0);
        return andSmear == orSmear ? andSmear : 0;
    }

    private void drawRectangularBorders(Canvas canvas) {
        int defaultColor = this.getBorderColor();
        float defaultWidth = this.getBorderWidth();
        float top = this.getTop();
        float borderTop = DrawBorder.resolveWidth(this.mBorderTopWidth, defaultWidth);
        float topInset = top + borderTop;
        int topColor = this.resolveBorderColor(4, this.mBorderTopColor, defaultColor);
        float bottom = this.getBottom();
        float borderBottom = DrawBorder.resolveWidth(this.mBorderBottomWidth, defaultWidth);
        float bottomInset = bottom - borderBottom;
        int bottomColor = this.resolveBorderColor(16, this.mBorderBottomColor, defaultColor);
        float left = this.getLeft();
        float borderLeft = DrawBorder.resolveWidth(this.mBorderLeftWidth, defaultWidth);
        float leftInset = left + borderLeft;
        int leftColor = this.resolveBorderColor(2, this.mBorderLeftColor, defaultColor);
        float right = this.getRight();
        float borderRight = DrawBorder.resolveWidth(this.mBorderRightWidth, defaultWidth);
        float rightInset = right - borderRight;
        int rightColor = this.resolveBorderColor(8, this.mBorderRightColor, defaultColor);
        int fastBorderColor = DrawBorder.fastBorderCompatibleColorOrZero(borderLeft, borderTop, borderRight, borderBottom, leftColor, topColor, rightColor, bottomColor);
        if (fastBorderColor != 0) {
            if (Color.alpha((int)fastBorderColor) != 0) {
                if (Color.alpha((int)this.mBackgroundColor) != 0) {
                    PAINT.setColor(this.mBackgroundColor);
                    if (Color.alpha((int)fastBorderColor) == 255) {
                        canvas.drawRect(leftInset, topInset, rightInset, bottomInset, PAINT);
                    } else {
                        canvas.drawRect(left, top, right, bottom, PAINT);
                    }
                }
                PAINT.setColor(fastBorderColor);
                if (borderLeft > 0.0f) {
                    canvas.drawRect(left, top, leftInset, bottom - borderBottom, PAINT);
                }
                if (borderTop > 0.0f) {
                    canvas.drawRect(left + borderLeft, top, right, topInset, PAINT);
                }
                if (borderRight > 0.0f) {
                    canvas.drawRect(rightInset, top + borderTop, right, bottom, PAINT);
                }
                if (borderBottom > 0.0f) {
                    canvas.drawRect(left, bottomInset, right - borderRight, bottom, PAINT);
                }
            }
        } else {
            if (this.mPathForBorder == null) {
                this.mPathForBorder = new Path();
            }
            if (Color.alpha((int)this.mBackgroundColor) != 0) {
                PAINT.setColor(this.mBackgroundColor);
                canvas.drawRect(left, top, right, bottom, PAINT);
            }
            if (borderTop != 0.0f && Color.alpha((int)topColor) != 0) {
                PAINT.setColor(topColor);
                DrawBorder.updatePathForTopBorder(this.mPathForBorder, top, topInset, left, leftInset, right, rightInset);
                canvas.drawPath(this.mPathForBorder, PAINT);
            }
            if (borderBottom != 0.0f && Color.alpha((int)bottomColor) != 0) {
                PAINT.setColor(bottomColor);
                DrawBorder.updatePathForBottomBorder(this.mPathForBorder, bottom, bottomInset, left, leftInset, right, rightInset);
                canvas.drawPath(this.mPathForBorder, PAINT);
            }
            if (borderLeft != 0.0f && Color.alpha((int)leftColor) != 0) {
                PAINT.setColor(leftColor);
                DrawBorder.updatePathForLeftBorder(this.mPathForBorder, top, topInset, bottom, bottomInset, left, leftInset);
                canvas.drawPath(this.mPathForBorder, PAINT);
            }
            if (borderRight != 0.0f && Color.alpha((int)rightColor) != 0) {
                PAINT.setColor(rightColor);
                DrawBorder.updatePathForRightBorder(this.mPathForBorder, top, topInset, bottom, bottomInset, right, rightInset);
                canvas.drawPath(this.mPathForBorder, PAINT);
            }
        }
    }

    private static void updatePathForTopBorder(Path path, float top, float topInset, float left, float leftInset, float right, float rightInset) {
        path.reset();
        path.moveTo(left, top);
        path.lineTo(leftInset, topInset);
        path.lineTo(rightInset, topInset);
        path.lineTo(right, top);
        path.lineTo(left, top);
    }

    private static void updatePathForBottomBorder(Path path, float bottom, float bottomInset, float left, float leftInset, float right, float rightInset) {
        path.reset();
        path.moveTo(left, bottom);
        path.lineTo(right, bottom);
        path.lineTo(rightInset, bottomInset);
        path.lineTo(leftInset, bottomInset);
        path.lineTo(left, bottom);
    }

    private static void updatePathForLeftBorder(Path path, float top, float topInset, float bottom, float bottomInset, float left, float leftInset) {
        path.reset();
        path.moveTo(left, top);
        path.lineTo(leftInset, topInset);
        path.lineTo(leftInset, bottomInset);
        path.lineTo(left, bottom);
        path.lineTo(left, top);
    }

    private static void updatePathForRightBorder(Path path, float top, float topInset, float bottom, float bottomInset, float right, float rightInset) {
        path.reset();
        path.moveTo(right, top);
        path.lineTo(right, bottom);
        path.lineTo(rightInset, bottomInset);
        path.lineTo(rightInset, topInset);
        path.lineTo(right, top);
    }

    private int resolveBorderColor(int flag, int color, int defaultColor) {
        return this.isFlagSet(flag) ? color : defaultColor;
    }

    private static float resolveWidth(float width, float defaultWidth) {
        return width == 0.0f || width != width ? defaultWidth : width;
    }

    private static DashPathEffect createDashPathEffect(float borderWidth) {
        for (int i = 0; i < 4; ++i) {
            DrawBorder.TMP_FLOAT_ARRAY[i] = borderWidth;
        }
        return new DashPathEffect(TMP_FLOAT_ARRAY, 0.0f);
    }
}

