/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewParent;
import com.facebook.react.flat.DrawCommand;
import com.facebook.react.flat.FlatViewGroup;
import com.facebook.react.flat.NodeRegion;
import com.facebook.react.flat.VerticalDrawCommandManager;
import com.facebook.react.flat.ViewResolver;
import javax.annotation.Nullable;

abstract class DrawCommandManager {
    DrawCommandManager() {
    }

    abstract void mountDrawCommands(DrawCommand[] var1, SparseIntArray var2, float[] var3, float[] var4, boolean var5);

    abstract void mountViews(ViewResolver var1, int[] var2, int[] var3);

    abstract boolean updateClippingRect();

    abstract void getClippingRect(Rect var1);

    abstract SparseArray<View> getDetachedViews();

    abstract void draw(Canvas var1);

    abstract void debugDraw(Canvas var1);

    abstract void mountNodeRegions(NodeRegion[] var1, float[] var2, float[] var3);

    @Nullable
    abstract NodeRegion anyNodeRegionWithinBounds(float var1, float var2);

    @Nullable
    abstract NodeRegion virtualNodeRegionWithinBounds(float var1, float var2);

    abstract void onClippedViewDropped(View var1);

    protected static void ensureViewHasNoParent(View view) {
        ViewParent oldParent = view.getParent();
        if (oldParent != null) {
            throw new RuntimeException("Cannot add view " + view + " to DrawCommandManager while it has a parent " + oldParent);
        }
    }

    static DrawCommandManager getVerticalClippingInstance(FlatViewGroup flatViewGroup, DrawCommand[] drawCommands) {
        return new VerticalDrawCommandManager(flatViewGroup, drawCommands);
    }
}

