/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.clipboard;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import com.facebook.react.bridge.ContextBaseJavaModule;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="Clipboard")
public class ClipboardModule
extends ContextBaseJavaModule {
    public ClipboardModule(Context context) {
        super(context);
    }

    @Override
    public String getName() {
        return "Clipboard";
    }

    private ClipboardManager getClipboardService() {
        Context context = this.getContext();
        this.getContext();
        return (ClipboardManager)context.getSystemService("clipboard");
    }

    @ReactMethod
    public void getString(Promise promise) {
        try {
            ClipboardManager clipboard = this.getClipboardService();
            ClipData clipData = clipboard.getPrimaryClip();
            if (clipData == null) {
                promise.resolve("");
            } else if (clipData.getItemCount() >= 1) {
                ClipData.Item firstItem = clipboard.getPrimaryClip().getItemAt(0);
                promise.resolve("" + firstItem.getText());
            } else {
                promise.resolve("");
            }
        }
        catch (Exception e) {
            promise.reject(e);
        }
    }

    @ReactMethod
    @SuppressLint(value={"DeprecatedMethod"})
    public void setString(String text) {
        if (Build.VERSION.SDK_INT >= 11) {
            ClipData clipdata = ClipData.newPlainText(null, (CharSequence)text);
            ClipboardManager clipboard = this.getClipboardService();
            clipboard.setPrimaryClip(clipdata);
        } else {
            ClipboardManager clipboard = this.getClipboardService();
            clipboard.setText((CharSequence)text);
        }
    }
}

