/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.util;

import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ReactFindViewUtil {
    private static final List<OnViewFoundListener> mOnViewFoundListeners = new ArrayList<OnViewFoundListener>();
    private static final Map<OnMultipleViewsFoundListener, Set<String>> mOnMultipleViewsFoundListener = new HashMap<OnMultipleViewsFoundListener, Set<String>>();

    @Nullable
    public static View findView(View root, String nativeId) {
        String tag = ReactFindViewUtil.getNativeId(root);
        if (tag != null && tag.equals(nativeId)) {
            return root;
        }
        if (root instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)root;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View view = ReactFindViewUtil.findView(viewGroup.getChildAt(i), nativeId);
                if (view == null) continue;
                return view;
            }
        }
        return null;
    }

    public static void findView(View root, OnViewFoundListener onViewFoundListener) {
        View view = ReactFindViewUtil.findView(root, onViewFoundListener.getNativeId());
        if (view != null) {
            onViewFoundListener.onViewFound(view);
        }
        ReactFindViewUtil.addViewListener(onViewFoundListener);
    }

    public static void addViewListener(OnViewFoundListener onViewFoundListener) {
        mOnViewFoundListeners.add(onViewFoundListener);
    }

    public static void removeViewListener(OnViewFoundListener onViewFoundListener) {
        mOnViewFoundListeners.remove(onViewFoundListener);
    }

    public static void addViewsListener(OnMultipleViewsFoundListener listener, Set<String> ids) {
        mOnMultipleViewsFoundListener.put(listener, ids);
    }

    public static void removeViewsListener(OnMultipleViewsFoundListener listener) {
        mOnMultipleViewsFoundListener.remove(listener);
    }

    public static void notifyViewRendered(View view) {
        String nativeId = ReactFindViewUtil.getNativeId(view);
        if (nativeId == null) {
            return;
        }
        Iterator<OnViewFoundListener> iterator = mOnViewFoundListeners.iterator();
        while (iterator.hasNext()) {
            OnViewFoundListener listener = iterator.next();
            if (nativeId == null || !nativeId.equals(listener.getNativeId())) continue;
            listener.onViewFound(view);
            iterator.remove();
        }
        Iterator<Map.Entry<OnMultipleViewsFoundListener, Set<String>>> viewIterator = mOnMultipleViewsFoundListener.entrySet().iterator();
        while (viewIterator.hasNext()) {
            Map.Entry<OnMultipleViewsFoundListener, Set<String>> entry = viewIterator.next();
            Set<String> nativeIds = entry.getValue();
            if (nativeIds.contains(nativeId)) {
                entry.getKey().onViewFound(view, nativeId);
                nativeIds.remove(nativeId);
            }
            if (!nativeIds.isEmpty()) continue;
            viewIterator.remove();
        }
    }

    @Nullable
    private static String getNativeId(View view) {
        Object tag = view.getTag(R.id.view_tag_native_id);
        return tag instanceof String ? (String)tag : null;
    }

    public static interface OnMultipleViewsFoundListener {
        public void onViewFound(View var1, String var2);
    }

    public static interface OnViewFoundListener {
        public String getNativeId();

        public void onViewFound(View var1);
    }
}

