/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.imagehelper;

import android.content.Context;
import android.net.Uri;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import javax.annotation.Nullable;

public class ImageSource {
    @Nullable
    private Uri mUri;
    private String mSource;
    private double mSize;
    private boolean isResource;

    public ImageSource(Context context, String source, double width, double height) {
        this.mSource = source;
        this.mSize = width * height;
        this.mUri = this.computeUri(context);
    }

    public ImageSource(Context context, String source) {
        this(context, source, 0.0, 0.0);
    }

    public String getSource() {
        return this.mSource;
    }

    public Uri getUri() {
        return (Uri)Assertions.assertNotNull((Object)this.mUri);
    }

    public double getSize() {
        return this.mSize;
    }

    public boolean isResource() {
        return this.isResource;
    }

    private Uri computeUri(Context context) {
        try {
            Uri uri = Uri.parse((String)this.mSource);
            return uri.getScheme() == null ? this.computeLocalUri(context) : uri;
        }
        catch (Exception e) {
            return this.computeLocalUri(context);
        }
    }

    private Uri computeLocalUri(Context context) {
        this.isResource = true;
        return ResourceDrawableIdHelper.getInstance().getResourceDrawableUri(context, this.mSource);
    }
}

