/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.yoga;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.yoga.YogaUnit;

@DoNotStrip
public class YogaValue {
    static final YogaValue UNDEFINED = new YogaValue(1.0E21f, YogaUnit.UNDEFINED);
    static final YogaValue ZERO = new YogaValue(0.0f, YogaUnit.POINT);
    static final YogaValue AUTO = new YogaValue(1.0E21f, YogaUnit.AUTO);
    public final float value;
    public final YogaUnit unit;

    public YogaValue(float value, YogaUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @DoNotStrip
    YogaValue(float value, int unit) {
        this(value, YogaUnit.fromInt(unit));
    }

    public boolean equals(Object other) {
        if (other instanceof YogaValue) {
            YogaValue otherValue = (YogaValue)other;
            if (this.unit == otherValue.unit) {
                return this.unit == YogaUnit.UNDEFINED || Float.compare(this.value, otherValue.value) == 0;
            }
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value) + this.unit.intValue();
    }

    public String toString() {
        switch (this.unit) {
            case UNDEFINED: {
                return "undefined";
            }
            case POINT: {
                return Float.toString(this.value);
            }
            case PERCENT: {
                return this.value + "%";
            }
            case AUTO: {
                return "auto";
            }
        }
        throw new IllegalStateException();
    }

    public static YogaValue parse(String s) {
        if (s == null) {
            return null;
        }
        if ("undefined".equals(s)) {
            return UNDEFINED;
        }
        if ("auto".equals(s)) {
            return AUTO;
        }
        if (s.endsWith("%")) {
            return new YogaValue(Float.parseFloat(s.substring(0, s.length() - 1)), YogaUnit.PERCENT);
        }
        return new YogaValue(Float.parseFloat(s), YogaUnit.POINT);
    }
}

